<?php
/**
 * RichPage - module richpage_view
 *
 * Creates the menu for the user to change rich page informations
 * (subtitle,use_sub_in_title,slogan,logo_pri,logo_sec) per page.
 *
 * @author Alf Gaida
 * @link http://www.g-com.eu
 * @version 0.1.2
 * @package pluginloader
 * @subpackage richpage
 *
 **/

/**
 * richpage_view()
 *
 * @param array $page Gets cleaned of unallowed
 * doublequotes, that will destroy input-fields
 * @return string $view Returns the created view
 **/

function richpage_view($page){
    global $sn, $su, $plugin_tx, $pth;
    array_walk($page, create_function('&$data','$data=str_replace("\"", "&quot;", $data);'));

    $lang = $plugin_tx['richpage'];
    $help_icon = tag('img src="'. $pth['folder']['plugins'] . "richpage/css/help_icon.png\" alt=\"\" class=\"helpicon\" ");

    $my_fields = array('subtitle','use_sub_in_title','slogan','logo_pri','logo_pri_link','logo_pri_style','logo_sec','logo_sec_link','logo_sec_style','favicon','separator','enabled');

    $view ="\n<form action=\"$sn?$su\" method=\"post\" id=\"richpage\" >";
    $view .= "\n\t<p><b>" . $lang['form_title'] . "</b></p>\n";

    foreach($my_fields as $field){
        $view .= "\n\t <a class=\"pl_tooltip\" href=\"#\" >$help_icon <span>" . $lang["hint_$field"] . "</span></a>";
        $view .= "\n\t <label for = \"$field\"><span class=\"rp_label\">$lang[$field]</span></label>" . tag('br');
        $view .= "\n\t\t" . tag("input type=\"text\" size=\"50\" name=\"$field\" id=\"$field\" value=\"$page[$field]\" ").tag('hr');
    }
    $view .= "\n\t" . tag("input name=\"save_page_data\" type=\"hidden\" ");
    $view .= "\n\t<div style=\"text-align: right;\">";
    $view .= "\n\t\t" . tag('input type="submit" value="' . $lang['submit'] . '"') . tag('br');
    $view .= "\n\t</div>";
    $view .= "\n</form>";
    return $view;
}
?>
