/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.hex;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.zaproxy.zap.utils.ByteBuilder;

public class HttpPanelHexModel
extends AbstractTableModel {
    private static final String[] hexSymbols = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static final int BITS_PER_HEX_DIGIT = 4;
    private static final int COLUMN_COUNT = 34;
    private static final long serialVersionUID = 1L;
    private List<String[]> listRow = new ArrayList<String[]>();
    private boolean editable = false;
    private boolean changed = false;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public int getColumnCount() {
        return 34;
    }

    @Override
    public int getRowCount() {
        return this.listRow.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.listRow.get(row)[col];
    }

    private boolean isHexColumn(int col) {
        return col > 0 && col <= 16;
    }

    private boolean isCharColumn(int col) {
        return col > 17;
    }

    @Override
    public String getColumnName(int col) {
        if (this.isHexColumn(col)) {
            return Integer.toHexString(col - 1);
        }
        if (this.isCharColumn(col)) {
            return Integer.toHexString(col - 18);
        }
        return "";
    }

    public static String toHexFromByte(byte b) {
        byte leftSymbol = (byte)(b >>> 4 & 0xF);
        byte rightSymbol = (byte)(b & 0xF);
        return hexSymbols[leftSymbol] + hexSymbols[rightSymbol];
    }

    private String[] newRow() {
        String[] row = new String[34];
        row[0] = String.format("%08x", this.listRow.size() * 16);
        return row;
    }

    private void setHex(String[] row, int index, byte b) {
        row[index] = HttpPanelHexModel.toHexFromByte(b);
        row[index + 17] = String.valueOf((char)b);
    }

    private void setChar(String[] row, int index, char c) {
        row[index - 17] = HttpPanelHexModel.toHexFromByte((byte)c);
        row[index] = String.valueOf(c);
    }

    public synchronized void setData(byte[] body) {
        this.listRow.clear();
        if (body.length != 0 || this.isEditable()) {
            int rowIndex = 0;
            String[] row = this.newRow();
            this.listRow.add(row);
            for (int index = 0; index < body.length; ++index) {
                this.setHex(row, rowIndex + 1, body[index]);
                if (++rowIndex < 16) continue;
                row = this.newRow();
                this.listRow.add(row);
                rowIndex = 0;
            }
        }
        this.fireTableDataChanged();
        this.changed = false;
    }

    public synchronized byte[] getData() {
        ByteBuilder bb = new ByteBuilder();
        for (String[] row : this.listRow) {
            for (int i = 1; i < 17 && row[i] != null && row[i].length() != 0; ++i) {
                bb.append((char)Integer.parseInt(row[i], 16));
            }
        }
        return bb.toByteArray();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isEditable()) {
            return false;
        }
        if (!this.isHexColumn(columnIndex) && !this.isCharColumn(columnIndex)) {
            return false;
        }
        if (rowIndex < this.listRow.size() - 1) {
            return true;
        }
        String[] row = this.listRow.get(rowIndex);
        if (!this.isCharColumn(columnIndex)) {
            return row[columnIndex - 1] != null;
        }
        return row[columnIndex - 1] != null || columnIndex == 18;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String val = (String)value;
        byte byteVal = -1;
        char charVal = '\u0000';
        if (this.isHexColumn(col)) {
            if (val.length() > 2) {
                return;
            }
            try {
                byteVal = (byte)Integer.parseInt(val, 16);
            }
            catch (NumberFormatException e) {
                return;
            }
        } else if (this.isCharColumn(col)) {
            if (val.length() != 1) {
                return;
            }
            charVal = val.charAt(0);
        } else {
            return;
        }
        String[] cell = this.listRow.get(row);
        if (this.isHexColumn(col)) {
            this.setHex(cell, col, byteVal);
        } else {
            this.setChar(cell, col, charVal);
        }
        int lastRowChanged = row;
        if (row == this.listRow.size() - 1 && cell[16] != null) {
            this.listRow.add(this.newRow());
            ++lastRowChanged;
        }
        this.fireTableRowsUpdated(row, lastRowChanged);
        this.changed = true;
    }

    public boolean hasChanged() {
        return this.changed;
    }
}

