// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeUnsignedShortArray
 * @brief   composite implicit array of unsigned short.
 *
 * vtkCompositeUnsignedShortArray is a composite implicit array of values of type unsigned short.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkCompositeUnsignedShortArray_h
#define vtkCompositeUnsignedShortArray_h

#include "vtkCompositeArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<unsigned short>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT vtkCompositeUnsignedShortArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeUnsignedShortArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeUnsignedShortArray* New();
  static vtkCompositeUnsignedShortArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned short);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeUnsignedShortArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeUnsignedShortArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeUnsignedShortArray();
  ~vtkCompositeUnsignedShortArray() override;

private:
  typedef vtkCompositeArray<unsigned short> RealSuperclass;

  vtkCompositeUnsignedShortArray(const vtkCompositeUnsignedShortArray&) = delete;
  void operator=(const vtkCompositeUnsignedShortArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeUnsignedShortArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
