/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.VirtualThreadExecutor;

public class StandardVirtualThreadExecutor
extends LifecycleMBeanBase
implements Executor,
ExecutorService {
    private static final StringManager sm = StringManager.getManager(StandardVirtualThreadExecutor.class);
    private String name;
    private ExecutorService executor;
    private String namePrefix = "tomcat-virt-";

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String string) {
        this.namePrefix = string;
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.executor == null) {
            throw new IllegalStateException(sm.getString("standardVirtualThreadExecutor.notStarted"));
        }
        this.executor.execute(runnable);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (!JreCompat.isJre21Available()) {
            throw new LifecycleException(sm.getString("standardVirtualThreadExecutor.noVirtualThreads"));
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.executor = new VirtualThreadExecutor(this.getNamePrefix());
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.executor = null;
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected String getDomainInternal() {
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Executor,name=" + this.getName();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        if (this.executor != null) {
            return this.executor.isShutdown();
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public boolean isTerminated() {
        if (this.executor != null) {
            return this.executor.isTerminated();
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (this.executor != null) {
            return this.executor.submit(callable);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        if (this.executor != null) {
            return this.executor.submit(runnable, t);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        if (this.executor != null) {
            return this.executor.submit(runnable);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        if (this.executor != null) {
            return this.executor.invokeAll(collection);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.executor != null) {
            return this.executor.invokeAll(collection, l, timeUnit);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        if (this.executor != null) {
            return this.executor.invokeAny(collection);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.executor != null) {
            return this.executor.invokeAny(collection, l, timeUnit);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }
}

