/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class SetLength
extends ControlSequence {
    public SetLength() {
        this("setlength");
    }

    public SetLength(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new SetLength(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        if (teXParser.isStack(teXObject)) {
            teXObjectList.push(teXObject, true);
            teXObject = this.popArg(teXParser, teXObjectList);
        }
        teXObject = TeXParserUtils.resolve(teXObject, teXParser);
        TeXDimension teXDimension = this.popDimensionArg(teXParser, teXObjectList);
        if (teXObject instanceof InternalQuantity) {
            ((InternalQuantity)teXObject).setQuantity(teXParser, teXDimension);
        } else {
            if (!(teXObject instanceof ControlSequence)) {
                throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.toString(teXParser), teXObject.getClass());
            }
            String string = ((ControlSequence)teXObject).getName();
            if (this.getPrefix() == 2) {
                teXParser.getSettings().globalSetRegister(string, teXDimension);
            } else {
                teXParser.getSettings().localSetRegister(string, teXDimension);
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

