/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.types.NumberType;

public enum TestOperator {
    EQUALS('='){

        @Override
        public boolean doTest(boolean unsignedType, Number extractedValue, Number testValue, NumberType numberType) {
            return numberType.compare(unsignedType, extractedValue, testValue) == 0;
        }
    }
    ,
    NOT_EQUALS('!'){

        @Override
        public boolean doTest(boolean unsignedType, Number extractedValue, Number testValue, NumberType numberType) {
            return numberType.compare(unsignedType, extractedValue, testValue) != 0;
        }
    }
    ,
    GREATER_THAN('>'){

        @Override
        public boolean doTest(boolean unsignedType, Number extractedValue, Number testValue, NumberType numberType) {
            return numberType.compare(unsignedType, extractedValue, testValue) > 0;
        }
    }
    ,
    LESS_THAN('<'){

        @Override
        public boolean doTest(boolean unsignedType, Number extractedValue, Number testValue, NumberType numberType) {
            return numberType.compare(unsignedType, extractedValue, testValue) < 0;
        }
    }
    ,
    AND_ALL_SET('&'){

        @Override
        public boolean doTest(boolean unsignedType, Number extractedValue, Number testValue, NumberType numberType) {
            long testValueLong = testValue.longValue();
            return (extractedValue.longValue() & testValueLong) == testValueLong;
        }
    }
    ,
    AND_ALL_CLEARED('^'){

        @Override
        public boolean doTest(boolean unsignedType, Number extractedValue, Number testValue, NumberType numberType) {
            return (extractedValue.longValue() & testValue.longValue()) == 0L;
        }
    }
    ,
    NEGATE('~'){

        @Override
        public boolean doTest(boolean unsignedType, Number extractedValue, Number testValue, NumberType numberType) {
            long negatedValue = numberType.maskValue(testValue.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            return extractedValue.longValue() == negatedValue;
        }
    };

    public static final TestOperator DEFAULT_OPERATOR;
    private final char prefixChar;

    private TestOperator(char prefixChar) {
        this.prefixChar = prefixChar;
    }

    public abstract boolean doTest(boolean var1, Number var2, Number var3, NumberType var4);

    public static TestOperator fromTest(String testStr) {
        if (testStr.length() == 0) {
            return null;
        }
        char first = testStr.charAt(0);
        for (TestOperator operator : TestOperator.values()) {
            if (operator.prefixChar != first) continue;
            return operator;
        }
        return null;
    }

    static {
        DEFAULT_OPERATOR = EQUALS;
    }
}

