/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.ConnectionEventListener;
import com.ibm.db2.cmx.internal.core.ConnectionImpl;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMXConnectionFactory {
    private static HashMap<String, CMXConnection> sharedPool_ = new HashMap();
    private static ConnectionEventListener sharedPoolEventListner = new ConnectionEventListener(sharedPool_);
    private static Logger clientLogger__ = Log.getCMXClientLogger();

    public static CMXConnection getConnection(SocketChannel socketChannel, Processor[] processorArray, Logger logger) {
        return new ConnectionImpl(socketChannel, processorArray, logger);
    }

    public static CMXConnection getConnection(InetSocketAddress inetSocketAddress, Processor[] processorArray) throws IOException {
        if (clientLogger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(clientLogger__, CMXConnection.class, "getConnection", "ENTRY " + Arrays.deepToString(new Object[]{inetSocketAddress, processorArray}));
        }
        ConnectionImpl connectionImpl = new ConnectionImpl(inetSocketAddress, processorArray);
        if (clientLogger__.isLoggable(Level.FINER)) {
            DataLogger.exit(clientLogger__, CMXConnection.class, "getConnection", connectionImpl);
        }
        return connectionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMXConnection getSharedConnection(String string, int n2) throws Exception {
        CMXConnection cMXConnection;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            throw new Exception("cannot resolve hostname: " + string);
        }
        String string2 = inetAddress.getHostAddress() + ":" + inetSocketAddress.getPort();
        HashMap<String, CMXConnection> hashMap = sharedPool_;
        synchronized (hashMap) {
            if (sharedPool_.containsKey(string2) && (cMXConnection = sharedPool_.get(string2)).isConnected()) {
                cMXConnection.incrementSharedCount();
                return cMXConnection;
            }
            cMXConnection = CMXConnectionFactory.getConnection(inetSocketAddress, null);
            cMXConnection.addConnectionEventListner(sharedPoolEventListner);
            sharedPool_.put(string2, cMXConnection);
        }
        return cMXConnection;
    }
}

