/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import us.fatehi.utility.Color;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public class RegularExpressionColorMap {
    private static final Logger LOGGER = Logger.getLogger(RegularExpressionColorMap.class.getName());
    private final Map<Pattern, Color> colorMap = new HashMap<Pattern, Color>();

    public RegularExpressionColorMap() {
    }

    public RegularExpressionColorMap(Map<String, String> properties) {
        this();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> map : properties.entrySet()) {
            if (map == null) continue;
            String htmlColor = map.getKey();
            String regExpPattern = map.getValue();
            if (!Utility.isBlank(regExpPattern) && !Utility.isBlank(htmlColor) && htmlColor.length() == 6) {
                this.put(regExpPattern, "#" + htmlColor);
                continue;
            }
            LOGGER.log(Level.CONFIG, new StringFormat("Could not add color mapping for %s = %s", regExpPattern, htmlColor));
        }
    }

    public Optional<Color> match(String value) {
        for (Map.Entry<Pattern, Color> regualarExpressColor : this.colorMap.entrySet()) {
            Pattern pattern = regualarExpressColor.getKey();
            if (!pattern.matcher(value).matches()) continue;
            return Optional.of(regualarExpressColor.getValue());
        }
        return Optional.empty();
    }

    public void put(String regExpPattern, String htmlColor) {
        try {
            Utility.requireNotBlank(regExpPattern, "No regular expression pattern provided");
            Pattern pattern = Pattern.compile(regExpPattern, 0);
            Color color = Color.fromHexTriplet(htmlColor);
            this.colorMap.put(pattern, color);
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e, new StringFormat("Could not add color mapping for %s = %s", regExpPattern, htmlColor));
        }
    }

    public void putLiteral(String literal, Color color) {
        try {
            Utility.requireNotBlank(literal, "No literal key provided");
            Pattern pattern = Pattern.compile(literal, 16);
            this.colorMap.put(pattern, color);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINE, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e, new StringFormat("Could not add literal color mapping for %s = %s", literal, color));
        }
    }

    public int size() {
        return this.colorMap.size();
    }

    public String toString() {
        return Objects.toString(this.colorMap);
    }
}

