/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;

public final class JSModuleData
extends ScriptOrModule {
    private final Module module;
    @CompilerDirectives.CompilationFinal
    private JSFunctionData functionData;
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor frameDescriptor;

    public JSModuleData(Module module, Source source, JSFunctionData functionData, FrameDescriptor frameDescriptor) {
        super(functionData.getContext(), source);
        this.module = module;
        this.functionData = functionData;
        this.frameDescriptor = frameDescriptor;
    }

    public JSModuleData(Module module, JSContext context, Source source) {
        super(context, source);
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public JSFunctionData getFunctionData() {
        return this.functionData;
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    public boolean isTopLevelAsync() {
        return this.functionData.isAsync();
    }

    public void setFunctionData(JSFunctionData functionData) {
        assert (this.functionData == null);
        this.functionData = functionData;
        this.frameDescriptor = functionData.getRootNode().getFrameDescriptor();
    }
}

