/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.web;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.web.JSTextDecoder;
import com.oracle.truffle.js.builtins.web.JSTextDecoderObject;
import com.oracle.truffle.js.builtins.web.TextDecoderBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.array.ArrayBufferByteLengthNode;
import com.oracle.truffle.js.nodes.array.ArrayBufferViewGetByteLengthNode;
import com.oracle.truffle.js.nodes.array.GetViewByteLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import com.oracle.truffle.js.nodes.unary.JSIsNullOrUndefinedNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.array.ByteArrayAccess;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.nio.ByteOrder;
import java.util.Locale;

public class TextDecoderBuiltins {
    public static final char UNICODE_REPLACEMENT_CHARACTER = '\ufffd';
    public static final char BYTE_ORDER_MARK = '\ufeff';
    public static final byte[] UTF_8_BOM_BYTES = new byte[]{-17, -69, -65};
    public static final TruffleString UTF_8 = Strings.constant("utf-8");
    public static final TruffleString UTF_16LE = Strings.constant("utf-16le");
    public static final TruffleString UTF_16BE = Strings.constant("utf-16be");
    public static final TruffleString STREAM = Strings.constant("stream");
    public static final TruffleString FATAL = Strings.constant("fatal");
    public static final TruffleString IGNORE_BOM = Strings.constant("ignoreBOM");
    public static final TruffleString TEXT_DECODER_PROTOTYPE = Strings.constant("TextDecoder.prototype");
    public static final JSBuiltinsContainer BUILTINS = JSBuiltinsContainer.fromEnum(TEXT_DECODER_PROTOTYPE, TextDecoderPrototype.class);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TextDecoderPrototype implements BuiltinEnum<TextDecoderPrototype>
    {
        TextDecoder(0){

            @Override
            public boolean isConstructor() {
                return true;
            }

            @Override
            public boolean isNewTargetConstructor() {
                return true;
            }
        }
        ,
        decode(0),
        encoding(0),
        fatal(0),
        ignoreBOM(0);

        private final int length;

        private TextDecoderPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == encoding || this == fatal || this == ignoreBOM;
        }

        @Override
        public Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> TextDecoderBuiltinsFactory.ConstructorNodeGen.create(context, builtin, newTarget, this.args().functionOrNewTarget(newTarget).fixedArgs(2).createArgumentNodes(context));
                case 1 -> TextDecoderBuiltinsFactory.DecodeNodeGen.create(context, builtin, this.args().withThis().fixedArgs(2).createArgumentNodes(context));
                case 2, 3, 4 -> TextDecoderBuiltinsFactory.GetterNodeGen.create(context, builtin, this, this.args().withThis().createArgumentNodes(context));
            };
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class DecodeBufferSlice
    extends JavaScriptBaseNode {
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode = TruffleString.SwitchEncodingNode.create();
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();
        @Node.Child
        private TruffleString.IsValidNode isValidNode = TruffleString.IsValidNode.create();
        @Node.Child
        private TruffleString.ToValidStringNode toValidNode = TruffleString.ToValidStringNode.create();
        @Node.Child
        private TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode = TruffleString.ByteLengthOfCodePointNode.create();

        protected DecodeBufferSlice() {
        }

        @HostCompilerDirectives.InliningCutoff
        public abstract TruffleString execute(JSTextDecoderObject var1, JSArrayBufferObject var2, int var3, int var4, boolean var5);

        @Specialization
        protected final TruffleString doArrayBufferHeap(JSTextDecoderObject thisObj, JSArrayBufferObject.Heap buffer, int byteOffset, int byteLength, boolean stream, @Cached @Cached.Shared InlinedBranchProfile utf16Branch) {
            return this.decodeBufferSlice(thisObj, buffer, byteOffset, byteLength, stream, null, utf16Branch);
        }

        @Specialization
        protected final TruffleString doArrayBufferDirect(JSTextDecoderObject thisObj, JSArrayBufferObject.Direct buffer, int byteOffset, int byteLength, boolean stream, @Cached @Cached.Shared InlinedBranchProfile utf16Branch) {
            return this.decodeBufferSlice(thisObj, buffer, byteOffset, byteLength, stream, null, utf16Branch);
        }

        @Specialization
        protected final TruffleString doArrayBufferShared(JSTextDecoderObject thisObj, JSArrayBufferObject.Shared buffer, int byteOffset, int byteLength, boolean stream, @Cached @Cached.Shared InlinedBranchProfile utf16Branch) {
            return this.decodeBufferSlice(thisObj, buffer, byteOffset, byteLength, stream, null, utf16Branch);
        }

        @Specialization
        protected final TruffleString doArrayBufferInterop(JSTextDecoderObject thisObj, JSArrayBufferObject.Interop buffer, int byteOffset, int byteLength, boolean stream, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached @Cached.Shared InlinedBranchProfile utf16Branch) {
            return this.decodeBufferSlice(thisObj, buffer, byteOffset, byteLength, stream, interop, utf16Branch);
        }

        private TruffleString decodeBufferSlice(JSTextDecoderObject thisObj, JSArrayBufferObject buffer, int byteOffset, int byteLength, boolean stream, InteropLibrary interop, InlinedBranchProfile utf16Branch) {
            boolean error = false;
            try {
                TruffleString result;
                byte[] prefix = thisObj.getPendingBytes();
                int prefixLen = prefix == null ? 0 : prefix.length;
                int allocLength = byteLength + prefixLen;
                if (allocLength == 0) {
                    TruffleString truffleString = Strings.EMPTY_STRING;
                    return truffleString;
                }
                TruffleString.Encoding sourceEncoding = thisObj.getTruffleStringEncoding();
                boolean appendReplacementCharacter = false;
                if (!(stream || sourceEncoding != TruffleString.Encoding.UTF_16LE && sourceEncoding != TruffleString.Encoding.UTF_16BE)) {
                    utf16Branch.enter((Node)this);
                    if (allocLength % 2 != 0) {
                        if (thisObj.isFatal()) {
                            throw DecodeBufferSlice.createTypeErrorInvalidData(thisObj.getEncoding());
                        }
                        ++allocLength;
                        appendReplacementCharacter = true;
                    }
                }
                byte[] sourceBytes = new byte[allocLength];
                if (prefixLen != 0) {
                    System.arraycopy(prefix, 0, sourceBytes, 0, prefixLen);
                }
                JSInteropUtil.copyFromBuffer(buffer, byteOffset, sourceBytes, prefixLen, byteLength, interop);
                DecodeBufferSlice.reportLoopCount((Node)this, byteLength);
                if (appendReplacementCharacter) {
                    DecodeBufferSlice.putCharUTF16(sourceBytes, allocLength - 2, '\ufffd', sourceEncoding);
                }
                if (sourceEncoding == TruffleString.Encoding.UTF_8) {
                    result = this.stringFromByteArrayUTF8(thisObj, sourceBytes, stream);
                } else {
                    utf16Branch.enter((Node)this);
                    result = this.stringFromByteArrayUTF16(thisObj, sourceBytes, stream, sourceEncoding);
                }
                TruffleString truffleString = result;
                return truffleString;
            }
            catch (JSException e) {
                error = true;
                throw e;
            }
            finally {
                thisObj.endDecode(stream, error);
            }
        }

        private static boolean arrayStartsWith(byte[] bytes, byte[] prefix) {
            return ArrayUtils.regionEqualsWithOrMask((byte[])bytes, (int)0, (byte[])prefix, (int)0, (int)prefix.length, null);
        }

        private TruffleString stringFromByteArrayUTF8(JSTextDecoderObject thisObj, byte[] bytes, boolean stream) {
            TruffleString.Encoding sourceEncoding = TruffleString.Encoding.UTF_8;
            int byteOffset = 0;
            int byteLength = bytes.length;
            if (!thisObj.isIgnoreBOM() && !thisObj.isBomSeen() && DecodeBufferSlice.arrayStartsWith(bytes, UTF_8_BOM_BYTES)) {
                thisObj.setBomSeen();
                byteOffset += UTF_8_BOM_BYTES.length;
                byteLength -= UTF_8_BOM_BYTES.length;
            }
            TruffleString utf8Str = this.fromByteArrayNode.execute(bytes, byteOffset, byteLength, sourceEncoding, false);
            if (stream) {
                int newByteLength = byteLength;
                if (!this.isValidNode.execute((AbstractTruffleString)utf8Str, sourceEncoding)) {
                    int numBytesToCheck = Math.min(byteLength, 4);
                    for (int i = byteLength - 1; i >= byteLength - numBytesToCheck; --i) {
                        int lastCodePointLength = this.byteLengthOfCodePointNode.execute((AbstractTruffleString)utf8Str, i, sourceEncoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
                        if (lastCodePointLength < -1) {
                            newByteLength = i;
                            break;
                        }
                        if (lastCodePointLength > 0) break;
                    }
                }
                if (newByteLength != 0) {
                    thisObj.setBomSeen();
                }
                thisObj.setPendingBytes(bytes, newByteLength, byteLength);
                if (newByteLength != byteLength) {
                    utf8Str = this.fromByteArrayNode.execute(bytes, byteOffset, newByteLength, sourceEncoding, false);
                }
            }
            return this.toValidUTF16String(thisObj, utf8Str, sourceEncoding);
        }

        private TruffleString toValidUTF16String(JSTextDecoderObject thisObj, TruffleString utf8Str, TruffleString.Encoding sourceEncoding) {
            if (thisObj.isFatal() && !this.isValidNode.execute((AbstractTruffleString)utf8Str, sourceEncoding)) {
                throw DecodeBufferSlice.createTypeErrorInvalidData(thisObj.getEncoding());
            }
            return this.switchEncodingNode.execute((AbstractTruffleString)utf8Str, TruffleString.Encoding.UTF_16);
        }

        private TruffleString stringFromByteArrayUTF16(JSTextDecoderObject thisObj, byte[] bytes, boolean stream, TruffleString.Encoding sourceEncoding) {
            char lastChar;
            assert (sourceEncoding == TruffleString.Encoding.UTF_16LE || sourceEncoding == TruffleString.Encoding.UTF_16BE) : sourceEncoding;
            int byteOffset = 0;
            int byteLength = bytes.length;
            if (!thisObj.isIgnoreBOM() && !thisObj.isBomSeen() && byteLength >= 2) {
                thisObj.setBomSeen();
                char firstChar = DecodeBufferSlice.readCharUTF16(bytes, byteOffset, sourceEncoding);
                if (firstChar == '\ufeff') {
                    byteOffset += 2;
                    byteLength -= 2;
                }
            }
            int newByteLength = byteLength & 0xFFFFFFFE;
            if (stream && newByteLength >= 2 && Character.isHighSurrogate(lastChar = DecodeBufferSlice.readCharUTF16(bytes, byteOffset + (newByteLength - 2), sourceEncoding))) {
                newByteLength -= 2;
            }
            if (stream) {
                thisObj.setPendingBytes(bytes, newByteLength, byteLength);
            } else assert (newByteLength == byteLength);
            DecodeBufferSlice.toUTF16NativeByteOrder(bytes, byteOffset, newByteLength, sourceEncoding);
            TruffleString utf16Str = this.fromByteArrayNode.execute(bytes, byteOffset, newByteLength, TruffleString.Encoding.UTF_16, false);
            if (thisObj.isFatal()) {
                if (!this.isValidNode.execute((AbstractTruffleString)utf16Str, TruffleString.Encoding.UTF_16)) {
                    throw DecodeBufferSlice.createTypeErrorInvalidData(thisObj.getEncoding());
                }
                return utf16Str;
            }
            return this.toValidNode.execute((AbstractTruffleString)utf16Str, TruffleString.Encoding.UTF_16);
        }

        private static char readCharUTF16(byte[] bytes, int byteOffset, TruffleString.Encoding utf16Encoding) {
            return (char)(utf16Encoding == TruffleString.Encoding.UTF_16LE ? ByteArrayAccess.littleEndian().getUint16(bytes, byteOffset) : ByteArrayAccess.bigEndian().getUint16(bytes, byteOffset));
        }

        private static void putCharUTF16(byte[] utf8Bytes, int byteIndex, char value, TruffleString.Encoding utf16Encoding) {
            if (utf16Encoding == TruffleString.Encoding.UTF_16LE) {
                ByteArrayAccess.littleEndian().putInt16(utf8Bytes, byteIndex, value);
            } else {
                ByteArrayAccess.bigEndian().putInt16(utf8Bytes, byteIndex, value);
            }
        }

        private static void toUTF16NativeByteOrder(byte[] bytes, int byteOffset, int byteLength, TruffleString.Encoding sourceEncoding) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN && sourceEncoding == TruffleString.Encoding.UTF_16BE || ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN && sourceEncoding == TruffleString.Encoding.UTF_16LE) {
                assert (byteLength % 2 == 0) : byteLength;
                for (int i = byteOffset; i < byteOffset + byteLength; i += 2) {
                    ByteArrayAccess.littleEndian().putInt16(bytes, i, ByteArrayAccess.bigEndian().getInt16(bytes, i));
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static JSException createTypeErrorInvalidData(TruffleString sourceEncoding) {
            return Errors.createTypeError("The encoded data was not valid for encoding " + String.valueOf(sourceEncoding));
        }
    }

    public static abstract class DecodeNode
    extends JSBuiltinNode {
        @Node.Child
        private JSIsNullOrUndefinedNode isNullOrUndefinedNode = JSIsNullOrUndefinedNode.create();
        @Node.Child
        private IsObjectNode isObjectNode = IsObjectNode.create();
        @Node.Child
        private GetBooleanOptionNode getStreamOption;

        protected DecodeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getStreamOption = GetBooleanOptionNode.create(context, STREAM, false);
        }

        @Specialization
        protected final TruffleString doTypedArray(JSTextDecoderObject thisObj, JSTypedArrayObject source, Object options, @Cached @Cached.Shared DecodeBufferSlice decodeBufferSlice, @Cached ArrayBufferViewGetByteLengthNode getTypedArrayByteLengthNode) {
            boolean stream = this.getTextDecodeOptions(options);
            int byteOffset = source.getByteOffset();
            int byteLength = getTypedArrayByteLengthNode.executeInt(this, source, this.getContext());
            return decodeBufferSlice.execute(thisObj, source.getArrayBuffer(), byteOffset, byteLength, stream);
        }

        @Specialization
        protected final TruffleString doDataView(JSTextDecoderObject thisObj, JSDataViewObject source, Object options, @Cached @Cached.Shared DecodeBufferSlice decodeBufferSlice, @Cached GetViewByteLengthNode getViewByteLengthNode) {
            boolean stream = this.getTextDecodeOptions(options);
            int byteOffset = source.getByteOffset();
            int byteLength = getViewByteLengthNode.execute(source, this.getContext());
            return decodeBufferSlice.execute(thisObj, source.getArrayBuffer(), byteOffset, byteLength, stream);
        }

        @Specialization
        protected final TruffleString doArrayBuffer(JSTextDecoderObject thisObj, JSArrayBufferObject buffer, Object options, @Cached @Cached.Shared DecodeBufferSlice decodeBufferSlice, @Cached ArrayBufferByteLengthNode arrayBufferByteLengthNode) {
            boolean stream = this.getTextDecodeOptions(options);
            int byteLength = arrayBufferByteLengthNode.execute(this, buffer, this.getContext());
            return decodeBufferSlice.execute(thisObj, buffer, 0, byteLength, stream);
        }

        @Specialization(guards={"isUndefined(source)"})
        protected final TruffleString doEmpty(JSTextDecoderObject thisObj, Object source, Object options, @Cached @Cached.Shared DecodeBufferSlice decodeBufferSlice) {
            boolean stream = this.getTextDecodeOptions(options);
            JSArrayBufferObject emptyBuffer = JSArrayBuffer.createArrayBuffer(this.getContext(), this.getRealm(), 0);
            return decodeBufferSlice.execute(thisObj, emptyBuffer, 0, 0, stream);
        }

        @Fallback
        protected final TruffleString incompatibleReceiver(Object thisObj, Object source, Object options) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }

        @HostCompilerDirectives.InliningCutoff
        private boolean getTextDecodeOptions(Object options) {
            if (this.isNullOrUndefinedNode.executeBoolean(options)) {
                return false;
            }
            if (this.isObjectNode.executeBoolean(options)) {
                boolean stream = this.getStreamOption.executeValue(options);
                return stream;
            }
            throw Errors.createTypeErrorNotAnObject(options);
        }
    }

    public static abstract class GetterNode
    extends JSBuiltinNode {
        private final TextDecoderPrototype method;

        protected GetterNode(JSContext context, JSBuiltin builtin, TextDecoderPrototype method) {
            super(context, builtin);
            this.method = method;
        }

        @Specialization
        protected final Object get(JSTextDecoderObject thisObj) {
            return switch (this.method.ordinal()) {
                case 2 -> thisObj.getEncoding();
                case 3 -> Boolean.valueOf(thisObj.isFatal());
                case 4 -> Boolean.valueOf(thisObj.isIgnoreBOM());
                default -> Errors.shouldNotReachHereUnexpectedValue(this.method);
            };
        }

        @Fallback
        protected final Object incompatibleReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class ConstructorNode
    extends ConstructorBuiltins.ConstructWithNewTargetNode {
        @Node.Child
        private GetBooleanOptionNode getFatalOption;
        @Node.Child
        private GetBooleanOptionNode getIgnoreBOMOption;

        protected ConstructorNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
            this.getFatalOption = GetBooleanOptionNode.create(context, FATAL, false);
            this.getIgnoreBOMOption = GetBooleanOptionNode.create(context, IGNORE_BOM, false);
        }

        @Specialization(guards={"isUndefined(label)", "isUndefined(options)"})
        protected final JSObject constructNoArgs(JSDynamicObject newTarget, Object label, Object options) {
            return this.construct(newTarget, UTF_8, TruffleString.Encoding.UTF_8, false, false);
        }

        @Specialization(replaces={"constructNoArgs"})
        protected final JSObject construct(JSDynamicObject newTarget, Object label, Object options, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached JSTrimWhitespaceNode trimWhitespaceNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached JSIsNullOrUndefinedNode isNullOrUndefinedNode, @Cached IsObjectNode isObjectNode) {
            boolean ignoreBOM;
            boolean fatal;
            TruffleString.Encoding truffleStringEncoding;
            TruffleString encodingName;
            TruffleString labelStr;
            TruffleString truffleString = labelStr = label == Undefined.instance ? UTF_8 : toStringNode.executeString(label);
            if (Strings.equals(equalNode, labelStr, UTF_8)) {
                encodingName = UTF_8;
                truffleStringEncoding = TruffleString.Encoding.UTF_8;
            } else {
                String lowerCase;
                labelStr = trimWhitespaceNode.executeString(labelStr);
                switch (lowerCase = Strings.javaStringToLowerCase(toJavaStringNode.execute((AbstractTruffleString)labelStr), Locale.ROOT)) {
                    case "utf-8": 
                    case "utf8": 
                    case "unicode-1-1-utf-8": 
                    case "unicode11utf8": 
                    case "unicode20utf8": 
                    case "x-unicode20utf8": {
                        encodingName = UTF_8;
                        truffleStringEncoding = TruffleString.Encoding.UTF_8;
                        break;
                    }
                    case "utf-16le": 
                    case "utf-16": 
                    case "ucs-2": 
                    case "iso-10646-ucs-2": 
                    case "csunicode": 
                    case "unicode": 
                    case "unicodefeff": {
                        encodingName = UTF_16LE;
                        truffleStringEncoding = TruffleString.Encoding.UTF_16LE;
                        break;
                    }
                    case "utf-16be": 
                    case "unicodefffe": {
                        encodingName = UTF_16BE;
                        truffleStringEncoding = TruffleString.Encoding.UTF_16BE;
                        break;
                    }
                    default: {
                        throw Errors.createRangeErrorEncodingNotSupported(labelStr);
                    }
                }
            }
            if (isNullOrUndefinedNode.executeBoolean(options)) {
                fatal = false;
                ignoreBOM = false;
            } else if (isObjectNode.executeBoolean(options)) {
                fatal = this.getFatalOption.executeValue(options);
                ignoreBOM = this.getIgnoreBOMOption.executeValue(options);
            } else {
                throw Errors.createTypeErrorNotAnObject(options);
            }
            return this.construct(newTarget, encodingName, truffleStringEncoding, fatal, ignoreBOM);
        }

        private JSTextDecoderObject construct(JSDynamicObject newTarget, TruffleString encodingName, TruffleString.Encoding truffleStringEncoding, boolean fatal, boolean ignoreBOM) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTextDecoder.create(this.getJSContext(), realm, proto, encodingName, truffleStringEncoding, fatal, ignoreBOM);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return this.getRealm().getTextDecoderPrototype();
        }
    }
}

