/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIaqjms;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIaqi {
    static final int AQIVER_DEFAULT = 1;
    static final int AQIVER_12_2 = 2;
    static final int AQIVER_12_1 = 1;
    static final int AQTTC_ENQ_STREAMING_DISABLED = 0;
    static final int AQTTC_ENQ_STREAMING_ENABLED = 1;
    static final int AQTCC_OCI_ONE_PIECE = 0;
    static final int AQTCC_OCI_FIRST_PIECE = 1;
    static final int AQTCC_OCI_NEXT_PIECE = 2;
    static final int AQTCC_OCI_LAST_PIECE = 3;
    T4CConnection connection;
    T4CMAREngine meg;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private AQMessagePropertiesI messageProperties;
    private JMSEnqueueOptions jmsEnqueueOptions;
    private JMSMessageProperties jmsProp;
    private JMSDequeueOptions jmsDequeueOptions;
    private AQEnqueueOptions aqEnqueueOptions;
    private AQDequeueOptions aqDequeueOptions;
    private int aqxaqopt;
    private boolean isAQMsg;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private byte[] senderAgentName;
    private byte[] senderAgentAddress;
    private byte senderAgentProtocol;
    private byte[] queueNameBytes;
    private AQAgentI[] attrRecipientList;
    private byte[][] recipientTextValues;
    private byte[][] recipientBinaryValues;
    private int[] recipientKeywords;
    private byte[] consumerNameBytes;
    private byte[] correlationBytes;
    private byte[] conditionBytes;
    private int nbExtensions;
    private byte[][] extensionTextValues;
    private byte[][] extensionBinaryValues;
    private int[] extensionKeywords;
    private byte[] messageOid;
    private int aqiver;
    private byte[] messageData;
    private boolean isRawQueue;
    private boolean bStreamingMode;
    private int blockSize;
    private InputStream payloadStream;
    private int bitMappedEnqueueOption;
    private byte[] headerPropBytes;
    private byte[] userPropBytes;
    private long aqiflg;
    private boolean useEnqOpt;
    private boolean lcrx2y;
    private T4CTTIaqjms aqjms;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    T4CTTIaqi(T4CConnection _connection, int _aqxaqopt, String _queueName, JMSEnqueueOptions _enqueueOptions, JMSMessage _mesg, AQMessagePropertiesI _messageProperties, JMSMessageProperties _jmsProp, JMSDequeueOptions _jmsDequeueOpt) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$18, null, _connection, _aqxaqopt, _queueName, _enqueueOptions, _mesg, _messageProperties, _jmsProp, _jmsDequeueOpt);
            }
            this.messageProperties = null;
            this.jmsEnqueueOptions = null;
            this.jmsProp = null;
            this.jmsDequeueOptions = null;
            this.aqEnqueueOptions = null;
            this.aqDequeueOptions = null;
            this.aqxaqopt = 0;
            this.isAQMsg = false;
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
            this.queueNameBytes = null;
            this.attrRecipientList = null;
            this.recipientTextValues = null;
            this.recipientBinaryValues = null;
            this.recipientKeywords = null;
            this.consumerNameBytes = null;
            this.correlationBytes = null;
            this.conditionBytes = null;
            this.nbExtensions = 0;
            this.extensionTextValues = null;
            this.extensionBinaryValues = null;
            this.extensionKeywords = null;
            this.messageOid = null;
            this.aqiver = 1;
            this.messageData = null;
            this.isRawQueue = false;
            this.bStreamingMode = false;
            this.blockSize = 8192;
            this.payloadStream = null;
            this.bitMappedEnqueueOption = 0;
            this.headerPropBytes = null;
            this.userPropBytes = null;
            this.aqiflg = 0L;
            this.useEnqOpt = false;
            this.lcrx2y = false;
            this.isAQMsg = false;
            this.initCommon(_connection, _aqxaqopt, _queueName, _messageProperties);
            this.aqjms = new T4CTTIaqjms(_connection);
            this.jmsProp = _jmsProp;
            this.isRawQueue = true;
            if (this.aqxaqopt == 1) {
                this.jmsEnqueueOptions = _enqueueOptions;
                if (_mesg.getStreamPayload() == null) {
                    this.setStreamingMode(false);
                    this.setInputStream(null);
                    this.messageData = _mesg.getPayload();
                } else {
                    this.setStreamingMode(true);
                    this.setBlockSize(_mesg.getChunkSize());
                    this.setInputStream(_mesg.getStreamPayload());
                    this.messageData = null;
                }
                this.messageOid = _mesg.getToid();
                this.bitMappedEnqueueOption = _enqueueOptions.getDeliveryMode().getCode() + _enqueueOptions.getVisibility().getCode();
                if (this.jmsProp != null) {
                    this.headerPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getHeaderProperties());
                    this.userPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getUserProperties());
                } else {
                    this.headerPropBytes = null;
                    this.userPropBytes = null;
                }
            } else {
                this.jmsDequeueOptions = _jmsDequeueOpt;
                this.messageOid = TypeDescriptor.RAWTOID;
                String consumerNameStr = this.jmsDequeueOptions.getConsumerName();
                this.consumerNameBytes = (byte[])(consumerNameStr != null && consumerNameStr.length() > 0 ? this.meg.conv.StringToCharBytes(consumerNameStr) : null);
                String correlation = this.jmsDequeueOptions.getCorrelation();
                this.correlationBytes = (byte[])(correlation != null && correlation.length() != 0 ? this.meg.conv.StringToCharBytes(correlation) : null);
                String condition = this.jmsDequeueOptions.getCondition();
                this.conditionBytes = (byte[])(condition != null && condition.length() > 0 ? this.meg.conv.StringToCharBytes(condition) : null);
            }
            this.initVersion();
            this.initFlag();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CTTIaqi(T4CConnection _connection, int _aqxaqopt, String _queueName, AQEnqueueOptions _aqEnqueueOptions, AQMessage _mesg, AQMessagePropertiesI _messageProperties, AQDequeueOptions _aqDequeueOptions, byte[] _tdo, int _version) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$19, null, _connection, _aqxaqopt, _queueName, _aqEnqueueOptions, _mesg, _messageProperties, _aqDequeueOptions, _tdo, _version);
            }
            this.messageProperties = null;
            this.jmsEnqueueOptions = null;
            this.jmsProp = null;
            this.jmsDequeueOptions = null;
            this.aqEnqueueOptions = null;
            this.aqDequeueOptions = null;
            this.aqxaqopt = 0;
            this.isAQMsg = false;
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
            this.queueNameBytes = null;
            this.attrRecipientList = null;
            this.recipientTextValues = null;
            this.recipientBinaryValues = null;
            this.recipientKeywords = null;
            this.consumerNameBytes = null;
            this.correlationBytes = null;
            this.conditionBytes = null;
            this.nbExtensions = 0;
            this.extensionTextValues = null;
            this.extensionBinaryValues = null;
            this.extensionKeywords = null;
            this.messageOid = null;
            this.aqiver = 1;
            this.messageData = null;
            this.isRawQueue = false;
            this.bStreamingMode = false;
            this.blockSize = 8192;
            this.payloadStream = null;
            this.bitMappedEnqueueOption = 0;
            this.headerPropBytes = null;
            this.userPropBytes = null;
            this.aqiflg = 0L;
            this.useEnqOpt = false;
            this.lcrx2y = false;
            String transformation = null;
            this.isAQMsg = true;
            this.initCommon(_connection, _aqxaqopt, _queueName, _messageProperties);
            if (this.aqxaqopt == 1) {
                this.aqEnqueueOptions = _aqEnqueueOptions;
                AQMessageI imesg = (AQMessageI)_mesg;
                this.messageData = imesg.getPayload();
                this.messageOid = imesg.getPayloadTOID();
                this.aqiver = imesg.getPayloadVersion();
                this.isRawQueue = imesg.isRAWPayload();
                transformation = this.aqEnqueueOptions.getTransformation();
            } else {
                this.messageOid = _tdo;
                this.aqiver = _version;
                this.isRawQueue = AQMessageI.compareToid(_tdo, TypeDescriptor.RAWTOID);
                this.aqDequeueOptions = _aqDequeueOptions;
                String consumerNameStr = this.aqDequeueOptions.getConsumerName();
                this.consumerNameBytes = (byte[])(consumerNameStr != null && consumerNameStr.length() > 0 ? this.meg.conv.StringToCharBytes(consumerNameStr) : null);
                String correlation = this.aqDequeueOptions.getCorrelation();
                this.correlationBytes = (byte[])(correlation != null && correlation.length() != 0 ? this.meg.conv.StringToCharBytes(correlation) : null);
                String condition = this.aqDequeueOptions.getCondition();
                this.conditionBytes = (byte[])(condition != null && condition.length() > 0 ? this.meg.conv.StringToCharBytes(condition) : null);
                transformation = this.aqDequeueOptions.getTransformation();
            }
            if (transformation != null && transformation.length() > 0) {
                this.nbExtensions = 1;
                this.extensionTextValues = new byte[this.nbExtensions][];
                this.extensionBinaryValues = new byte[this.nbExtensions][];
                this.extensionKeywords = new int[this.nbExtensions];
                this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(transformation);
                this.extensionBinaryValues[0] = null;
                this.extensionKeywords[0] = 196;
            } else {
                this.nbExtensions = 0;
            }
            this.initFlag();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initCommon(T4CConnection t4CConnection, int n2, String string, AQMessagePropertiesI aQMessagePropertiesI) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _queueName;
            void _messageProperties;
            void _aqxaqopt;
            void _connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$0, this, t4CConnection, n2, string, aQMessagePropertiesI);
            }
            this.connection = _connection;
            this.meg = this.connection.getMarshalEngine();
            this.aqxaqopt = _aqxaqopt;
            this.toh = new T4Ctoh((T4CConnection)_connection);
            this.aqm = new T4CTTIaqm(this.connection, this.toh);
            this.messageProperties = _messageProperties;
            if (this.aqxaqopt == 1 && this.messageProperties != null) {
                String aqmcor = this.messageProperties.getCorrelation();
                this.aqmcorBytes = (byte[])(aqmcor != null && aqmcor.length() != 0 ? this.meg.conv.StringToCharBytes(aqmcor) : null);
                String aqmeqn = this.messageProperties.getExceptionQueue();
                this.aqmeqnBytes = (byte[])(aqmeqn != null && aqmeqn.length() != 0 ? this.meg.conv.StringToCharBytes(aqmeqn) : null);
                AQAgentI senderAgent = (AQAgentI)this.messageProperties.getSender();
                if (senderAgent != null) {
                    this.senderAgentName = (byte[])(senderAgent.getName() != null ? this.meg.conv.StringToCharBytes(senderAgent.getName()) : null);
                    this.senderAgentAddress = (byte[])(senderAgent.getAddress() != null ? this.meg.conv.StringToCharBytes(senderAgent.getAddress()) : null);
                    this.senderAgentProtocol = (byte)senderAgent.getProtocol();
                } else {
                    this.senderAgentName = null;
                    this.senderAgentAddress = null;
                    this.senderAgentProtocol = 0;
                }
                this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
                if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
                    this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
                    this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
                    this.recipientKeywords = new int[this.attrRecipientList.length * 3];
                    for (int i2 = 0; i2 < this.attrRecipientList.length; ++i2) {
                        if (this.attrRecipientList[i2].getName() != null) {
                            this.recipientTextValues[3 * i2] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getName());
                        }
                        if (this.attrRecipientList[i2].getAddress() != null) {
                            this.recipientTextValues[3 * i2 + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getAddress());
                        }
                        this.recipientBinaryValues[3 * i2 + 2] = new byte[1];
                        this.recipientBinaryValues[3 * i2 + 2][0] = (byte)this.attrRecipientList[i2].getProtocol();
                        this.recipientKeywords[3 * i2] = 3 * i2;
                        this.recipientKeywords[3 * i2 + 1] = 3 * i2 + 1;
                        this.recipientKeywords[3 * i2 + 2] = 3 * i2 + 2;
                    }
                }
            } else {
                this.aqmcorBytes = null;
                this.aqmeqnBytes = null;
                this.senderAgentName = null;
                this.senderAgentAddress = null;
                this.senderAgentProtocol = 0;
            }
            this.queueNameBytes = (byte[])(_queueName != null && _queueName.length() != 0 ? this.meg.conv.StringToCharBytes((String)_queueName) : null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void initVersion() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$1, this, new Object[0]);
            }
            try {
                this.aqiver = this.connection.getVersionNumber() >= 12200 && TypeDescriptor.isV2available(this.messageOid) ? 2 : 1;
            }
            catch (Exception e2) {
                this.aqiver = 1;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    void initFlag() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$2, this, new Object[0]);
            }
            this.aqiflg = 0L;
            if (this.aqxaqopt == 1) {
                if (this.connection.autocommit) {
                    this.aqiflg = 32L;
                }
                if (!this.isAQMsg && this.jmsEnqueueOptions.getDeliveryMode() == JMSEnqueueOptions.DeliveryMode.BUFFERED || this.isAQMsg && this.aqEnqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
                    this.aqiflg |= 2L;
                }
                this.aqiflg = this.bStreamingMode ? (this.aqiflg |= 1L) : (this.aqiflg |= 0L);
            } else {
                this.aqiflg = this.connection.autocommit ? 2L : 1L;
                if (this.isAQMsg) {
                    if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
                        this.aqiflg |= 2L;
                    } else if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
                        this.aqiflg |= 0x10L;
                    }
                } else {
                    this.aqiflg |= (long)this.jmsDequeueOptions.getDeliveryMode().getCode();
                    this.aqiflg |= (long)this.jmsDequeueOptions.getDequeueMode().getCode();
                    this.aqiflg |= (long)this.jmsDequeueOptions.getVisibility().getCode();
                    if (this.jmsDequeueOptions.getWait() == 4) {
                        this.aqiflg |= 4L;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalPropagation() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$3, this, new Object[0]);
            }
            byte[] attrRelativeMessageId = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
            this.meg.marshalDALC(attrRelativeMessageId);
            if (attrRelativeMessageId != null) {
                if (this.isAQMsg) {
                    this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
                } else {
                    this.meg.marshalSB4(0);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalHeader() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.meg.marshalUB1((short)6);
            if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
                this.meg.marshalSWORD(this.queueNameBytes.length);
                this.meg.marshalCHR(this.queueNameBytes);
            } else {
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalB1Array(this.messageOid);
            this.meg.marshalUB2(this.aqiver);
            this.meg.marshalUB4(this.aqiflg);
            if (this.useEnqOpt) {
                byte[] attrRelativeMessageId;
                if (this.isAQMsg) {
                    this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
                } else {
                    this.meg.marshalSB4(this.jmsEnqueueOptions.getVisibility().getCode());
                }
                byte[] byArray = attrRelativeMessageId = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
                if (attrRelativeMessageId != null && attrRelativeMessageId.length > 0) {
                    this.meg.marshalSWORD(attrRelativeMessageId.length);
                    this.meg.marshalB1Array(attrRelativeMessageId);
                } else {
                    this.meg.marshalSWORD(0);
                }
                if (this.isAQMsg) {
                    this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
                } else {
                    this.meg.marshalSB4(0);
                }
                if (this.nbExtensions > 0) {
                    this.meg.marshalSWORD(this.nbExtensions);
                    this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
                } else {
                    this.meg.marshalSWORD(0);
                }
                this.meg.marshalSB4(0);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalData() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            AQAgentI[] attrRecipientList;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$5, this, new Object[0]);
            }
            this.meg.marshalUB1((short)7);
            this.meg.marshalUB4(this.aqiflg);
            if (!this.lcrx2y) {
                this.marshalAQM();
            }
            if ((attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList()) != null && attrRecipientList.length > 0) {
                this.meg.marshalSWORD(attrRecipientList.length * 3);
                this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
            } else {
                this.meg.marshalSWORD(0);
            }
            if (!this.useEnqOpt) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
                byte[] attrRelativeMessageId = this.aqEnqueueOptions.getRelativeMessageId();
                if (attrRelativeMessageId != null && attrRelativeMessageId.length > 0) {
                    this.meg.marshalSWORD(attrRelativeMessageId.length);
                    this.meg.marshalB1Array(attrRelativeMessageId);
                } else {
                    this.meg.marshalSWORD(0);
                }
                this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
            }
            if (this.messageData != null) {
                if (!this.isRawQueue) {
                    this.toh.init(this.messageOid, this.messageData.length);
                    this.toh.marshal(this.meg);
                    this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
                } else {
                    this.meg.marshalUB4(this.messageData.length);
                    this.meg.marshalB1Array(this.messageData);
                }
            } else {
                this.meg.marshalUB4(0L);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalJmsData() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$6, this, new Object[0]);
            }
            this.meg.marshalUB1((short)7);
            this.marshalAQM();
            int bitMappedEnqueueOption = this.jmsEnqueueOptions.getDeliveryMode().getCode() + this.jmsEnqueueOptions.getVisibility().getCode();
            this.meg.marshalSB4(bitMappedEnqueueOption);
            if (this.jmsProp != null) {
                this.aqjms.aqjmsflags = this.jmsProp.getJMSMessageType().getCode();
                this.aqjms.aqjmshdrpcnt = 0;
                this.aqjms.aqjmsusrprpcnt = 0;
            } else {
                this.aqjms.aqjmsflags = 0;
                this.aqjms.aqjmshdrpcnt = 0;
                this.aqjms.aqjmsusrprpcnt = 0;
            }
            this.aqjms.aqjmshdrprop = this.headerPropBytes;
            this.aqjms.aqjmsuserprop = this.userPropBytes;
            this.aqjms.marshal();
            if (this.messageOid != null) {
                this.meg.marshalSWORD(16);
                this.meg.marshalB1Array(this.messageOid);
            } else {
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalUB2(this.aqiver);
            if (this.messageData != null) {
                this.meg.marshalUB4(this.messageData.length);
                this.meg.marshalB1Array(this.messageData);
            } else {
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalSB4((int)this.aqiflg);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalAQM() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$7, this, new Object[0]);
            }
            this.aqm.initToDefaultValues();
            if (this.messageProperties != null) {
                this.aqm.aqmpri = this.messageProperties.getPriority();
                this.aqm.aqmdel = this.messageProperties.getDelay();
                this.aqm.aqmexp = this.messageProperties.getExpiration();
                this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
            }
            this.aqm.aqmcorBytes = this.aqmcorBytes;
            this.aqm.aqmeqnBytes = this.aqmeqnBytes;
            this.aqm.senderAgentName = this.senderAgentName;
            this.aqm.senderAgentAddress = this.senderAgentAddress;
            this.aqm.senderAgentProtocol = this.senderAgentProtocol;
            this.aqm.marshal();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalDone() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$8, this, new Object[0]);
            }
            this.meg.marshalUB1((short)9);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshal() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$9, this, new Object[0]);
            }
            this.meg.marshalDALC(this.queueNameBytes);
            this.marshalAQM();
            AQAgentI[] attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
            if (attrRecipientList != null && attrRecipientList.length > 0) {
                this.meg.marshalSWORD(attrRecipientList.length * 3);
                this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
            } else {
                this.meg.marshalSWORD(0);
            }
            if (this.aqxaqopt == 2) {
                this.meg.marshalDALC(this.consumerNameBytes);
            } else {
                this.meg.marshalSWORD(0);
            }
            if (this.aqxaqopt == 2) {
                if (this.isAQMsg) {
                    this.meg.marshalSB4(this.aqDequeueOptions.getDequeueMode().getCode());
                } else {
                    this.meg.marshalSB4(this.jmsDequeueOptions.getDequeueMode().getCode());
                }
            } else {
                this.meg.marshalSB4(0);
            }
            if (this.isAQMsg) {
                if (this.aqxaqopt == 2) {
                    this.meg.marshalSB4(this.aqDequeueOptions.getNavigation().getCode());
                } else {
                    this.meg.marshalSB4(0);
                }
            } else {
                this.meg.marshalSB4(0);
            }
            if (this.aqxaqopt == 1) {
                if (this.isAQMsg) {
                    this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
                } else {
                    this.meg.marshalSB4(this.jmsEnqueueOptions.getVisibility().getCode());
                }
            } else if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqDequeueOptions.getVisibility().getCode());
            } else {
                this.meg.marshalSB4(this.jmsDequeueOptions.getVisibility().getCode());
            }
            if (this.aqxaqopt == 2) {
                if (this.isAQMsg) {
                    this.meg.marshalSB4(this.aqDequeueOptions.getWait());
                } else {
                    this.meg.marshalSB4(this.jmsDequeueOptions.getWait());
                }
            } else {
                this.meg.marshalSB4(0);
            }
            byte[] mesgId = null;
            if (this.aqxaqopt == 2) {
                mesgId = this.isAQMsg ? this.aqDequeueOptions.getDequeueMessageId() : this.jmsDequeueOptions.getDequeueMessageId();
            }
            this.meg.marshalDALC(mesgId);
            if (this.aqxaqopt == 2) {
                this.meg.marshalDALC(this.correlationBytes);
            } else {
                this.meg.marshalSWORD(0);
            }
            if (this.connection.getTTCVersion() >= 1) {
                this.meg.marshalDALC(this.conditionBytes);
                this.meg.marshalSWORD(0);
            }
            byte[] attrRelativeMessageId = null;
            if (this.aqxaqopt == 1) {
                attrRelativeMessageId = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
            }
            this.meg.marshalDALC(attrRelativeMessageId);
            if (this.aqxaqopt == 1) {
                if (this.isAQMsg) {
                    this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
                } else {
                    this.meg.marshalSB4(0);
                }
            } else {
                this.meg.marshalSB4(0);
            }
            this.meg.marshalDALC(this.messageOid);
            this.meg.marshalUB2(this.aqiver);
            if (this.aqxaqopt == 1) {
                if (this.messageData != null) {
                    if (!this.isRawQueue) {
                        this.meg.marshalSWORD(this.messageData.length);
                        this.toh.init(this.messageOid, this.messageData.length);
                        this.toh.marshal(this.meg);
                        this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
                        this.meg.marshalUB4(0L);
                    } else {
                        this.meg.marshalSWORD(0);
                        this.meg.marshalDALC(this.messageData);
                    }
                } else {
                    this.meg.marshalSWORD(0);
                    this.meg.marshalUB4(0L);
                }
            } else {
                this.meg.marshalSWORD(0);
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalUB4(0L);
            long aqiflg = 0L;
            if (this.aqxaqopt == 1) {
                if (this.connection.autocommit) {
                    aqiflg = 32L;
                }
                if (!this.isAQMsg && this.jmsEnqueueOptions.getDeliveryMode() == JMSEnqueueOptions.DeliveryMode.BUFFERED || this.isAQMsg && this.aqEnqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
                    aqiflg |= 2L;
                }
                aqiflg = this.bStreamingMode ? (aqiflg |= 1L) : (aqiflg |= 0L);
            } else {
                aqiflg = this.connection.autocommit ? 2L : 1L;
                if (this.isAQMsg) {
                    if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
                        aqiflg |= 2L;
                    } else if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
                        aqiflg |= 0x10L;
                    }
                } else {
                    aqiflg |= (long)this.jmsDequeueOptions.getDeliveryMode().getCode();
                    aqiflg |= (long)this.jmsDequeueOptions.getDequeueMode().getCode();
                    aqiflg |= (long)this.jmsDequeueOptions.getVisibility().getCode();
                    if (this.jmsDequeueOptions.getWait() == 4) {
                        aqiflg |= 4L;
                    }
                }
            }
            this.meg.marshalUB4(aqiflg);
            if (this.nbExtensions > 0) {
                this.meg.marshalSWORD(this.nbExtensions);
                this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
            } else {
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalSWORD(0);
            if (this.aqxaqopt == 1 && this.bStreamingMode) {
                this.writeStreamingPayload();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setStreamingMode(boolean bl) {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$10, this, bl);
            }
            this.bStreamingMode = flag;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setBlockSize(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _blockSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$11, this, n2);
            }
            if (_blockSize > 0) {
                this.blockSize = _blockSize;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setInputStream(InputStream inputStream) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void inputStream2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$12, this, inputStream);
            }
            this.payloadStream = inputStream2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    private void writeStreamingPayload() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int noOfBytesRead;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$13, this, new Object[0]);
            }
            byte[] bytearray = new byte[this.blockSize];
            boolean firstTime = true;
            while (true) {
                if ((noOfBytesRead = this.payloadStream.read(bytearray)) < this.blockSize) break;
                if (firstTime) {
                    this.writeFirst(bytearray, noOfBytesRead);
                    firstTime = false;
                    continue;
                }
                this.writeNext(bytearray, noOfBytesRead);
            }
            this.writeLast(bytearray, noOfBytesRead);
            this.payloadStream.close();
            this.payloadStream = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeFirst(byte[] byArray, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _byteArray;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$14, this, byArray, n2);
            }
            this.meg.marshalUB1((short)1);
            this.meg.marshalSB8((long)length);
            this.meg.marshalB1Array((byte[])_byteArray, 0, (int)length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeNext(byte[] byArray, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _byteArray;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$15, this, byArray, n2);
            }
            this.meg.marshalUB1((short)2);
            this.meg.marshalSB8((long)length);
            this.meg.marshalB1Array((byte[])_byteArray, 0, (int)length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLast(byte[] byArray, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$16, this, byArray, n2);
            }
            if (length > 0) {
                void _byteArray;
                this.meg.marshalUB1((short)3);
                this.meg.marshalSB8((long)length);
                this.meg.marshalB1Array((byte[])_byteArray, 0, (int)length);
            } else {
                this.meg.marshalUB1((short)3);
                this.meg.marshalSB8(0L);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isRawQueue() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$17, this, new Object[0]);
            }
            boolean bl2 = this.isRawQueue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$17, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$17, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CTTIaqi.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$19 = T4CTTIaqi.class.getDeclaredConstructor(T4CConnection.class, Integer.TYPE, String.class, AQEnqueueOptions.class, AQMessage.class, AQMessagePropertiesI.class, AQDequeueOptions.class, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CTTIaqi.class.getDeclaredConstructor(T4CConnection.class, Integer.TYPE, String.class, JMSEnqueueOptions.class, JMSMessage.class, AQMessagePropertiesI.class, JMSMessageProperties.class, JMSDequeueOptions.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CTTIaqi.class.getDeclaredMethod("isRawQueue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CTTIaqi.class.getDeclaredMethod("writeLast", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CTTIaqi.class.getDeclaredMethod("writeNext", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CTTIaqi.class.getDeclaredMethod("writeFirst", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CTTIaqi.class.getDeclaredMethod("writeStreamingPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIaqi.class.getDeclaredMethod("setInputStream", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIaqi.class.getDeclaredMethod("setBlockSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIaqi.class.getDeclaredMethod("setStreamingMode", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIaqi.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIaqi.class.getDeclaredMethod("marshalDone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIaqi.class.getDeclaredMethod("marshalAQM", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIaqi.class.getDeclaredMethod("marshalJmsData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIaqi.class.getDeclaredMethod("marshalData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIaqi.class.getDeclaredMethod("marshalHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIaqi.class.getDeclaredMethod("marshalPropagation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIaqi.class.getDeclaredMethod("initFlag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIaqi.class.getDeclaredMethod("initVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIaqi.class.getDeclaredMethod("initCommon", T4CConnection.class, Integer.TYPE, String.class, AQMessagePropertiesI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

