/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.jdbc.FirebirdSavepoint;
import org.firebirdsql.jdbc.QuoteStrategy;

public record FBSavepoint(Integer savepointId, String name) implements FirebirdSavepoint
{
    private static final String SAVEPOINT_ID_PREFIX = "SVPT";

    public FBSavepoint {
        if (savepointId == null && name == null) {
            throw new NullPointerException("savepointId and name cannot both be null");
        }
        if (name == null) {
            name = FBSavepoint.generateSavepointName(savepointId);
        } else {
            if (savepointId != null) {
                throw new IllegalArgumentException("savepointId cannot be non-null if name is not null");
            }
            if (name.isBlank()) {
                throw new IllegalArgumentException("name must be non-blank");
            }
        }
    }

    public FBSavepoint(int savepointId) {
        this(savepointId, null);
    }

    public FBSavepoint(String name) {
        this(null, name);
    }

    private static String generateSavepointName(int savePointId) {
        if (savePointId >= 0) {
            return SAVEPOINT_ID_PREFIX + savePointId;
        }
        return "SVPT_" + Math.abs(savePointId);
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.savepointId == null) {
            throw new SQLException("Savepoint is named");
        }
        return this.savepointId;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.savepointId != null) {
            throw new SQLException("Savepoint is unnamed");
        }
        return this.name;
    }

    String toSavepointStatement(QuoteStrategy quoteStrategy) {
        return "SAVEPOINT " + quoteStrategy.quoteObjectName(this.name);
    }

    String toRollbackStatement(QuoteStrategy quoteStrategy) {
        return "ROLLBACK TO " + quoteStrategy.quoteObjectName(this.name);
    }

    String toReleaseStatement(QuoteStrategy quoteStrategy) {
        return "RELEASE SAVEPOINT " + quoteStrategy.quoteObjectName(this.name) + " ONLY";
    }
}

