/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version16;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import org.firebirdsql.gds.BatchParameterBuffer;
import org.firebirdsql.gds.impl.BatchParameterBufferImp;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.BatchCompletion;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbBatchConfig;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.BatchCompletionResponse;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.version13.V13Statement;

public class V16Statement
extends V13Statement {
    public V16Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    protected void sendExecuteMsg(XdrOutputStream xdrOut, int operation, RowValue parameters) throws IOException, SQLException {
        int timeout = (int)this.getAllowedTimeout();
        super.sendExecuteMsg(xdrOut, operation, parameters);
        xdrOut.writeInt(timeout);
    }

    @Override
    public boolean supportBatchUpdates() {
        return true;
    }

    @Override
    public BatchParameterBuffer createBatchParameterBuffer() throws SQLException {
        this.checkStatementValid();
        return new BatchParameterBufferImp();
    }

    @Override
    public void deferredBatchCreate(FbBatchConfig batchConfig, DeferredResponse<Void> onResponse) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            this.sendBatchCreate0(batchConfig);
            this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(onResponse, r -> null, true));
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void sendBatchCreate0(FbBatchConfig batchConfig) throws SQLException {
        try {
            this.sendBatchCreate(batchConfig);
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    protected void sendBatchCreate(FbBatchConfig batchConfig) throws SQLException, IOException {
        BlrCalculator blrCalculator = this.getBlrCalculator();
        RowDescriptor parameterDescriptor = this.getParameterDescriptor();
        byte[] blrMessage = blrCalculator.calculateBlr(parameterDescriptor);
        int messageLength = blrCalculator.calculateBatchMessageLength(parameterDescriptor);
        BatchParameterBuffer batchPb = this.createBatchParameterBuffer();
        batchConfig.populateBatchParameterBuffer(batchPb);
        this.withTransmitLock(xdrOut -> {
            xdrOut.writeInt(99);
            xdrOut.writeInt(this.getHandle());
            xdrOut.writeBuffer(blrMessage);
            xdrOut.writeInt(messageLength);
            xdrOut.writeTyped(batchPb);
            xdrOut.flush();
        });
    }

    @Override
    public void deferredBatchSend(Collection<RowValue> rowValues, DeferredResponse<Void> onResponse) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            DeferredAction deferredAction = this.wrapDeferredResponse(onResponse, r -> null, true);
            try {
                RowDescriptor parameterDescriptor = this.getParameterDescriptor();
                this.registerBlobs(this.getXdrOut(), parameterDescriptor, rowValues, deferredAction);
                this.withTransmitLock(xdrOut -> this.sendBatchMsg(xdrOut, parameterDescriptor, rowValues));
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.ioWriteError(e);
            }
            this.getDatabase().enqueueDeferredAction(deferredAction);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void sendBatchMsg(XdrOutputStream xdrOut, RowDescriptor parameterDescriptor, Collection<RowValue> rowValues) throws SQLException, IOException {
        BlrCalculator blrCalculator = this.getBlrCalculator();
        xdrOut.writeInt(100);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(rowValues.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XdrOutputStream rowOut = new XdrOutputStream(baos, 512);
        for (RowValue rowValue : rowValues) {
            baos.reset();
            this.writeSqlData(rowOut, blrCalculator, parameterDescriptor, rowValue, false);
            rowOut.flush();
            byte[] rowBytes = baos.toByteArray();
            xdrOut.write(rowBytes);
            xdrOut.writeZeroPadding(4 - rowBytes.length & 3);
        }
        xdrOut.flush();
    }

    private void registerBlobs(XdrOutputStream xdrOut, RowDescriptor parameterDescriptor, Collection<RowValue> rowValues, DeferredAction deferredAction) throws SQLException, IOException {
        int[] blobPositions = this.blobPositions(parameterDescriptor);
        if (blobPositions.length == 0) {
            return;
        }
        FbWireDatabase db = this.getDatabase();
        HashSet<Long> blobsRegistered = new HashSet<Long>((int)((float)(rowValues.size() * blobPositions.length) / 0.75f + 1.0f));
        for (RowValue rowValue : rowValues) {
            for (int position : blobPositions) {
                byte[] fieldData = rowValue.getFieldData(position);
                if (fieldData == null || !blobsRegistered.add(V16Statement.toLong(fieldData))) continue;
                this.withTransmitLock(ignored -> {
                    xdrOut.writeInt(104);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.write(fieldData);
                    xdrOut.write(fieldData);
                });
                db.enqueueDeferredAction(deferredAction);
            }
        }
        this.withTransmitLock(OutputStream::flush);
    }

    private static long toLong(byte[] bytes) {
        assert (bytes.length == 8) : "expected 8 bytes";
        return ByteBuffer.wrap(bytes).getLong();
    }

    private int[] blobPositions(RowDescriptor parameterDescriptor) {
        return parameterDescriptor.getFieldDescriptors().stream().filter(f -> f.isFbType(520)).mapToInt(FieldDescriptor::getPosition).toArray();
    }

    @Override
    public BatchCompletion batchExecute() throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkStatementValid();
            FbWireTransaction transaction = this.getTransaction();
            TransactionHelper.checkTransactionActive(transaction);
            this.sendBatchExec(transaction);
            BatchCompletion batchCompletion = this.receiveBatchExecResponse();
            if (ignored != null) {
                ignored.close();
            }
            return batchCompletion;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    private void sendBatchExec(FbTransaction transaction) throws SQLException {
        try {
            this.withTransmitLock(xdrOut -> {
                xdrOut.writeInt(101);
                xdrOut.writeInt(this.getHandle());
                xdrOut.writeInt(transaction.getHandle());
                xdrOut.flush();
            });
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private BatchCompletion receiveBatchExecResponse() throws SQLException {
        try {
            BatchCompletionResponse response = (BatchCompletionResponse)this.getDatabase().readResponse(this.getStatementWarningCallback());
            return response.batchCompletion();
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    @Override
    public void batchCancel() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.sendBatchRelease(109);
            this.receiveBatchCancelResponse();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void receiveBatchCancelResponse() throws SQLException {
        try {
            this.getDatabase().readResponse(this.getStatementWarningCallback());
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public void deferredBatchRelease(DeferredResponse<Void> onResponse) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            this.sendBatchRelease(102);
            this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(onResponse, r -> null, true));
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void sendBatchRelease(int operation) throws SQLException {
        assert (operation == 109 || operation == 102) : "Unexpected operation for batch release: " + operation;
        try {
            this.withTransmitLock(xdrOut -> {
                xdrOut.writeInt(operation);
                xdrOut.writeInt(this.getHandle());
                xdrOut.flush();
            });
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }
}

