/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.firebirdsql.ds.PooledConnectionHandler;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;
import org.firebirdsql.jaybird.xca.FatalErrorHelper;
import org.firebirdsql.jdbc.FirebirdConnection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class FBPooledConnection
implements PooledConnection {
    private final List<ConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final Lock lock = new ReentrantLock();
    private final LockCloseable unlock = this.lock::unlock;
    private Connection connection;
    private PooledConnectionHandler handler;

    FBPooledConnection(Connection connection) {
        this.connection = connection;
    }

    LockCloseable withLock() {
        this.lock.lock();
        return this.unlock;
    }

    @Override
    public Connection getConnection() throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            Connection connection = this.requireConnection();
            if (this.handler != null) {
                this.handler.close();
            }
            this.resetConnection(connection);
            this.handler = this.createConnectionHandler(connection);
            Connection connection2 = this.handler.getProxy();
            return connection2;
        }
        catch (SQLException ex) {
            this.fireFatalConnectionError(ex);
            throw ex;
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Connection requireConnection() throws SQLException {
        Connection connection = this.connection;
        if (connection != null) {
            return connection;
        }
        throw FbExceptionBuilder.toNonTransientConnectionException(337248334);
    }

    void resetConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(true);
        if (connection.isWrapperFor(FirebirdConnection.class)) {
            connection.unwrap(FirebirdConnection.class).resetKnownClientInfoProperties();
        }
    }

    PooledConnectionHandler createConnectionHandler(Connection connection) {
        return new PooledConnectionHandler(connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
            if (this.handler != null) {
                try {
                    this.handler.close();
                }
                catch (SQLException se) {
                    chain.append(se);
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException se) {
                    chain.addFirst(se);
                }
                finally {
                    this.connection = null;
                }
            }
            chain.throwIfPresent();
        }
    }

    void fireFatalConnectionError(SQLException ex) {
        ConnectionEvent evt = new ConnectionEvent(this, ex);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionErrorOccurred(evt);
        }
    }

    void fireConnectionError(SQLException ex) {
        SQLException currentException = ex;
        while (currentException != null) {
            if (FatalErrorHelper.isFatal(currentException)) {
                this.fireFatalConnectionError(ex);
                return;
            }
            currentException = ex.getNextException();
        }
    }

    void fireConnectionClosed() {
        ConnectionEvent evt = new ConnectionEvent(this);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionClosed(evt);
        }
    }

    void releaseConnectionHandler(PooledConnectionHandler pch) {
        try (LockCloseable ignored = this.withLock();){
            if (this.handler == pch) {
                this.handler = null;
            }
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }
}

