/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.jdk8;

import java.util.stream.LongStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class LongStreamSerializer
extends StdSerializer<LongStream> {
    public static final LongStreamSerializer INSTANCE = new LongStreamSerializer();

    private LongStreamSerializer() {
        super(LongStream.class);
    }

    @Override
    public void serialize(LongStream stream, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        try (LongStream ls = stream;){
            g.writeStartArray((Object)ls);
            ls.forEach(value -> g.writeNumber(value));
            g.writeEndArray();
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, (Object)stream, g.streamWriteContext().getCurrentIndex());
        }
    }
}

