/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.foreign.ForeignAbstractClassBuiltinsFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ForeignAbstractClass})
public final class ForeignAbstractClassBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignAbstractClassBuiltinsFactory.getFactories();
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InstancecheckNode
    extends PythonBinaryBuiltinNode {
        InstancecheckNode() {
        }

        @Specialization(limit="3")
        static Object check(Object self, Object instance, @CachedLibrary(value="self") InteropLibrary lib, @Cached GilNode gil) {
            gil.release(true);
            try {
                Boolean bl = lib.isMetaInstance(self, instance);
                return bl;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="__bases__", minNumOfPositionalArgs=1, isGetter=true, isSetter=false)
    @GenerateNodeFactory
    static abstract class BasesNode
    extends PythonUnaryBuiltinNode {
        BasesNode() {
        }

        @Specialization
        static Object getBases(Object self, @Bind PythonLanguage language) {
            return PFactory.createEmptyTuple(language);
        }
    }
}

