/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.cext.PythonCApiAssertions;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltinRegistry;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyCFunctionWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyDateTimeCAPIWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyMethodDefHelper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.copying.NativeLibraryLocator;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonSystemThreadTask;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.SuppressFBWarnings;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.graalvm.collections.Pair;
import org.graalvm.shadowed.com.ibm.icu.impl.Punycode;
import org.graalvm.shadowed.com.ibm.icu.text.StringPrepParseException;
import sun.misc.Unsafe;

public final class CApiContext
extends CExtContext {
    private static final TruffleString T_PY_INIT = PythonUtils.tsLiteral("PyInit_");
    private static final TruffleString T_PY_INIT_U = PythonUtils.tsLiteral("PyInitU_");
    public static final String LOGGER_CAPI_NAME = "capi";
    public static final int PY_NSMALLNEGINTS = 5;
    public static final int PY_NSMALLPOSINTS = 257;
    private static final Source MODINIT_SRC = Source.newBuilder((String)"nfi", (CharSequence)"():POINTER", (String)"modinit").build();
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger("capi");
    public static final TruffleLogger GC_LOGGER = PythonLanguage.getLogger("capi.gc");
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PythonNativeWrapper.PythonAbstractObjectNativeWrapper[] singletonNativePtrs;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PrimitiveNativeWrapper[] primitiveNativeWrapperCache;
    private Object nativeSmallIntsArray;
    private Object gcState;
    private final HashMap<Pair<TruffleString, TruffleString>, PythonModule> extensions = new HashMap(4);
    private PDict internedUnicode;
    private final ArrayList<Object> modulesByIndex = new ArrayList(0);
    public final HashMap<Long, PLock> locks = new HashMap();
    public final AtomicLong lockId = new AtomicLong();
    private final ConcurrentHashMap<Long, ThreadLocal<Object>> tssStorage = new ConcurrentHashMap();
    private final AtomicLong nextTssKey = new AtomicLong();
    public Object timezoneType;
    private PyCapsule pyDateTimeCAPICapsule;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static Object[] nativeSymbolCacheSingleContext;
    private static boolean nativeSymbolCacheSingleContextUsed;
    private final Object[] nativeSymbolCache;
    private final HashMap<Object, ClosureInfo> callableClosureByExecutable = new HashMap();
    private final HashMap<Long, ClosureInfo> callableClosures = new HashMap();
    private final HashMap<PyMethodDefHelper, Object> methodDefinitions = new HashMap(4);
    private final List<Object> loadedExtensions = new LinkedList<Object>();
    private final NativeLibraryLocator nativeLibraryLocator;
    public final BackgroundGCTask gcTask;
    private Thread backgroundGCTaskThread;
    private static final AtomicInteger nativeCAPILoaded;
    private static final byte NO_NATIVE_CONTEXT = 0;
    private static final byte ISOLATED_NATIVE_CONTEXT = 1;
    private static final byte GLOBAL_NATIVE_CONTEXT = 2;
    private Runnable nativeFinalizerRunnable;
    private Thread nativeFinalizerShutdownHook;
    private static final Set<String> C_EXT_SUPPORTED_LIST;
    private final ConcurrentHashMap<RootCallTarget, PyCFunctionWrapper> pyCFunctionWrappers = new ConcurrentHashMap(4);

    public static TruffleLogger getLogger(Class<?> clazz) {
        return PythonLanguage.getLogger("capi." + clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CApiContext(PythonContext context, Object library, NativeLibraryLocator locator) {
        super(context, library);
        this.nativeSymbolCache = new Object[NativeCAPISymbol.values().length];
        this.nativeLibraryLocator = locator;
        Class<CApiContext> clazz = CApiContext.class;
        synchronized (CApiContext.class) {
            int i;
            if (!nativeSymbolCacheSingleContextUsed && context.getLanguage().isSingleContext()) {
                assert (nativeSymbolCacheSingleContext == null);
                assert (!context.getEnv().isPreInitialization());
                nativeSymbolCacheSingleContext = this.nativeSymbolCache;
            } else if (nativeSymbolCacheSingleContext != null) {
                assert (nativeSymbolCacheSingleContextUsed);
                nativeSymbolCacheSingleContext = null;
            }
            nativeSymbolCacheSingleContextUsed = true;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.singletonNativePtrs = new PythonNativeWrapper.PythonAbstractObjectNativeWrapper[PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS.length];
            for (i = 0; i < this.singletonNativePtrs.length; ++i) {
                assert (CApiGuards.isSpecialSingleton(PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS[i]));
                this.singletonNativePtrs[i] = new PythonObjectNativeWrapper(PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS[i]);
            }
            this.primitiveNativeWrapperCache = new PrimitiveNativeWrapper[262];
            for (i = 0; i < this.primitiveNativeWrapperCache.length; ++i) {
                int value = i - 5;
                assert (CApiGuards.isSmallInteger(value));
                this.primitiveNativeWrapperCache[i] = PrimitiveNativeWrapper.createInt(value);
            }
            context.getTrue().setNativeWrapper(PrimitiveNativeWrapper.createBool(true));
            context.getFalse().setNativeWrapper(PrimitiveNativeWrapper.createBool(false));
            this.gcTask = new BackgroundGCTask(context);
            return;
        }
    }

    @CompilerDirectives.TruffleBoundary
    void addLoadedExtensionLibrary(Object nativeLibrary) {
        this.loadedExtensions.add(nativeLibrary);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object asHex(Object ptr) {
        if (ptr instanceof Number) {
            return "0x" + Long.toHexString(((Number)ptr).longValue());
        }
        return Objects.toString(ptr);
    }

    public PDict getInternedUnicode() {
        return this.internedUnicode;
    }

    public void setInternedUnicode(PDict internedUnicode) {
        this.internedUnicode = internedUnicode;
    }

    public static Object asPointer(Object ptr, InteropLibrary lib) {
        if (lib.isPointer(ptr)) {
            try {
                return lib.asPointer(ptr);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return ptr;
    }

    public long nextTssKey() {
        return this.nextTssKey.incrementAndGet();
    }

    @CompilerDirectives.TruffleBoundary
    public Object tssGet(long key) {
        ThreadLocal<Object> local = this.tssStorage.get(key);
        if (local != null) {
            return local.get();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void tssSet(long key, Object object) {
        this.tssStorage.computeIfAbsent(key, k -> new ThreadLocal()).set(object);
    }

    @CompilerDirectives.TruffleBoundary
    public void tssDelete(long key) {
        this.tssStorage.remove(key);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    static int getSingletonNativeWrapperIdx(Object obj) {
        for (int i = 0; i < PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS.length; ++i) {
            if (PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public PythonNativeWrapper.PythonAbstractObjectNativeWrapper getSingletonNativeWrapper(PythonAbstractObject obj) {
        int singletonNativePtrIdx = CApiContext.getSingletonNativeWrapperIdx(obj);
        if (singletonNativePtrIdx != -1) {
            return this.singletonNativePtrs[singletonNativePtrIdx];
        }
        return null;
    }

    private void freeSingletonNativeWrappers(CApiTransitions.HandleContext handleContext) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getContext().ownsGil());
        for (int i = 0; i < this.singletonNativePtrs.length; ++i) {
            PythonNativeWrapper.PythonAbstractObjectNativeWrapper singletonNativeWrapper = this.singletonNativePtrs[i];
            this.singletonNativePtrs[i] = null;
            assert (singletonNativeWrapper != null);
            assert (CApiContext.getSingletonNativeWrapperIdx(singletonNativeWrapper.getDelegate()) != -1);
            assert (!singletonNativeWrapper.isNative() || singletonNativeWrapper.getRefCount() == 0xFFFFFFFFL);
            if (singletonNativeWrapper.ref != null) {
                CApiTransitions.nativeStubLookupRemove(handleContext, singletonNativeWrapper.ref);
            }
            CApiTransitions.releaseNativeWrapperUncached(singletonNativeWrapper);
        }
    }

    public PrimitiveNativeWrapper getCachedPrimitiveNativeWrapper(int i) {
        assert (CApiGuards.isSmallInteger(i));
        PrimitiveNativeWrapper primitiveNativeWrapper = this.primitiveNativeWrapperCache[i + 5];
        assert (primitiveNativeWrapper.getRefCount() > 0L);
        return primitiveNativeWrapper;
    }

    public PrimitiveNativeWrapper getCachedPrimitiveNativeWrapper(long l) {
        assert (CApiGuards.isSmallLong(l));
        return this.getCachedPrimitiveNativeWrapper((int)l);
    }

    public PrimitiveNativeWrapper getCachedBooleanPrimitiveNativeWrapper(boolean b) {
        PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper;
        PythonNativeWrapper.PythonAbstractObjectNativeWrapper pythonAbstractObjectNativeWrapper = wrapper = b ? this.getContext().getTrue().getNativeWrapper() : this.getContext().getFalse().getNativeWrapper();
        assert (wrapper.getRefCount() > 0L);
        return (PrimitiveNativeWrapper)wrapper;
    }

    Object getOrCreateSmallInts() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getContext().ownsGil());
        if (this.nativeSmallIntsArray == null) {
            assert (CConstants._PY_NSMALLNEGINTS.intValue() == 5);
            assert (CConstants._PY_NSMALLPOSINTS.intValue() == 257);
            Object smallInts = CStructAccess.AllocateNode.callocUncached(262L, 8L);
            for (int i = 0; i < 262; ++i) {
                CStructAccessFactory.WriteObjectNewRefNodeGen.getUncached().writeArrayElement(smallInts, i, i - 5);
            }
            this.nativeSmallIntsArray = smallInts;
        }
        return this.nativeSmallIntsArray;
    }

    private void freeSmallInts(CApiTransitions.HandleContext handleContext) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getContext().ownsGil());
        if (this.nativeSmallIntsArray != null) {
            assert (this.verifyNativeSmallInts());
            CStructAccess.FreeNode.executeUncached(this.nativeSmallIntsArray);
            this.nativeSmallIntsArray = null;
        }
        for (PrimitiveNativeWrapper wrapper : this.primitiveNativeWrapperCache) {
            assert (wrapper.isIntLike() && CApiGuards.isSmallLong(wrapper.getLong()));
            assert (!wrapper.isNative() || wrapper.getRefCount() == 0xFFFFFFFFL);
            if (wrapper.ref != null) {
                CApiTransitions.nativeStubLookupRemove(handleContext, wrapper.ref);
            }
            CApiTransitions.releaseNativeWrapperUncached(wrapper);
        }
    }

    private boolean verifyNativeSmallInts() {
        assert (this.getContext().ownsGil());
        for (int i = 0; i < 262; ++i) {
            Object elementPtr = CStructAccess.ReadPointerNode.getUncached().readArrayElement(this.nativeSmallIntsArray, i);
            PythonNativeWrapper wrapper = CApiTransitions.ToPythonWrapperNode.executeUncached(elementPtr, false);
            if (wrapper != this.primitiveNativeWrapperCache[i]) {
                return false;
            }
            if (!this.primitiveNativeWrapperCache[i].isNative() || this.primitiveNativeWrapperCache[i].getRefCount() == 0xFFFFFFFFL) continue;
            return false;
        }
        return true;
    }

    public Object createGCState() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.gcState == null);
        PythonContext.GCState state = this.getContext().getGcState();
        Object ptr = CStructAccess.AllocateNode.allocUncached(CStructs.GCState);
        CStructAccess.WriteIntNode.writeUncached(ptr, CFields.GCState__enabled, PInt.intValue(state.isEnabled()));
        CStructAccess.WriteIntNode.writeUncached(ptr, CFields.GCState__debug, state.getDebug());
        Object generations = CStructAccess.GetElementPtrNode.getUncached().getElementPtr(ptr, CFields.GCState__generations);
        for (int i = 0; i < state.getThresholds().length; ++i) {
            CStructAccess.WriteIntNode.getUncached().writeStructArrayElement(generations, i, CFields.GCGeneration__threshold, state.getThresholds()[i]);
        }
        this.gcState = ptr;
        return this.gcState;
    }

    public Object getGCState() {
        assert (this.gcState != null);
        return this.gcState;
    }

    private void freeGCState() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.gcState != null) {
            CStructAccess.FreeNode.executeUncached(this.gcState);
            this.gcState = null;
        }
    }

    public Object getModuleByIndex(int i) {
        if (i < this.modulesByIndex.size()) {
            return this.modulesByIndex.get(i);
        }
        return null;
    }

    private static Object[] getSymbolCache(Node caller) {
        Object[] cache = nativeSymbolCacheSingleContext;
        if (cache != null) {
            return cache;
        }
        return PythonContext.get((Node)caller).getCApiContext().nativeSymbolCache;
    }

    public static boolean isIdenticalToSymbol(Object obj, NativeCAPISymbol symbol) {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary objLib = InteropLibrary.getUncached((Object)obj);
        objLib.toNative(obj);
        try {
            return CApiContext.isIdenticalToSymbol(objLib.asPointer(obj), symbol);
        }
        catch (UnsupportedMessageException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isIdenticalToSymbol(long ptr, NativeCAPISymbol symbol) {
        CompilerAsserts.neverPartOfCompilation();
        Object nativeSymbol = CApiContext.getNativeSymbol(null, symbol);
        InteropLibrary lib = InteropLibrary.getUncached((Object)nativeSymbol);
        lib.toNative(nativeSymbol);
        try {
            return lib.asPointer(nativeSymbol) == ptr;
        }
        catch (UnsupportedMessageException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getNativeSymbol(Node caller, NativeCAPISymbol symbol) {
        Object[] nativeSymbolCache = CApiContext.getSymbolCache(caller);
        Object result = nativeSymbolCache[symbol.ordinal()];
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            result = CApiContext.lookupNativeSymbol(nativeSymbolCache, symbol);
        }
        assert (result != null);
        return result;
    }

    private static Object lookupNativeSymbol(Object[] nativeSymbolCache, NativeCAPISymbol symbol) {
        CompilerAsserts.neverPartOfCompilation();
        String name = symbol.getName();
        try {
            Object nativeSymbol = InteropLibrary.getUncached().readMember(PythonContext.get(null).getCApiContext().getLibrary(), name);
            nativeSymbol = CExtCommonNodes.EnsureExecutableNode.executeUncached(nativeSymbol, symbol);
            VarHandle.storeStoreFence();
            Object object = nativeSymbol;
            nativeSymbolCache[symbol.ordinal()] = object;
            return object;
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    public void trackObject(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
    }

    public void untrackObject(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
    }

    @CompilerDirectives.TruffleBoundary
    public long getCurrentRSS() {
        if (this.backgroundGCTaskThread != null && this.backgroundGCTaskThread.isAlive()) {
            long rss = this.gcTask.currentRSS;
            if (rss == -1L) {
                try {
                    Thread.sleep(this.gcTask.rssInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                rss = this.gcTask.currentRSS;
            }
            return rss;
        }
        return 0L;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    void runBackgroundGCTask(PythonContext context) {
        CompilerAsserts.neverPartOfCompilation();
        if (context.getEnv().isPreInitialization() || context.getOption(PythonOptions.NoAsyncActions).booleanValue() || !PythonOptions.AUTOMATIC_ASYNC_ACTIONS || !context.getOption(PythonOptions.BackgroundGCTask).booleanValue()) {
            return;
        }
        this.backgroundGCTaskThread = context.createSystemThread(this.gcTask);
        this.backgroundGCTaskThread.start();
    }

    @CompilerDirectives.TruffleBoundary
    public static CApiContext ensureCapiWasLoaded(String reason) {
        try {
            return CApiContext.ensureCapiWasLoaded(null, PythonContext.get(null), StringLiterals.T_EMPTY_STRING, StringLiterals.T_EMPTY_STRING, reason);
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CApiContext ensureCapiWasLoaded(Node node, PythonContext context, TruffleString name, TruffleString path) throws IOException, LoadCExtException.ImportException, LoadCExtException.ApiInitException {
        return CApiContext.ensureCapiWasLoaded(node, context, name, path, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static CApiContext ensureCapiWasLoaded(Node node, PythonContext context, TruffleString name, TruffleString path, String reason) throws IOException, LoadCExtException.ImportException, LoadCExtException.ApiInitException {
        assert (PythonContext.get(null).ownsGil());
        if (!context.hasCApiContext()) {
            TruffleLanguage.Env env = context.getEnv();
            InteropLibrary U = InteropLibrary.getUncached();
            TruffleFile homePath = env.getInternalTruffleFile(context.getCAPIHome().toJavaStringUncached());
            String libName = PythonContext.getSupportLibName("python-native");
            TruffleFile capiFile = homePath.resolve(libName).getCanonicalFile(new LinkOption[0]);
            try {
                boolean useNative = true;
                boolean isolateNative = (Boolean)PythonOptions.IsolateNativeModules.getValue(env.getOptions());
                if (!isolateNative) {
                    useNative = nativeCAPILoaded.compareAndSet(0, 2);
                } else {
                    boolean bl = useNative = nativeCAPILoaded.compareAndSet(0, 1) || nativeCAPILoaded.get() == 1;
                }
                if (!useNative) {
                    String actualReason = "initialize native extensions support";
                    if (reason != null) {
                        actualReason = reason;
                    } else if (name != null && path != null) {
                        actualReason = String.format("load a native module '%s' from path '%s'", name.toJavaStringUncached(), path.toJavaStringUncached());
                    }
                    throw new LoadCExtException.ApiInitException(PythonUtils.toTruffleStringUncached(String.format("Option python.IsolateNativeModules is set to 'false' and a second GraalPy context attempted to %s. At least one context in this process runs with 'IsolateNativeModules' set to false. Depending on the order of context creation, this means some contexts in the process cannot use native module.", actualReason)), new Object[0]);
                }
                NativeLibraryLocator loc = new NativeLibraryLocator(context, capiFile, isolateNative);
                context.ensureNFILanguage(node, "allowNativeAccess", "true");
                String dlopenFlags = isolateNative ? "RTLD_LOCAL" : "RTLD_GLOBAL";
                Source.LiteralBuilder capiSrcBuilder = Source.newBuilder((String)"nfi", (CharSequence)String.format("load(%s) \"%s\"", dlopenFlags, loc.getCapiLibrary()), (String)"<libpython>");
                LOGGER.config(() -> "loading CAPI from " + loc.getCapiLibrary() + " as native");
                if (!context.getLanguage().getEngineOption(PythonOptions.ExposeInternalSources).booleanValue()) {
                    capiSrcBuilder.internal(true);
                }
                CallTarget capiLibraryCallTarget = context.getEnv().parseInternal(capiSrcBuilder.build(), new String[0]);
                Object capiLibrary = capiLibraryCallTarget.call(new Object[0]);
                Object initFunction = U.readMember(capiLibrary, "initialize_graal_capi");
                CApiContext cApiContext = new CApiContext(context, capiLibrary, loc);
                context.setCApiContext(cApiContext);
                try (BuiltinArrayWrapper builtinArrayWrapper = new BuiltinArrayWrapper();){
                    Object gcState = cApiContext.createGCState();
                    Object signature = env.parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"(ENV,POINTER,POINTER):VOID", (String)"exec").build(), new String[0]).call(new Object[0]);
                    initFunction = SignatureLibrary.getUncached().bind(signature, initFunction);
                    U.execute(initFunction, new Object[]{builtinArrayWrapper, gcState});
                }
                assert (PythonCApiAssertions.assertBuiltins(capiLibrary));
                cApiContext.pyDateTimeCAPICapsule = PyDateTimeCAPIWrapper.initWrapper(context, cApiContext);
                context.runCApiHooks();
                Object finalizeFunction = U.readMember(capiLibrary, "GraalPyPrivate_GetFinalizeCApiPointer");
                Object finalizeSignature = env.parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"():POINTER", (String)"exec").build(), new String[0]).call(new Object[0]);
                Object finalizingPointer = SignatureLibrary.getUncached().call(finalizeSignature, finalizeFunction, new Object[0]);
                try {
                    cApiContext.addNativeFinalizer(context, finalizingPointer);
                    cApiContext.runBackgroundGCTask(context);
                }
                catch (RuntimeException e) {
                    LOGGER.warning(() -> "didn't register a native finalizer due to: " + e.getMessage());
                }
                return cApiContext;
            }
            catch (PException e) {
                throw e;
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException | RuntimeException e) {
                if (!libName.contains("managed") && !context.isNativeAccessAllowed()) {
                    throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED, new Object[0]);
                }
                throw new LoadCExtException.ApiInitException((Exception)e);
            }
        }
        return context.getCApiContext();
    }

    private static String dlopenFlagsToString(int flags) {
        Object str = "RTLD_NOW";
        if ((flags & PosixConstants.RTLD_LAZY.value) != 0) {
            str = "RTLD_LAZY";
        }
        if ((flags & PosixConstants.RTLD_GLOBAL.value) != 0) {
            str = (String)str + "|RTLD_GLOBAL";
        }
        if ((flags & PosixConstants.RTLD_LOCAL.value) != 0) {
            str = (String)str + "|RTLD_LOCAL";
        }
        return str;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object loadCExtModule(Node location, PythonContext context, ModuleSpec spec, CExtCommonNodes.CheckFunctionResultNode checkFunctionResultNode) throws IOException, LoadCExtException.ApiInitException, LoadCExtException.ImportException {
        InteropLibrary interopLib;
        Object library;
        if (CApiContext.getLogger(CApiContext.class).isLoggable(Level.WARNING) && context.getOption(PythonOptions.WarnExperimentalFeatures).booleanValue() && !C_EXT_SUPPORTED_LIST.contains(spec.name.toJavaStringUncached())) {
            Object message = "Loading C extension module %s from '%s'. Support for the Python C API is considered experimental.";
            if (!context.getOption(PythonOptions.RunViaLauncher).booleanValue()) {
                message = (String)message + " See https://www.graalvm.org/latest/reference-manual/python/Native-Extensions/#embedding-limitations for the limitations. You can suppress this warning by setting the context option 'python.WarnExperimentalFeatures' to 'false'.";
            }
            CApiContext.getLogger(CApiContext.class).warning(((String)message).formatted(spec.name, spec.path));
        }
        CApiContext cApiContext = CApiContext.ensureCapiWasLoaded(location, context, spec.name, spec.path);
        TruffleFile realPath = context.getPublicTruffleFileRelaxed(spec.path, context.getSoAbi()).getCanonicalFile(new LinkOption[0]);
        String loadPath = cApiContext.nativeLibraryLocator.resolve(context, realPath);
        CApiContext.getLogger(CApiContext.class).config(String.format("loading module %s (real path: %s) as native", spec.path, loadPath));
        int dlopenFlags = context.getDlopenFlags();
        if (context.getOption(PythonOptions.IsolateNativeModules).booleanValue()) {
            if ((dlopenFlags & PosixConstants.RTLD_GLOBAL.value) != 0) {
                CApiContext.getLogger(CApiContext.class).warning("The IsolateNativeModules option was specified, but the dlopen flags were set to include RTLD_GLOBAL (likely via some call to sys.setdlopenflags). This will probably lead to broken isolation and possibly incorrect results and crashing. You can patch sys.setdlopenflags to trace callers and/or prevent setting the RTLD_GLOBAL flags. See https://www.graalvm.org/latest/reference-manual/python/Native-Extensions for more details.");
            }
            dlopenFlags |= PosixConstants.RTLD_LOCAL.value;
        }
        Object dlopenFlagsString = CApiContext.dlopenFlagsToString(dlopenFlags);
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            dlopenFlagsString = (String)dlopenFlagsString + "| LOAD_LIBRARY_SEARCH_DEFAULT_DIRS | LOAD_LIBRARY_SEARCH_DLL_LOAD_DIR";
        }
        Object loadExpr = String.format("load(%s) \"%s\"", dlopenFlagsString, loadPath);
        if (((Boolean)PythonOptions.UsePanama.getValue(context.getEnv().getOptions())).booleanValue()) {
            loadExpr = "with panama " + (String)loadExpr;
        }
        try {
            Source librarySource = Source.newBuilder((String)"nfi", (CharSequence)loadExpr, (String)("load " + String.valueOf(spec.name))).build();
            library = context.getEnv().parseInternal(librarySource, new String[0]).call(new Object[0]);
            interopLib = InteropLibrary.getUncached((Object)library);
        }
        catch (PException e) {
            throw e;
        }
        catch (AbstractTruffleException e) {
            if (!realPath.exists(new LinkOption[0]) && realPath.toString().contains("org.graalvm.python.vfsx")) {
                CApiContext.getLogger(CApiContext.class).severe(String.format("could not load module %s (real path: %s) from virtual file system.\n\n!!! Please try to run with java system property org.graalvm.python.vfs.extractOnStartup=true !!!\nSee also: https://www.graalvm.org/python/docs/#graalpy-troubleshooting", spec.path, realPath));
            }
            throw new LoadCExtException.ImportException(CExtContext.wrapJavaException(e, location), spec.name, spec.path, ErrorMessages.CANNOT_LOAD_M, new Object[]{spec.path, e});
        }
        try {
            return cApiContext.initCApiModule(location, library, spec.getInitFunctionName(), spec, interopLib, checkFunctionResultNode);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw new LoadCExtException.ImportException(CExtContext.wrapJavaException(e, location), spec.name, spec.path, ErrorMessages.CANNOT_INITIALIZE_WITH, spec.path, spec.getEncodedName(), "");
        }
    }

    private void addNativeFinalizer(PythonContext context, Object finalizingPointerObj) {
        Unsafe unsafe = context.getUnsafe();
        InteropLibrary lib = InteropLibrary.getUncached((Object)finalizingPointerObj);
        if (!lib.isNull(finalizingPointerObj) && lib.isPointer(finalizingPointerObj)) {
            try {
                long finalizingPointer = lib.asPointer(finalizingPointerObj);
                this.nativeFinalizerRunnable = () -> unsafe.putByte(finalizingPointer, (byte)1);
                context.registerAtexitHook(c -> this.nativeFinalizerRunnable.run());
                this.nativeFinalizerShutdownHook = new Thread(this.nativeFinalizerRunnable);
                Runtime.getRuntime().addShutdownHook(this.nativeFinalizerShutdownHook);
            }
            catch (UnsupportedMessageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void exitCApiContext() {
        CompilerAsserts.neverPartOfCompilation();
        try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
            CApiTransitions.pollReferenceQueue();
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getContext().getLanguage());
            Object nativeThreadState = PThreadState.getNativeThreadState(threadState);
            if (nativeThreadState != null) {
                CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_GC_COLLECT_NO_FAIL, nativeThreadState);
                CApiTransitions.pollReferenceQueue();
            }
            CApiTransitions.deallocateNativeWeakRefs(this.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeCApi() {
        CompilerAsserts.neverPartOfCompilation();
        PythonContext context = this.getContext();
        CApiTransitions.HandleContext handleContext = context.nativeContext;
        if (this.backgroundGCTaskThread != null && this.backgroundGCTaskThread.isAlive()) {
            context.killSystemThread(this.backgroundGCTaskThread);
            try {
                this.backgroundGCTaskThread.join(10L);
            }
            catch (InterruptedException e) {
                LOGGER.finest("got interrupt while joining GC thread before cleaning up C API state");
            }
            this.backgroundGCTaskThread = null;
        }
        CApiTransitions.disableReferenceQueuePolling(handleContext);
        TruffleSafepoint sp = TruffleSafepoint.getCurrent();
        boolean prev = sp.setAllowActions(false);
        try {
            try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
                this.freeSmallInts(handleContext);
                this.freeSingletonNativeWrappers(handleContext);
                CApiTransitions.freeNativeObjectStubs(handleContext);
                CApiTransitions.freeClassReplacements(handleContext);
                CApiTransitions.freeNativeStorages(handleContext);
            }
            if (this.pyDateTimeCAPICapsule != null) {
                PyDateTimeCAPIWrapper.destroyWrapper(this.pyDateTimeCAPICapsule);
            }
            for (Object pyMethodDefPointer : this.methodDefinitions.values()) {
                PyMethodDefHelper.free(pyMethodDefPointer);
            }
        }
        finally {
            sp.setAllowActions(prev);
        }
        if (this.nativeFinalizerShutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.nativeFinalizerShutdownHook);
                this.nativeFinalizerRunnable.run();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.pyCFunctionWrappers.clear();
        this.freeGCState();
        Class<CApiContext> clazz = CApiContext.class;
        synchronized (CApiContext.class) {
            if (nativeSymbolCacheSingleContext != null) {
                nativeSymbolCacheSingleContext = null;
                nativeSymbolCacheSingleContextUsed = false;
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            if (this.nativeLibraryLocator != null) {
                this.nativeLibraryLocator.close();
            }
            return;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object initCApiModule(Node location, Object sharedLibrary, TruffleString initFuncName, ModuleSpec spec, InteropLibrary llvmInteropLib, CExtCommonNodes.CheckFunctionResultNode checkFunctionResultNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, LoadCExtException.ImportException {
        Object nativeResult;
        Object pyinitFunc;
        PythonContext context = this.getContext();
        CApiContext cApiContext = context.getCApiContext();
        try {
            pyinitFunc = llvmInteropLib.readMember(sharedLibrary, initFuncName.toJavaStringUncached());
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e1) {
            throw new LoadCExtException.ImportException(null, spec.name, spec.path, ErrorMessages.NO_FUNCTION_FOUND, "", initFuncName, spec.path);
        }
        try {
            nativeResult = InteropLibrary.getUncached().execute(pyinitFunc, new Object[0]);
        }
        catch (UnsupportedMessageException e) {
            Object signature = context.getEnv().parseInternal(MODINIT_SRC, new String[0]).call(new Object[0]);
            nativeResult = SignatureLibrary.getUncached().call(signature, pyinitFunc, new Object[0]);
        }
        catch (ArityException e) {
            Object[] arguments = new Object[e.getExpectedMinArity()];
            Arrays.fill(arguments, PNone.NO_VALUE);
            nativeResult = InteropLibrary.getUncached().execute(pyinitFunc, arguments);
        }
        checkFunctionResultNode.execute(context, initFuncName, nativeResult);
        Object result = CApiTransitions.NativeToPythonNode.executeUncached(nativeResult);
        if (!(result instanceof PythonModule)) {
            Object clazz = GetClassNode.executeUncached(result);
            if (clazz == PNone.NO_VALUE) {
                throw PRaiseNode.raiseStatic(location, PythonBuiltinClassType.SystemError, ErrorMessages.INIT_FUNC_RETURNED_UNINT_OBJ, initFuncName);
            }
            return CExtNodesFactory.CreateModuleNodeGen.getUncached().execute(cApiContext, spec, result, sharedLibrary);
        }
        PythonModule module = (PythonModule)result;
        module.setAttribute(SpecialAttributeNames.T___FILE__, spec.path);
        module.setAttribute(SpecialAttributeNames.T___LIBRARY__, sharedLibrary);
        this.addLoadedExtensionLibrary(sharedLibrary);
        PDict sysModules = context.getSysModules();
        sysModules.setItem(spec.name, result);
        Object moduleDef = module.getNativeModuleDef();
        int mIndex = PythonUtils.toIntError(CStructAccess.ReadI64Node.getUncached().read(moduleDef, CFields.PyModuleDef_Base__m_index));
        while (this.modulesByIndex.size() <= mIndex) {
            this.modulesByIndex.add(null);
        }
        this.modulesByIndex.set(mIndex, module);
        this.extensions.put((Pair<TruffleString, TruffleString>)Pair.create((Object)spec.path, (Object)spec.name), module);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public PythonModule findExtension(TruffleString filename, TruffleString name) {
        return this.extensions.get(Pair.create((Object)filename, (Object)name));
    }

    public long getClosurePointer(Object executable) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosureByExecutable.get(executable);
        return info == null ? -1L : info.pointer;
    }

    public Object getClosureForExecutable(Object executable) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosureByExecutable.get(executable);
        return info == null ? null : info.closure;
    }

    public Object getClosureDelegate(long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosures.get(pointer);
        return info == null ? null : info.delegate;
    }

    public Object getClosureExecutable(long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosures.get(pointer);
        return info == null ? null : info.executable;
    }

    public void setClosurePointer(Object closure, Object delegate, Object executable, long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = new ClosureInfo(closure, delegate, executable, pointer);
        this.callableClosureByExecutable.put(executable, info);
        this.callableClosures.put(pointer, info);
        LOGGER.finer(() -> PythonUtils.formatJString("new NFI closure: (%s, %s) -> %d 0x%x", executable.getClass().getSimpleName(), delegate, pointer, pointer));
    }

    private static Source buildNFISource(Object srcObj) {
        return Source.newBuilder((String)"nfi", (CharSequence)((String)srcObj), (String)"exec").build();
    }

    public long registerClosure(String nfiSignature, Object executable, Object delegate, SignatureLibrary signatureLibrary) {
        CompilerAsserts.neverPartOfCompilation();
        PythonContext context = this.getContext();
        boolean panama = context.getOption(PythonOptions.UsePanama);
        String srcString = (panama ? "with panama " : "") + nfiSignature;
        Source nfiSource = context.getLanguage().getOrCreateSource(CApiContext::buildNFISource, srcString);
        Object signature = context.getEnv().parseInternal(nfiSource, new String[0]).call(new Object[0]);
        Object closure = signatureLibrary.createClosure(signature, executable);
        long pointer = PythonUtils.coerceToLong(closure, InteropLibrary.getUncached());
        this.setClosurePointer(closure, delegate, executable, pointer);
        return pointer;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOrAllocateNativePyMethodDef(PyMethodDefHelper pyMethodDef) {
        Object pyMethodDefPointer = this.methodDefinitions.computeIfAbsent(pyMethodDef, PyMethodDefHelper::allocate);
        assert (CApiContext.isPointerObject(pyMethodDefPointer));
        return pyMethodDefPointer;
    }

    @CompilerDirectives.TruffleBoundary
    public PyCFunctionWrapper getOrCreatePyCFunctionWrapper(RootCallTarget ct, Function<RootCallTarget, PyCFunctionWrapper> cons) {
        return this.pyCFunctionWrappers.computeIfAbsent(ct, cons);
    }

    public static boolean isPointerObject(Object object) {
        return object.getClass() == NativePointer.class || object.getClass().getSimpleName().contains("NFIPointer") || object.getClass().getSimpleName().contains("LLVMPointer");
    }

    static {
        nativeCAPILoaded = new AtomicInteger();
        C_EXT_SUPPORTED_LIST = Set.of("_cpython_sre", "_cpython_unicodedata", "_sha3", "_sqlite3", "termios", "pyexpat");
    }

    private static final class BackgroundGCTask
    extends PythonSystemThreadTask {
        Object nativeSymbol = null;
        InteropLibrary callNative = null;
        long currentRSS = -1L;
        long previousRSS = -1L;
        int previousWeakrefCount = -1;
        final WeakReference<PythonContext> ctx;
        final int rssInterval;
        final double gcRSSThreshold;
        final double gcRSSMinimum;

        private BackgroundGCTask(PythonContext context) {
            super("Python GC", LOGGER);
            this.ctx = new WeakReference<PythonContext>(context);
            this.rssInterval = context.getOption(PythonOptions.BackgroundGCTaskInterval);
            this.gcRSSThreshold = (double)context.getOption(PythonOptions.BackgroundGCTaskThreshold).intValue() / 100.0;
            this.gcRSSMinimum = context.getOption(PythonOptions.BackgroundGCTaskMinimum).intValue();
        }

        Long getCurrentRSS() {
            if (this.nativeSymbol == null) {
                this.nativeSymbol = CApiContext.getNativeSymbol(null, NativeCAPISymbol.FUN_GET_CURRENT_RSS);
                this.callNative = InteropLibrary.getUncached((Object)this.nativeSymbol);
            }
            Long rss = 0L;
            try {
                rss = (Long)this.callNative.execute(this.nativeSymbol, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return rss;
        }

        @Override
        protected void doRun() {
            Node location = this.getSafepointLocation();
            if (location == null) {
                return;
            }
            while (true) {
                TruffleSafepoint.setBlockedThreadInterruptible((Node)location, Thread::sleep, (Object)this.rssInterval);
                this.perform();
            }
        }

        private Node getSafepointLocation() {
            PythonContext context = (PythonContext)this.ctx.get();
            if (context == null) {
                return null;
            }
            return context.getLanguage().unavailableSafepointLocation;
        }

        private void perform() {
            PythonContext context = (PythonContext)this.ctx.get();
            if (context == null) {
                return;
            }
            this.currentRSS = this.getCurrentRSS();
            long rss = this.currentRSS;
            if (rss == 0L) {
                LOGGER.finer("We are unable to get resident set size (RSS) from the system. We will skip the java collection routine.");
                Thread.currentThread().interrupt();
                return;
            }
            if (rss < this.previousRSS || this.previousRSS == -1L) {
                this.previousRSS = rss;
                return;
            }
            if ((double)rss < this.gcRSSMinimum) {
                return;
            }
            int currentWeakrefCount = context.nativeContext.nativeLookup.size();
            if (currentWeakrefCount < this.previousWeakrefCount || this.previousWeakrefCount == -1) {
                this.previousWeakrefCount = currentWeakrefCount;
                return;
            }
            double ratio = (double)(rss - this.previousRSS) / (double)this.previousRSS;
            if (ratio >= this.gcRSSThreshold) {
                this.previousWeakrefCount = currentWeakrefCount;
                long start = System.nanoTime();
                PythonUtils.forceFullGC();
                long gcTime = (System.nanoTime() - start) / 1000000L;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.info(PythonUtils.formatJString("Background GC Task -- GC [%d ms] RSS [%d MB]->[%d MB](%.1f%%)", gcTime, this.previousRSS, rss, ratio * 100.0));
                }
                this.previousRSS += (long)((double)this.previousRSS * this.gcRSSThreshold);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class BuiltinArrayWrapper
    implements TruffleObject,
    AutoCloseable {
        private long pointer;

        BuiltinArrayWrapper() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return PythonCextBuiltinRegistry.builtins.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < (long)PythonCextBuiltinRegistry.builtins.length;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return BuiltinArrayWrapper.getCAPIBuiltinExecutable((int)index);
        }

        private static PythonCextBuiltins.CApiBuiltinExecutable getCAPIBuiltinExecutable(int id) {
            CompilerAsserts.neverPartOfCompilation();
            try {
                PythonCextBuiltins.CApiBuiltinExecutable builtin = PythonCextBuiltinRegistry.builtins[id];
                LOGGER.finer("CApiContext.BuiltinArrayWrapper.get " + id + " / " + builtin.name());
                return builtin;
            }
            catch (Throwable e) {
                e.printStackTrace(new PrintStream(PythonContext.get(null).getEnv().err()));
                throw new RuntimeException(e);
            }
        }

        @ExportMessage
        boolean isPointer() {
            return this.pointer != 0L;
        }

        @ExportMessage
        long asPointer() throws UnsupportedMessageException {
            if (this.pointer != 0L) {
                return this.pointer;
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void toNative() {
            if (this.pointer == 0L) {
                assert (PythonContext.get(null).isNativeAccessAllowed());
                Object ptr = CStructAccess.AllocateNode.callocUncached((long)PythonCextBuiltinRegistry.builtins.length, 8L);
                this.pointer = CExtCommonNodes.CoerceNativePointerToLongNode.executeUncached(ptr);
                if (this.pointer != 0L) {
                    InteropLibrary lib = null;
                    for (int i = 0; i < PythonCextBuiltinRegistry.builtins.length; ++i) {
                        PythonCextBuiltins.CApiBuiltinExecutable capiBuiltinExecutable = BuiltinArrayWrapper.getCAPIBuiltinExecutable(i);
                        if (lib == null || !lib.accepts((Object)capiBuiltinExecutable)) {
                            lib = InteropLibrary.getUncached((Object)capiBuiltinExecutable);
                        }
                        assert (lib.accepts((Object)capiBuiltinExecutable));
                        lib.toNative((Object)capiBuiltinExecutable);
                        try {
                            CStructAccess.WritePointerNode.writeArrayElementUncached(this.pointer, i, lib.asPointer((Object)capiBuiltinExecutable));
                            continue;
                        }
                        catch (UnsupportedMessageException e) {
                            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                        }
                    }
                }
            }
        }

        @Override
        public void close() {
            if (this.pointer != 0L) {
                CStructAccess.FreeNode.executeUncached(this.pointer);
            }
        }
    }

    @CompilerDirectives.ValueType
    public static final class ModuleSpec {
        public final TruffleString name;
        public final TruffleString path;
        public final Object originalModuleSpec;
        private TruffleString encodedName;
        private boolean ascii;

        public ModuleSpec(TruffleString name, TruffleString path, Object originalModuleSpec) {
            this.name = name;
            this.path = path;
            this.originalModuleSpec = originalModuleSpec;
        }

        @CompilerDirectives.TruffleBoundary
        TruffleString getEncodedName() {
            if (this.encodedName != null) {
                return this.encodedName;
            }
            TruffleString basename = CApiContext.getBaseName(this.name);
            boolean canEncode = ModuleSpec.canEncode(basename);
            if (canEncode) {
                this.ascii = true;
            } else {
                this.ascii = false;
                try {
                    basename = TruffleString.fromJavaStringUncached((String)Punycode.encode((CharSequence)basename.toJavaStringUncached(), null).toString(), (TruffleString.Encoding)PythonUtils.TS_ENCODING);
                }
                catch (StringPrepParseException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            this.encodedName = StringNodes.StringReplaceNode.getUncached().execute(basename, StringLiterals.T_DASH, StringLiterals.T_UNDERSCORE, -1);
            return this.encodedName;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean canEncode(TruffleString basename) {
            return TruffleString.GetCodeRangeNode.getUncached().execute((AbstractTruffleString)basename, PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII;
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleString getInitFunctionName() {
            TruffleString s = this.getEncodedName();
            return StringUtils.cat(this.ascii ? T_PY_INIT : T_PY_INIT_U, s);
        }
    }

    private record ClosureInfo(Object closure, Object delegate, Object executable, long pointer) {
    }
}

