/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.schemacrawler.Version;
import schemacrawler.tools.commandline.ConnectionTestCommands;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.state.StateFactory;
import schemacrawler.tools.commandline.utility.CommandLineUtility;

public final class ConnectionTest {
    private static final Logger LOGGER = Logger.getLogger(ConnectionTest.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(String[] args) {
        try (ShellState state = new ShellState();){
            Objects.requireNonNull(args, "No arguments provided");
            System.out.printf("%s%n%n", Version.about());
            state.setDeferCatalogLoad(true);
            StateFactory stateFactory = new StateFactory(state);
            ConnectionTestCommands commands = new ConnectionTestCommands();
            CommandLine commandLine = CommandLineUtility.newCommandLine(commands, stateFactory);
            commandLine.parseArgs(args);
            CommandLineUtility.printEnvironment(state);
            Throwable throwable = null;
            try {
                ConnectionTest.executeCommandLine(commandLine);
            }
            catch (Throwable e) {
                throwable = e;
            }
            System.out.printf("%n%n", new Object[0]);
            System.out.println(CommandLineUtility.getConnectionInfo(state));
            if (throwable != null) {
                System.out.println("  " + throwable.getMessage());
                LOGGER.log(Level.CONFIG, throwable.getMessage(), throwable);
            }
            System.out.flush();
            int n = 0;
            return n;
        }
    }

    private static void executeCommandLine(CommandLine commandLine) {
        Map subcommands = commandLine.getMixins();
        Runnable command = (Runnable)subcommands.get("connect");
        LOGGER.log(Level.INFO, "Running command " + command.getClass().getSimpleName());
        command.run();
    }

    private ConnectionTest() {
    }
}

