/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.builtins.objects.thread.AbstractPythonLock;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public final class PRLock
extends AbstractPythonLock {
    private final InternalReentrantLock lock = PRLock.allocateLock();

    public PRLock(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    @CompilerDirectives.TruffleBoundary
    private static InternalReentrantLock allocateLock() {
        return new InternalReentrantLock();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isOwned() {
        return this.lock.isHeldByCurrentThread();
    }

    @CompilerDirectives.TruffleBoundary
    public int getCount() {
        return this.lock.getHoldCount();
    }

    public long getOwnerId() {
        return this.lock.getOwnerId();
    }

    @CompilerDirectives.TruffleBoundary
    public void releaseAll() {
        while (this.lock.getHoldCount() > 0) {
            this.lock.unlock();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean acquireNonBlocking() {
        return this.lock.tryLock();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean acquireBlocking(Node node) {
        boolean[] b = new boolean[1];
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, l -> {
            l.lockInterruptibly();
            b[0] = true;
        }, (Object)this.lock);
        return b[0];
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean acquireTimeout(Node node, long timeout) {
        boolean[] b = new boolean[1];
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, l -> {
            b[0] = l.tryLock(timeout, TimeUnit.MILLISECONDS);
        }, (Object)this.lock);
        return b[0];
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void release() {
        this.lock.unlock();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean locked() {
        return this.lock.isLocked();
    }

    private static class InternalReentrantLock
    extends ReentrantLock {
        private static final long serialVersionUID = 2531000884985514112L;

        private InternalReentrantLock() {
        }

        @CompilerDirectives.TruffleBoundary
        long getOwnerId() {
            Thread owner = this.getOwner();
            if (owner != null) {
                return PThread.getThreadId(owner);
            }
            return 0L;
        }
    }
}

