/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.objects.ssl.SSLProtocol;
import com.oracle.truffle.api.nodes.ExplodeLoop;

public enum SSLMethod {
    SSL3(1, SSLProtocol.SSLv3),
    TLS(2),
    TLS1(3, SSLProtocol.TLSv1),
    TLS1_1(4, SSLProtocol.TLSv1_1),
    TLS1_2(5, SSLProtocol.TLSv1_2),
    TLS_CLIENT(16),
    TLS_SERVER(17);

    private final int pythonId;
    private final SSLProtocol singleVersion;

    private SSLMethod(int pythonId, SSLProtocol singleVersion) {
        this.pythonId = pythonId;
        this.singleVersion = singleVersion;
    }

    private SSLMethod(int pythonId) {
        this.pythonId = pythonId;
        this.singleVersion = null;
    }

    public int getPythonId() {
        return this.pythonId;
    }

    public boolean allowsProtocol(SSLProtocol protocol) {
        return this.singleVersion == null || this.singleVersion == protocol;
    }

    public boolean isSingleVersion() {
        return this.singleVersion != null;
    }

    @ExplodeLoop
    public static SSLMethod fromPythonId(int pythonId) {
        for (SSLMethod method : SSLMethod.values()) {
            if (method.getPythonId() != pythonId) continue;
            return method;
        }
        return null;
    }
}

