/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata;

public class Constants {
    public static final String DefaultRunId = "Default";
    public static final String OPTYPE_SQLPREPARE = "P";
    public static final String OPTYPE_SQLEXECUTION = "E";
    public static final String OPTYPE_UNKNOWN = "U";
    public static final String OPTYPE_PROJECTONLY = "X";
    public static final String OPTYPE_DEFINITION = "D";
    public static final String ExportTag_SQLPREPARE = "sqlDefinitionStackTraces";
    public static final String ExportTag_SQLEXECUTION = "sqlExecutionStackTraces";
    public static final String ExportTag_UNKNOWN = "unknownStackTraces";
    public static final String ExportTag_PROJECTONLY = "projectOnlyStackTraces";
    public static final String ExportTag_DEFINITION = "definitionStackTraces";
    public static final String Boolean_True = "Y";
    public static final String Boolean_False = "N";
    public static final char Char_Yes = 'Y';
    public static final char Char_No = 'N';

    public static enum SourceOpType {
        SQLExecution("E", "sqlExecutionStackTraces"),
        SQLPrepare("P", "sqlDefinitionStackTraces"),
        Unknown("U", "unknownStackTraces"),
        ProjectOnly("X", "projectOnlyStackTraces"),
        Definition("D", "definitionStackTraces");

        private String sqlValue = null;
        private String exportTag = null;

        private SourceOpType(String string2, String string3) {
            this.sqlValue = string2;
            this.exportTag = string3;
        }

        public String getSqlValue() {
            return this.sqlValue;
        }

        public String getExportTag() {
            return this.exportTag;
        }

        public static SourceOpType fromSQLString(String string) {
            if (Constants.OPTYPE_SQLEXECUTION.equals(string)) {
                return SQLExecution;
            }
            if (Constants.OPTYPE_SQLPREPARE.equals(string)) {
                return SQLPrepare;
            }
            if (Constants.OPTYPE_UNKNOWN.equals(string)) {
                return Unknown;
            }
            if (Constants.OPTYPE_PROJECTONLY.equals(string)) {
                return ProjectOnly;
            }
            if (Constants.OPTYPE_DEFINITION.equals(string)) {
                return Definition;
            }
            return null;
        }

        public static SourceOpType fromExportTag(String string) {
            if (Constants.ExportTag_SQLEXECUTION.equals(string)) {
                return SQLExecution;
            }
            if (Constants.ExportTag_SQLPREPARE.equals(string)) {
                return SQLPrepare;
            }
            if (Constants.ExportTag_UNKNOWN.equals(string)) {
                return Unknown;
            }
            if (Constants.ExportTag_PROJECTONLY.equals(string)) {
                return ProjectOnly;
            }
            if (Constants.ExportTag_DEFINITION.equals(string)) {
                return Definition;
            }
            return null;
        }
    }
}

