/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresolver;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.regex.Pattern;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.cache.NonCacheableCacheEntryValidity;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.UrlTemplateResource;

public class UrlTemplateResolver
extends AbstractConfigurableTemplateResolver {
    private static final Pattern JSESSIONID_PATTERN = Pattern.compile("(.*?);jsessionid(.*?)");

    @Override
    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        try {
            return new UrlTemplateResource(resourceName, characterEncoding);
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }

    @Override
    protected ICacheEntryValidity computeValidity(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        if (JSESSIONID_PATTERN.matcher(template.toLowerCase()).matches()) {
            return NonCacheableCacheEntryValidity.INSTANCE;
        }
        return super.computeValidity(configuration, ownerTemplate, template, templateResolutionAttributes);
    }
}

