/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.sql.SQLException;
import java.util.Objects;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.util.ByteArrayHelper;
import org.firebirdsql.jaybird.xca.FBManagedConnection;

public final class FBLocalTransaction {
    private final FBManagedConnection mc;
    private Xid xid = null;

    FBLocalTransaction(FBManagedConnection mc) {
        this.mc = Objects.requireNonNull(mc, "mc");
    }

    public boolean inTransaction() throws SQLException {
        return this.mc.getGDSHelper().inTransaction();
    }

    public void begin() throws SQLException {
        if (this.xid != null && this.mc.isXidActive(this.xid)) {
            throw FbExceptionBuilder.toException(337248309);
        }
        this.xid = new FBLocalXid();
        try {
            this.mc.internalStart(this.xid, 0);
        }
        catch (XAException ex) {
            this.xid = null;
            Throwable throwable = ex.getCause();
            if (throwable instanceof SQLException) {
                SQLException sqle = (SQLException)throwable;
                throw sqle;
            }
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    public void begin(String sql) throws SQLException {
        if (this.inTransaction()) {
            throw FbExceptionBuilder.toNonTransientException(337248317);
        }
        if (this.xid != null && this.mc.isXidActive(this.xid)) {
            throw FbExceptionBuilder.toException(337248309);
        }
        this.xid = new FBLocalXid();
        try {
            this.mc.internalStart(this.xid, sql);
        }
        catch (XAException ex) {
            this.xid = null;
            Throwable throwable = ex.getCause();
            if (throwable instanceof SQLException) {
                SQLException sqle = (SQLException)throwable;
                throw sqle;
            }
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    public void commit() throws SQLException {
        if (this.xid == null) {
            return;
        }
        try (LockCloseable ignored = this.mc.withLock();){
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalCommit(this.xid, true);
            }
            catch (XAException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof SQLException) {
                    SQLException sqle = (SQLException)throwable;
                    throw sqle;
                }
                throw new SQLException(ex.getMessage(), ex);
            }
            finally {
                this.xid = null;
            }
        }
    }

    public void rollback() throws SQLException {
        if (this.xid == null) {
            return;
        }
        try (LockCloseable ignored = this.mc.withLock();){
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalRollback(this.xid);
            }
            catch (XAException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof SQLException) {
                    SQLException sqle = (SQLException)throwable;
                    throw sqle;
                }
                throw new SQLException(ex.getMessage(), ex);
            }
            finally {
                this.xid = null;
            }
        }
    }

    private static final class FBLocalXid
    implements Xid {
        private static final int FORMAT_ID = 258;
        private final String strValue = "Xid[" + this.hashCode() + "]";

        private FBLocalXid() {
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return ByteArrayHelper.emptyByteArray();
        }

        @Override
        public byte[] getBranchQualifier() {
            return ByteArrayHelper.emptyByteArray();
        }

        @Override
        public int getFormatId() {
            return 258;
        }

        public String toString() {
            return this.strValue;
        }
    }
}

