/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.auth.srp;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.auth.AuthenticationPlugin;
import org.firebirdsql.gds.ng.wire.auth.AuthenticationPluginSpi;
import org.firebirdsql.gds.ng.wire.auth.srp.SrpAuthenticationPlugin;

public abstract class AbstractSrpAuthenticationPluginSpi
implements AuthenticationPluginSpi {
    private final String pluginName;
    private final String clientProofHashAlgorithm;

    protected AbstractSrpAuthenticationPluginSpi(String pluginName, String clientProofHashAlgorithm) throws SQLException {
        AbstractSrpAuthenticationPluginSpi.checkHashAlgorithmSupported(clientProofHashAlgorithm);
        this.pluginName = pluginName;
        this.clientProofHashAlgorithm = clientProofHashAlgorithm;
    }

    @Override
    public final String getPluginName() {
        return this.pluginName;
    }

    @Override
    public final AuthenticationPlugin createPlugin() {
        return new SrpAuthenticationPlugin(this.pluginName, this.clientProofHashAlgorithm);
    }

    private static void checkHashAlgorithmSupported(String hashAlgorithm) throws SQLException {
        try {
            MessageDigest.getInstance(hashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw FbExceptionBuilder.forException(337248286).messageParameter((Object)hashAlgorithm).cause(e).toSQLException();
        }
    }
}

