/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetAL16UTF16
extends CharacterSet
implements CharacterRepConstants {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    CharacterSetAL16UTF16(int id) {
        super(id);
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$8, null, id);
            }
            this.rep = 4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void from;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, characterSet);
            }
            boolean bl3 = bl2 = !from.isUnicode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void source;
            boolean ok;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, characterSet);
            }
            boolean bl2 = ok = source.rep <= 1024;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isUnicode() {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            char[] chars = new char[count >>> 1];
            int chars_len = CharacterSet.convertAL16UTF16BytesToJavaChars(bytes, offset, chars, 0, count, true);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e2) {
            return "";
        }
    }

    @Override
    @DisableTrace
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        try {
            char[] chars = new char[count >>> 1];
            int chars_len = CharacterSet.convertAL16UTF16BytesToJavaChars(bytes, offset, chars, 0, count, false);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e2) {
            CharacterSetAL16UTF16.failUTFConversion();
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] convert(String string) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$3, this, string);
            }
            byte[] byArray = CharacterSetAL16UTF16.stringToAL16UTF16Bytes((String)s2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$3, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] convertWithReplacement(String string) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$4, this, string);
            }
            byte[] byArray = CharacterSetAL16UTF16.stringToAL16UTF16Bytes((String)s2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$4, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$4, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] result;
            void count;
            void offset;
            void source;
            void from;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$5, this, characterSet, byArray, n2, n3);
            }
            if (from.rep == 4) {
                result = CharacterSetAL16UTF16.useOrCopy((byte[])source, (int)offset, (int)count);
            } else {
                String s2 = from.toString((byte[])source, (int)offset, (int)count);
                result = CharacterSetAL16UTF16.stringToAL16UTF16Bytes(s2);
            }
            byte[] byArray2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$5, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$5, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int char1;
            void walker;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$6, this, characterWalker);
            }
            byte[] bytes = walker.bytes;
            int bytes_index = walker.next;
            int bytes_end = walker.end;
            if (bytes_index + 1 >= bytes_end) {
                CharacterSetAL16UTF16.failUTFConversion();
            }
            byte c1 = bytes[bytes_index++];
            byte c2 = bytes[bytes_index++];
            int result = char1 = (int)(c1 << 8 | c2 & 0xFF);
            if (Character.isHighSurrogate((char)char1)) {
                if (bytes_index + 1 >= bytes_end) {
                    CharacterSetAL16UTF16.failUTFConversion();
                }
                c1 = bytes[bytes_index++];
                c2 = bytes[bytes_index++];
                char char2 = (char)(c1 << 8 & 0xFF00 | c2 & 0xFF);
                result = Character.toCodePoint((char)char1, char2);
            }
            walker.next = bytes_index;
            int n2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void buffer;
            void c2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$7, this, characterBuffer, n2);
            }
            boolean isSup = Character.isSupplementaryCodePoint((int)c2);
            if (c2 > 65535 && !isSup) {
                CharacterSetAL16UTF16.failUTFConversion();
            } else if (!isSup) {
                CharacterSetAL16UTF16.need((CharacterBuffer)buffer, 2);
                buffer.bytes[buffer.next++] = (byte)(c2 >> 8 & 0xFF);
                buffer.bytes[buffer.next++] = (byte)(c2 & 0xFF);
            } else {
                CharacterSetAL16UTF16.need((CharacterBuffer)buffer, 4);
                char[] chars = Character.toChars((int)c2);
                buffer.bytes[buffer.next++] = (byte)(chars[0] >> 8 & 0xFF);
                buffer.bytes[buffer.next++] = (byte)(chars[0] & 0xFF);
                buffer.bytes[buffer.next++] = (byte)(chars[1] >> 8 & 0xFF);
                buffer.bytes[buffer.next++] = (byte)(chars[1] & 0xFF);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterSetAL16UTF16.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = CharacterSetAL16UTF16.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = CharacterSetAL16UTF16.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = CharacterSetAL16UTF16.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = CharacterSetAL16UTF16.class.getDeclaredMethod("convert", CharacterSet.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = CharacterSetAL16UTF16.class.getDeclaredMethod("convertWithReplacement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = CharacterSetAL16UTF16.class.getDeclaredMethod("convert", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSetAL16UTF16.class.getDeclaredMethod("isUnicode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSetAL16UTF16.class.getDeclaredMethod("isConvertibleFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetAL16UTF16.class.getDeclaredMethod("isLossyFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

