/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.sql.SQLName;

public interface OracleTypeMetaData {
    public Kind getKind();

    public String getName() throws SQLException;

    public SQLName getSQLName() throws SQLException;

    public String getSchemaName() throws SQLException;

    public int getTypeCode() throws SQLException;

    public String getTypeCodeName() throws SQLException;

    public static interface Struct
    extends OracleTypeMetaData {
        public int getTypeVersion() throws SQLException;

        public int getLength() throws SQLException;

        public ResultSetMetaData getMetaData() throws SQLException;

        public boolean isFinalType() throws SQLException;

        public boolean isSubtype() throws SQLException;

        public boolean isInstantiable() throws SQLException;

        public String getSupertypeName() throws SQLException;

        public int getLocalAttributeCount() throws SQLException;

        public String[] getSubtypeNames() throws SQLException;
    }

    public static interface Opaque
    extends OracleTypeMetaData {
        public long getMaxLength() throws SQLException;

        public boolean isTrustedLibrary() throws SQLException;

        public boolean isModeledInC() throws SQLException;

        public boolean hasUnboundedSize() throws SQLException;

        public boolean hasFixedSize() throws SQLException;
    }

    public static interface Array
    extends OracleTypeMetaData {
        public int getBaseType() throws SQLException;

        public String getBaseName() throws SQLException;

        public ArrayStorage getArrayStorage() throws SQLException;

        public long getMaxLength() throws SQLException;
    }

    public static final class ArrayStorage
    extends Enum<ArrayStorage> {
        public static final /* enum */ ArrayStorage VARRAY;
        public static final /* enum */ ArrayStorage NESTED_TABLE;
        private static final Map<Integer, ArrayStorage> lookup;
        private final int code;
        private static final /* synthetic */ ArrayStorage[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static ArrayStorage[] values() {
            return (ArrayStorage[])$VALUES.clone();
        }

        public static ArrayStorage valueOf(String name) {
            return Enum.valueOf(ArrayStorage.class, name);
        }

        public static ArrayStorage withCode(int code) {
            return lookup.get(code);
        }

        private ArrayStorage(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static {
            try {
                $$$methodRef$$$4 = ArrayStorage.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ArrayStorage.class.getDeclaredMethod("getCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ArrayStorage.class.getDeclaredMethod("withCode", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ArrayStorage.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ArrayStorage.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            VARRAY = new ArrayStorage(3);
            NESTED_TABLE = new ArrayStorage(2);
            $VALUES = new ArrayStorage[]{VARRAY, NESTED_TABLE};
            lookup = new HashMap<Integer, ArrayStorage>(2);
            for (ArrayStorage s2 : ArrayStorage.values()) {
                lookup.put(s2.getCode(), s2);
            }
        }
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind ARRAY;
        public static final /* enum */ Kind OPAQUE;
        public static final /* enum */ Kind STRUCT;
        public static final /* enum */ Kind TYPE;
        private static final /* synthetic */ Kind[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = Kind.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Kind.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Kind.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ARRAY = new Kind();
            OPAQUE = new Kind();
            STRUCT = new Kind();
            TYPE = new Kind();
            $VALUES = new Kind[]{ARRAY, OPAQUE, STRUCT, TYPE};
        }
    }
}

