/*
 * Decompiled with CFR 0.152.
 */
package com.informix.judr;

import com.informix.judr.JUDRJarName;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class JUDRUtils {
    private JUDRUtils() {
    }

    public static List<String> getInstallSqlStatementsFromClassFile(Class<?> clazz, String jarName) throws SQLException {
        return JUDRUtils.getInstallSqlStatementsFromClassFile(clazz, jarName, "");
    }

    public static List<String> getInstallSqlStatementsFromClassFile(Class<?> clazz, String jarName, String functionPrefix) throws SQLException {
        ArrayList<String> sqlCommands = new ArrayList<String>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
            Class<?> returnType = m.getReturnType();
            StringBuilder sb = new StringBuilder("CREATE ");
            sb.append(returnType == Void.TYPE ? "PROCEDURE " : "FUNCTION ");
            sb.append(functionPrefix);
            sb.append(m.getName());
            sb.append('(');
            sb.append(JUDRUtils.buildInformixParameters(m));
            sb.append(')');
            if (returnType != Void.TYPE) {
                if (IfxTypes.fromJavaToIfxTypeName(returnType) == null) {
                    throw new SQLException("Cannot auto-map parameter [" + returnType.getCanonicalName() + "] to an Informix type");
                }
                sb.append(" RETURNS ");
                sb.append(IfxTypes.fromJavaToIfxTypeName(returnType));
            }
            if (jarName == null || jarName.isEmpty()) {
                sb.append(" EXTERNAL NAME '" + clazz.getCanonicalName() + '.' + m.getName() + '(');
            } else {
                sb.append(" EXTERNAL NAME '" + jarName + ':' + clazz.getCanonicalName() + '.' + m.getName() + '(');
            }
            sb.append(JUDRUtils.buildJavaParameters(m));
            sb.append(")' LANGUAGE JAVA;");
            sqlCommands.add(sb.toString());
        }
        return sqlCommands;
    }

    public static List<String> getUninstallSqlStatementsFromClassFile(Class<?> clazz, String functionPrefix) throws SQLException {
        ArrayList<String> sqlCommands = new ArrayList<String>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
            StringBuilder sb = new StringBuilder("DROP ");
            sb.append(m.getReturnType() == Void.TYPE ? "PROCEDURE " : "FUNCTION ");
            sb.append(functionPrefix);
            sb.append(m.getName());
            sb.append('(');
            sb.append(JUDRUtils.buildInformixParameters(m));
            sb.append(')');
            sqlCommands.add(sb.toString());
        }
        return sqlCommands;
    }

    public static List<String> getGrantPermissionCommands(Class<?> clazz) throws SQLException {
        return JUDRUtils.getGrantPermissionCommands(clazz, "", "PUBLIC");
    }

    public static List<String> getGrantPermissionCommands(Class<?> clazz, String functionPrefix, String grantee) throws SQLException {
        ArrayList<String> sqlCommands = new ArrayList<String>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
            StringBuilder sb = new StringBuilder("GRANT EXECUTE ON ");
            sb.append(m.getReturnType() == Void.TYPE ? "PROCEDURE " : "FUNCTION ");
            sb.append(functionPrefix);
            sb.append(m.getName());
            sb.append('(');
            sb.append(JUDRUtils.buildInformixParameters(m));
            sb.append(") TO " + grantee);
            sqlCommands.add(sb.toString());
        }
        return sqlCommands;
    }

    private static String buildJavaParameters(Method m) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Class<?> param : m.getParameterTypes()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(param.getCanonicalName());
        }
        return sb.toString();
    }

    private static String buildInformixParameters(Method m) throws SQLException {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (Class<?> param : m.getParameterTypes()) {
            if (IfxTypes.fromJavaToIfxTypeName(param) == null) {
                throw new SQLException("Cannot auto-map parameter [" + param.getCanonicalName() + "] to an Informix type");
            }
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(IfxTypes.fromJavaToIfxTypeName(param));
        }
        return sb.toString();
    }

    public static void replaceJudrJar(Connection myConn, Path jarFile, JUDRJarName jarName) throws SQLException {
        JUDRUtils.removeJudrJar(myConn, jarName);
        JUDRUtils.installJar(myConn, jarFile, jarName);
    }

    public static void removeJudrJar(Connection myConn, JUDRJarName jarName) throws SQLException {
        JUDRUtils.buildJudrJarTable(myConn);
        try (PreparedStatement p = myConn.prepareStatement("DELETE FROM 'sqlj'.retained_jars WHERE jarname=?");){
            p.setString(1, jarName.getCanonicalName());
            p.execute();
        }
    }

    public static void installJar(Connection myConn, Path jarFile, JUDRJarName jarName) throws SQLException {
        JUDRUtils.buildJudrJarTable(myConn);
        File jar = jarFile.toFile();
        String canonicalPath = null;
        try {
            canonicalPath = jar.getCanonicalPath();
        }
        catch (Exception e) {
            throw new SQLException("Error resolving canonical path for jar file", e);
        }
        if (jar.isAbsolute() || canonicalPath.contains("..")) {
            throw new SecurityException("Potential path traversal detected: " + canonicalPath);
        }
        try (FileInputStream inStream = new FileInputStream(jar);
             PreparedStatement prep = myConn.prepareStatement("insert into 'sqlj'.retained_jars values(?, ?)");){
            prep.setString(1, jarName.getCanonicalName());
            prep.setBinaryStream(2, inStream);
            prep.executeUpdate();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException((Throwable)e, -9481, new Object[0]);
        }
    }

    private static void buildJudrJarTable(Connection con) throws SQLException {
        try (Statement s = con.createStatement();){
            s.execute("create table if not exists 'sqlj'.retained_jars(jarname varchar(255) not null unique, jardata Blob)");
            s.execute("create table if not exists 'sqlj'.udtextnames(sqlname varchar(255) unique, externalname varchar(255))");
            s.execute("create table if not exists 'sqlj'.alter_java_paths(jarname varchar(255) not null unique, jarpath varchar(255) not null)");
        }
    }
}

