/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashMap;
import java.util.Map;

public class ASN1Helper {
    static final TruffleString T_JAVA_X509_CA_ISSUERS = PythonUtils.tsLiteral("caIssuers");
    static final TruffleString T_JAVA_X509_COMMON_NAME = PythonUtils.tsLiteral("commonName");
    static final TruffleString T_JAVA_X509_COUNTRY_NAME = PythonUtils.tsLiteral("countryName");
    static final TruffleString T_JAVA_X509_CRL_DISTRIBUTION_POINTS = PythonUtils.tsLiteral("crlDistributionPoints");
    static final TruffleString T_JAVA_X509_ISSUER = PythonUtils.tsLiteral("issuer");
    static final TruffleString T_JAVA_X509_LOCALITY_NAME = PythonUtils.tsLiteral("localityName");
    static final TruffleString T_JAVA_X509_NOT_BEFORE = PythonUtils.tsLiteral("notBefore");
    static final TruffleString T_JAVA_X509_NOT_AFTER = PythonUtils.tsLiteral("notAfter");
    static final TruffleString T_JAVA_X509_OCSP = PythonUtils.tsLiteral("OCSP");
    static final TruffleString T_JAVA_X509_ORGANIZATIONAL_UNIT_NAME = PythonUtils.tsLiteral("organizationalUnitName");
    static final TruffleString T_JAVA_X509_ORGANIZATION_NAME = PythonUtils.tsLiteral("organizationName");
    static final TruffleString T_JAVA_X509_SERIAL_NUMBER = PythonUtils.tsLiteral("serialNumber");
    static final TruffleString T_JAVA_X509_STATE_OR_PROVICE_NAME = PythonUtils.tsLiteral("stateOrProvinceName");
    static final TruffleString T_JAVA_X509_SUBJECT_ALT_NAME = PythonUtils.tsLiteral("subjectAltName");
    static final TruffleString T_JAVA_X509_SUBJECT = PythonUtils.tsLiteral("subject");
    static final TruffleString T_JAVA_X509_VERSION = PythonUtils.tsLiteral("version");
    static final String ASN1_EMAILADDRESS = "EMAILADDRESS";
    static final String ASN1_EMAIL = "EMAIL";
    static final String OID_CRL_DISTRIBUTION_POINTS = "2.5.29.31";
    static final byte[] OID_OCSP = new byte[]{1, 5, 5, 7, 48, 1};
    static final byte[] OID_CA_ISSUERS = new byte[]{1, 5, 5, 7, 48, 2};
    static final String OID_AUTHORITY_INFO_ACCESS = "1.3.6.1.5.5.7.1.1";
    private static final Map<String, TruffleString> javaToName = new HashMap<String, TruffleString>();

    @CompilerDirectives.TruffleBoundary
    public static TruffleString translateKeyToPython(String javaName) {
        TruffleString pythonName = javaToName.get(javaName);
        return pythonName == null ? PythonUtils.toTruffleStringUncached(javaName) : pythonName;
    }

    static {
        javaToName.put("CN", T_JAVA_X509_COMMON_NAME);
        javaToName.put("C", T_JAVA_X509_COUNTRY_NAME);
        javaToName.put("L", T_JAVA_X509_LOCALITY_NAME);
        javaToName.put("S", T_JAVA_X509_STATE_OR_PROVICE_NAME);
        javaToName.put("ST", T_JAVA_X509_STATE_OR_PROVICE_NAME);
        javaToName.put("O", T_JAVA_X509_ORGANIZATION_NAME);
        javaToName.put("OU", T_JAVA_X509_ORGANIZATIONAL_UNIT_NAME);
        javaToName.put("T", PythonUtils.tsLiteral("title"));
        javaToName.put("IP", PythonUtils.tsLiteral("ipAddress"));
        javaToName.put("STREET", PythonUtils.tsLiteral("streetAddress"));
        javaToName.put("DC", PythonUtils.tsLiteral("domainComponent"));
        javaToName.put("DNQUALIFIER", PythonUtils.tsLiteral("dnQualifier"));
        javaToName.put("DNQ", PythonUtils.tsLiteral("dnQualifier"));
        javaToName.put("SURNAME", PythonUtils.tsLiteral("surname"));
        javaToName.put("GIVENNAME", PythonUtils.tsLiteral("givenName"));
        javaToName.put("INITIALS", PythonUtils.tsLiteral("initials"));
        javaToName.put("GENERATION", PythonUtils.tsLiteral("generationQualifier"));
        javaToName.put(ASN1_EMAIL, PythonUtils.tsLiteral("emailAddress"));
        javaToName.put(ASN1_EMAILADDRESS, PythonUtils.tsLiteral("emailAddress"));
        javaToName.put("UID", PythonUtils.tsLiteral("userId"));
        javaToName.put("SERIALNUMBER", T_JAVA_X509_SERIAL_NUMBER);
        javaToName.put("OID.1.2.840.113549.1.9.1", PythonUtils.tsLiteral("emailAddress"));
        javaToName.put("OID.2.5.4.3", T_JAVA_X509_COMMON_NAME);
        javaToName.put("OID.2.5.4.4", PythonUtils.tsLiteral("surname"));
        javaToName.put("OID.2.5.4.5", T_JAVA_X509_SERIAL_NUMBER);
        javaToName.put("OID.2.5.4.6", T_JAVA_X509_COUNTRY_NAME);
        javaToName.put("OID.2.5.4.7", T_JAVA_X509_LOCALITY_NAME);
        javaToName.put("OID.2.5.4.8", T_JAVA_X509_STATE_OR_PROVICE_NAME);
        javaToName.put("OID.2.5.4.9", PythonUtils.tsLiteral("streetAddress"));
        javaToName.put("OID.2.5.4.10", T_JAVA_X509_ORGANIZATION_NAME);
        javaToName.put("OID.2.5.4.11", T_JAVA_X509_ORGANIZATIONAL_UNIT_NAME);
        javaToName.put("OID.2.5.4.12", PythonUtils.tsLiteral("title"));
        javaToName.put("OID.2.5.4.13", PythonUtils.tsLiteral("description"));
        javaToName.put("OID.2.5.4.14", PythonUtils.tsLiteral("searchGuide"));
        javaToName.put("OID.2.5.4.15", PythonUtils.tsLiteral("businessCategory"));
        javaToName.put("OID.2.5.4.16", PythonUtils.tsLiteral("postalAddress"));
        javaToName.put("OID.2.5.4.17", PythonUtils.tsLiteral("postalCode"));
        javaToName.put("OID.2.5.4.18", PythonUtils.tsLiteral("postOfficeBox"));
        javaToName.put("OID.2.5.4.19", PythonUtils.tsLiteral("physicalDeliveryOfficeName"));
        javaToName.put("OID.2.5.4.20", PythonUtils.tsLiteral("telephoneNumber"));
        javaToName.put("OID.2.5.4.21", PythonUtils.tsLiteral("telexNumber"));
        javaToName.put("OID.2.5.4.22", PythonUtils.tsLiteral("teletexTerminalIdentifier"));
        javaToName.put("OID.2.5.4.23", PythonUtils.tsLiteral("facsimileTelephoneNumber"));
        javaToName.put("OID.2.5.4.24", PythonUtils.tsLiteral("x121Address"));
        javaToName.put("OID.2.5.4.25", PythonUtils.tsLiteral("internationaliSDNNumber"));
        javaToName.put("OID.2.5.4.26", PythonUtils.tsLiteral("registeredAddress"));
        javaToName.put("OID.2.5.4.27", PythonUtils.tsLiteral("destinationIndicator"));
        javaToName.put("OID.2.5.4.28", PythonUtils.tsLiteral("preferredDeliveryMethod"));
        javaToName.put("OID.2.5.4.29", PythonUtils.tsLiteral("presentationAddress"));
        javaToName.put("OID.2.5.4.30", PythonUtils.tsLiteral("supportedApplicationContext"));
        javaToName.put("OID.2.5.4.31", PythonUtils.tsLiteral("member"));
        javaToName.put("OID.2.5.4.32", PythonUtils.tsLiteral("owner"));
        javaToName.put("OID.2.5.4.33", PythonUtils.tsLiteral("roleOccupant"));
        javaToName.put("OID.2.5.4.34", PythonUtils.tsLiteral("seeAlso"));
        javaToName.put("OID.2.5.4.35", PythonUtils.tsLiteral("userPassword"));
        javaToName.put("OID.2.5.4.36", PythonUtils.tsLiteral("userCertificate"));
        javaToName.put("OID.2.5.4.37", PythonUtils.tsLiteral("cACertificate"));
        javaToName.put("OID.2.5.4.38", PythonUtils.tsLiteral("authorityRevocationList"));
        javaToName.put("OID.2.5.4.39", PythonUtils.tsLiteral("certificateRevocationList"));
        javaToName.put("OID.2.5.4.40", PythonUtils.tsLiteral("crossCertificatePair"));
        javaToName.put("OID.2.5.4.41", PythonUtils.tsLiteral("name"));
        javaToName.put("OID.2.5.4.42", PythonUtils.tsLiteral("givenName"));
        javaToName.put("OID.2.5.4.43", PythonUtils.tsLiteral("initials"));
        javaToName.put("OID.2.5.4.44", PythonUtils.tsLiteral("generationQualifier"));
        javaToName.put("OID.2.5.4.45", PythonUtils.tsLiteral("x500UniqueIdentifier"));
        javaToName.put("OID.2.5.4.46", PythonUtils.tsLiteral("dnQualifier"));
        javaToName.put("OID.2.5.4.47", PythonUtils.tsLiteral("enhancedSearchGuide"));
        javaToName.put("OID.2.5.4.48", PythonUtils.tsLiteral("protocolInformation"));
        javaToName.put("OID.2.5.4.49", PythonUtils.tsLiteral("distinguishedName"));
        javaToName.put("OID.2.5.4.50", PythonUtils.tsLiteral("uniqueMember"));
        javaToName.put("OID.2.5.4.51", PythonUtils.tsLiteral("houseIdentifier"));
        javaToName.put("OID.2.5.4.52", PythonUtils.tsLiteral("supportedAlgorithms"));
        javaToName.put("OID.2.5.4.53", PythonUtils.tsLiteral("deltaRevocationList"));
        javaToName.put("OID.2.5.4.54", PythonUtils.tsLiteral("dmdName"));
        javaToName.put("OID.2.5.4.65", PythonUtils.tsLiteral("pseudonym"));
        javaToName.put("OID.2.5.4.72", PythonUtils.tsLiteral("role"));
        javaToName.put("OID.2.5.4.97", PythonUtils.tsLiteral("organizationIdentifier"));
        javaToName.put("OID.2.5.4.98", PythonUtils.tsLiteral("countryCode3c"));
        javaToName.put("OID.2.5.4.99", PythonUtils.tsLiteral("countryCode3n"));
        javaToName.put("OID.2.5.4.100", PythonUtils.tsLiteral("dnsName"));
        javaToName.put("OID.1.3.6.1.4.1.311.60.2.1.1", PythonUtils.tsLiteral("jurisdictionLocalityName"));
        javaToName.put("OID.1.3.6.1.4.1.311.60.2.1.2", PythonUtils.tsLiteral("jurisdictionStateOrProvinceName"));
        javaToName.put("OID.1.3.6.1.4.1.311.60.2.1.3", PythonUtils.tsLiteral("jurisdictionCountryName"));
    }
}

