/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCacheKey;

class DownHostsCache {
    private static final DownHostsCache SOLE_INSTANCE;
    static int DOWN_HOSTS_TIMEOUT;
    private static final int MIN_TIME_BETWEEN_PURGES = 60;
    private Map<DownHostsCacheKey, LocalDateTime> downHostsCacheMap = new ConcurrentHashMap<DownHostsCacheKey, LocalDateTime>();
    private LocalDateTime lastPurge = LocalDateTime.MIN;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    private DownHostsCache() {
    }

    static DownHostsCache getInstance() {
        return SOLE_INSTANCE;
    }

    LocalDateTime markDownHost(InetAddress inetAddress, int port) {
        return this.downHostsCacheMap.put(new DownHostsCacheKey(inetAddress.getHostAddress(), port), LocalDateTime.now());
    }

    void reorderAddresses(InetAddress[] inetAddress, int port) {
        this.refreshCache();
        int topListIndex = 0;
        int bottomListIndex = inetAddress.length - 1;
        while (topListIndex < bottomListIndex) {
            while (topListIndex <= bottomListIndex && !this.isDownHostsCached(inetAddress[topListIndex], port)) {
                ++topListIndex;
            }
            while (bottomListIndex >= topListIndex && this.isDownHostsCached(inetAddress[bottomListIndex], port)) {
                --bottomListIndex;
            }
            if (topListIndex >= bottomListIndex) continue;
            DownHostsCache.swap(inetAddress, topListIndex, bottomListIndex);
        }
    }

    private static <T> void swap(T[] array, int indexLow, int indexHigh) {
        T swapped = array[indexLow];
        array[indexLow] = array[indexHigh];
        array[indexHigh] = swapped;
    }

    private void refreshCache() {
        if (LocalDateTime.now().minus(60L, ChronoUnit.SECONDS).isAfter(this.lastPurge)) {
            for (DownHostsCacheKey downHostsCacheKey : this.downHostsCacheMap.keySet()) {
                LocalDateTime entryTime = this.downHostsCacheMap.get(downHostsCacheKey);
                if (entryTime == null || LocalDateTime.now().minus(DOWN_HOSTS_TIMEOUT, ChronoUnit.SECONDS).compareTo(entryTime) <= 0) continue;
                this.downHostsCacheMap.remove(downHostsCacheKey);
            }
            this.lastPurge = LocalDateTime.now();
        }
    }

    private boolean isDownHostsCached(InetAddress inetAddress, int port) {
        DownHostsCacheKey downHostsCacheKey = new DownHostsCacheKey(inetAddress.getHostAddress(), port);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }

    LocalDateTime markDownHost(ConnOption connOption) {
        return this.downHostsCacheMap.put(new DownHostsCacheKey(connOption.addr, connOption.port), LocalDateTime.now());
    }

    void reorderAddresses(List<ConnOption> connOptions) {
        this.refreshCache();
        int topListIndex = 0;
        int bottomListIndex = connOptions.size() - 1;
        while (topListIndex < bottomListIndex) {
            while (topListIndex <= bottomListIndex && !this.isDownHostsCached(connOptions.get(topListIndex))) {
                ++topListIndex;
            }
            while (bottomListIndex >= topListIndex && this.isDownHostsCached(connOptions.get(bottomListIndex))) {
                --bottomListIndex;
            }
            if (topListIndex >= bottomListIndex) continue;
            Collections.swap(connOptions, topListIndex, bottomListIndex);
        }
    }

    private boolean isDownHostsCached(ConnOption connOption) {
        DownHostsCacheKey downHostsCacheKey = new DownHostsCacheKey(connOption.addr, connOption.port);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }

    static {
        try {
            $$$methodRef$$$9 = DownHostsCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = DownHostsCache.class.getDeclaredMethod("isDownHostsCached", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = DownHostsCache.class.getDeclaredMethod("reorderAddresses", List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = DownHostsCache.class.getDeclaredMethod("markDownHost", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DownHostsCache.class.getDeclaredMethod("isDownHostsCached", InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DownHostsCache.class.getDeclaredMethod("refreshCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DownHostsCache.class.getDeclaredMethod("swap", Object[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DownHostsCache.class.getDeclaredMethod("reorderAddresses", InetAddress[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DownHostsCache.class.getDeclaredMethod("markDownHost", InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DownHostsCache.class.getDeclaredMethod("getInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        SOLE_INSTANCE = new DownHostsCache();
        DOWN_HOSTS_TIMEOUT = Integer.parseInt("600");
    }
}

