/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class StatisticsTracker
implements Serializable {
    private final Integer FIXED_VALUE;
    private ConcurrentHashMap<oracle.jdbc.replay.internal.ReplayStatistics, Integer> acStatistics;
    private AtomicBoolean dsNameSet;
    private ReplayStatisticsImpl aggregateStats;
    private String dsName;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public StatisticsTracker() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$7, null, new Object[0]);
            }
            this.FIXED_VALUE = 1;
            this.acStatistics = new ConcurrentHashMap();
            this.dsNameSet = new AtomicBoolean(false);
            this.aggregateStats = new ReplayStatisticsImpl();
            this.dsName = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    public ReplayStatistics getReplayStatistics() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$0, this, new Object[0]);
            }
            long totalRequests = 0L;
            long totalCompletedRequests = 0L;
            long totalCalls = 0L;
            long totalProtectedCalls = 0L;
            long totalCallsAffectedByOutages = 0L;
            long totalCallsTriggeringReplay = 0L;
            long totalCallsAffectedByOutagesDuringReplay = 0L;
            long successfulReplayCount = 0L;
            long failedReplayCount = 0L;
            long replayDisablingCount = 0L;
            long totalReplayAttempts = 0L;
            int[] histogram = new int[31];
            for (oracle.jdbc.replay.internal.ReplayStatistics stats : this.acStatistics.keySet()) {
                totalRequests += stats.getTotalRequests();
                totalCompletedRequests += stats.getTotalCompletedRequests();
                totalCalls += stats.getTotalCalls();
                totalProtectedCalls += stats.getTotalProtectedCalls();
                totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
                totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
                totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
                successfulReplayCount += stats.getSuccessfulReplayCount();
                failedReplayCount += stats.getFailedReplayCount();
                replayDisablingCount += stats.getReplayDisablingCount();
                totalReplayAttempts += stats.getTotalReplayAttempts();
                int[] h2 = stats.getRequestSizeHistogram();
                if (h2 == null || h2.length <= 0) continue;
                for (int i2 = 0; i2 < h2.length; ++i2) {
                    int n2 = i2;
                    histogram[n2] = histogram[n2] + h2[i2];
                }
            }
            ReplayStatisticsImpl globalStats = new ReplayStatisticsImpl(totalRequests, totalCompletedRequests, totalCalls, totalProtectedCalls, totalCallsAffectedByOutages, totalCallsTriggeringReplay, totalCallsAffectedByOutagesDuringReplay, successfulReplayCount, failedReplayCount, replayDisablingCount, totalReplayAttempts, 0);
            globalStats.setRequestSizeHistogram(histogram);
            globalStats.aggregate(this.aggregateStats);
            ReplayStatisticsImpl replayStatisticsImpl = globalStats;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$0, this, replayStatisticsImpl);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$0, this, null);
            }
            return replayStatisticsImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String getReplayStatisticsString() {
        ReplayStatisticsImpl globalStats = (ReplayStatisticsImpl)this.getReplayStatistics();
        StringBuilder builder = new StringBuilder();
        builder.append(globalStats.toString()).append("\n\n").append(globalStats.getRequestSizeHistogramString()).append("\n\n");
        return builder.toString();
    }

    public void clearReplayStatistics() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$1, this, new Object[0]);
            }
            this.acStatistics = new ConcurrentHashMap();
            this.aggregateStats = new ReplayStatisticsImpl();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateReplayStatistics(String string, oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newStats;
            void dsName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$2, this, string, replayStatistics);
            }
            if (this.dsNameSet.compareAndSet(false, true) && dsName != null) {
                this.dsName = dsName;
            }
            if (newStats != null) {
                this.acStatistics.put((oracle.jdbc.replay.internal.ReplayStatistics)newStats, this.FIXED_VALUE);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeReplayStatistics(oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$3, this, replayStatistics);
                }
                try {
                    void stats;
                    OracleDriver.getExecutorService().submit(new Runnable((oracle.jdbc.replay.internal.ReplayStatistics)stats){
                        final /* synthetic */ oracle.jdbc.replay.internal.ReplayStatistics val$stats;
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        {
                            this.val$stats = replayStatistics;
                        }

                        @Override
                        public void run() {
                            block3: {
                                boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                                try {
                                    if (this.val$stats != null) {
                                        StatisticsTracker.access$000(StatisticsTracker.this).remove(this.val$stats);
                                    }
                                    StatisticsTracker.access$100(StatisticsTracker.this).aggregate(this.val$stats);
                                }
                                catch (Throwable err) {
                                    if (!bl) break block3;
                                    OracleLog.log($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "Async AC statistics-removal task failed: {0}", err);
                                }
                            }
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(StatisticsTracker.class, oracle.jdbc.replay.internal.ReplayStatistics.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                }
                catch (Throwable exc) {
                    if (!bl) break block7;
                    OracleLog.log($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "Async AC statistics-removal task submission failed: {0}", exc);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getDataSourceName() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$4, this, new Object[0]);
            }
            String string = this.dsName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$4, this, string);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$4, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ ConcurrentHashMap access$000(StatisticsTracker statisticsTracker) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            StatisticsTracker x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$5, null, statisticsTracker);
            }
            ConcurrentHashMap<oracle.jdbc.replay.internal.ReplayStatistics, Integer> concurrentHashMap = x0.acStatistics;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$5, null, concurrentHashMap);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$5, null, null);
            }
            return concurrentHashMap;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ ReplayStatisticsImpl access$100(StatisticsTracker statisticsTracker) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            StatisticsTracker x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$6, null, statisticsTracker);
            }
            ReplayStatisticsImpl replayStatisticsImpl = x0.aggregateStats;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$6, null, replayStatisticsImpl);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$6, null, null);
            }
            return replayStatisticsImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, StatisticsTracker.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = StatisticsTracker.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = StatisticsTracker.class.getDeclaredMethod("access$100", StatisticsTracker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = StatisticsTracker.class.getDeclaredMethod("access$000", StatisticsTracker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = StatisticsTracker.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = StatisticsTracker.class.getDeclaredMethod("removeReplayStatistics", oracle.jdbc.replay.internal.ReplayStatistics.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = StatisticsTracker.class.getDeclaredMethod("updateReplayStatistics", String.class, oracle.jdbc.replay.internal.ReplayStatistics.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = StatisticsTracker.class.getDeclaredMethod("clearReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = StatisticsTracker.class.getDeclaredMethod("getReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

