/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import java.util.function.Consumer;

final class PolyglotThreadAccessException
extends Exception {
    static final long serialVersionUID = 1L;

    PolyglotThreadAccessException(String message) {
        super(message);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    void rethrow(PolyglotContextImpl context) {
        assert (!Thread.holdsLock(context)) : "Only rethrow without holding internal lock";
        Consumer<String> consumer = context.config.threadAccessDeniedHandler;
        if (consumer != null) {
            try {
                consumer.accept(this.getMessage());
            }
            catch (IllegalStateException e) {
                throw new PolyglotEngineException(e);
            }
            catch (Throwable another) {
                if (context.parent != null) {
                    throw another;
                }
                throw CompilerDirectives.shouldNotReachHere("Embedder context cannot have threadAccessDeniedHandler.");
            }
        } else {
            IllegalStateException ex = new IllegalStateException(this.getMessage());
            throw new PolyglotEngineException(ex);
        }
    }
}

