/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.RuleOption;

public abstract class AbstractFillerWordsRule
extends AbstractStatisticStyleRule {
    public static final String RULE_ID = "FILLER_WORDS";
    private static final int DEFAULT_MIN_PERCENT = 8;
    private static final boolean DEFAULT_ACTIVATION = false;
    private int minPercent = 8;

    protected abstract boolean isFillerWord(String var1);

    public AbstractFillerWordsRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean defaultActive) {
        super(messages, lang, userConfig, 8);
    }

    public AbstractFillerWordsRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        this(messages, lang, userConfig, false);
    }

    @Override
    public String getDescription() {
        return this.messages.getString("filler_words_rule_desc");
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption(this.minPercent, this.messages.getString("filler_words_rule_opt_text"), 0, 100)};
        return ruleOptions;
    }

    public String getMessage() {
        return this.messages.getString("filler_words_rule_msg");
    }

    protected boolean isException(AnalyzedTokenReadings[] tokens, int num) {
        return false;
    }

    @Override
    protected int conditionFulfilled(AnalyzedTokenReadings[] tokens, int nAnalysedToken) {
        if (this.isFillerWord(tokens[nAnalysedToken].getToken()) && !this.isException(tokens, nAnalysedToken)) {
            return nAnalysedToken;
        }
        return -1;
    }

    @Override
    protected boolean sentenceConditionFulfilled(AnalyzedTokenReadings[] tokens, int nAnalysedToken) {
        return false;
    }

    @Override
    protected boolean excludeDirectSpeech() {
        return true;
    }

    @Override
    protected String getLimitMessage(int limit, double percent) {
        return this.getMessage();
    }

    @Override
    protected String getSentenceMessage() {
        return null;
    }

    @Override
    public String getConfigurePercentText() {
        return null;
    }

    @Override
    public String getConfigureWithoutDirectSpeachText() {
        return null;
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

