/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MacPythonSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    private static final Logger LOGGER = Logger.getInstance(MacPythonSdkFlavor.class);

    private MacPythonSdkFlavor() {
    }

    public boolean isApplicable() {
        return SystemInfo.isMac;
    }

    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    protected @NotNull Collection<@NotNull Path> suggestLocalHomePathsImpl(@Nullable Module module2, @Nullable UserDataHolder context) {
        HashSet<Path> candidates = new HashSet<Path>();
        MacPythonSdkFlavor.collectPythonInstallations(Path.of("/Library/Frameworks/Python.framework/Versions", new String[0]), candidates);
        MacPythonSdkFlavor.collectPythonInstallations(Path.of("/System/Library/Frameworks/Python.framework/Versions", new String[0]), candidates);
        MacPythonSdkFlavor.collectPythonInstallations(Path.of("/usr/local/Cellar/python", new String[0]), candidates);
        UnixPythonSdkFlavor.collectUnixPythons(Path.of("/usr/local/bin", new String[0]), candidates);
        if (MacPythonSdkFlavor.areCommandLineDeveloperToolsAvailable()) {
            UnixPythonSdkFlavor.collectUnixPythons(Path.of("/usr/bin", new String[0]), candidates);
            UnixPythonSdkFlavor.collectPyenvPythons(candidates);
        }
        HashSet<Path> hashSet = candidates;
        if (hashSet == null) {
            MacPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static void collectPythonInstallations(@NotNull Path pythonHomePath, @NotNull Set<Path> candidates) {
        Path pythonBinaryPath;
        if (pythonHomePath == null) {
            MacPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        if (candidates == null) {
            MacPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (Files.isRegularFile(pythonBinaryPath = pythonHomePath.resolve(Path.of("bin", "python3")), new LinkOption[0])) {
            candidates.add(pythonBinaryPath);
        }
    }

    @NotNull
    public static GeneralCommandLine getXCodeSelectInstallCommand() {
        return new GeneralCommandLine(new String[]{"xcode-select", "--install"});
    }

    @NotNull
    private static GeneralCommandLine getXCodeSelectPathCommand() {
        return new GeneralCommandLine(new String[]{"xcode-select", "-p"});
    }

    public static boolean areCommandLineDeveloperToolsAvailable() {
        GeneralCommandLine commandLine = MacPythonSdkFlavor.getXCodeSelectPathCommand();
        try {
            ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Result of '" + commandLine.getCommandLineString() + "':\n" + String.valueOf(output2));
            }
            return output2.getExitCode() == 0;
        }
        catch (ExecutionException e) {
            LOGGER.warn("Exception during '" + commandLine.getCommandLineString() + "'", (Throwable)e);
            return true;
        }
    }

    @Nullable
    public static ValidationInfo checkDetectedPython(@NotNull PyDetectedSdk sdk2) {
        if (sdk2 == null) {
            MacPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (!"/usr/bin/python3".equals(sdk2.getHomePath())) {
            return null;
        }
        String progressTitle = PyBundle.message("python.cldt.checking", new Object[0]);
        if (((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(MacPythonSdkFlavor::areCommandLineDeveloperToolsAvailable, progressTitle, true, null)).booleanValue()) {
            return null;
        }
        HtmlChunk commandChunk = HtmlChunk.text((String)MacPythonSdkFlavor.getXCodeSelectInstallCommand().getCommandLineString());
        String message = new HtmlBuilder().append(HtmlChunk.raw((String)PyBundle.message("python.cldt.required", commandChunk.code()))).toString();
        return new ValidationInfo(message).asWarning().withOKEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/MacPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonHomePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePathsImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/MacPythonSdkFlavor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPythonInstallations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkDetectedPython";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

