/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

public class Version
implements Comparable<Version> {
    public static final Version _0_10_0 = Version.of("0.10.0");
    public static final Version CURRENT = Version.of("0.12.0-final");
    private static final char DASH = '-';
    private static final char PERIOD = '.';
    private final int majorMinorMicro;
    private final String qualifier;

    public static Version of(String version) {
        int start = 0;
        int end = version.indexOf(46, start);
        if (end >= 1) {
            byte major = Byte.valueOf(version.substring(start, end));
            start = end + 1;
            if ((end = version.indexOf(46, start)) >= 0 && end - start >= 1) {
                byte minor = Byte.valueOf(version.substring(start, end));
                start = end + 1;
                if ((end = version.indexOf(45, start)) >= 0) {
                    if (end - start >= 1) {
                        byte micro = Byte.valueOf(version.substring(start, end));
                        String qualifier = version.substring(end + 1);
                        return new Version(major, minor, micro, qualifier);
                    }
                } else {
                    byte micro = Byte.valueOf(version.substring(start));
                    return new Version(major, minor, micro, null);
                }
            }
        }
        throw new IllegalArgumentException("Cannot parse \"" + version + "\" into a version. A string matching major.minor.micro[-qualifier] expected.");
    }

    public Version(byte major, byte minor, byte micro, String qualifier) {
        this.majorMinorMicro = major << 24 | minor << 16 | micro << 8;
        this.qualifier = qualifier;
    }

    Version(int majorMinorMicro, String qualifier) {
        this.majorMinorMicro = majorMinorMicro;
        this.qualifier = qualifier;
    }

    @Override
    public int compareTo(Version other) {
        int mmmCompared = Integer.compare(this.majorMinorMicro, other.majorMinorMicro);
        switch (mmmCompared) {
            case 0: {
                return this.qualifier == other.qualifier ? 0 : (this.qualifier == null ? -1 : (other.qualifier == null ? 1 : this.qualifier.compareTo(other.qualifier)));
            }
        }
        return mmmCompared;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.majorMinorMicro != other.majorMinorMicro) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }

    byte getMajor() {
        return (byte)(this.majorMinorMicro >> 24);
    }

    byte getMicro() {
        return (byte)(this.majorMinorMicro >> 8);
    }

    byte getMinor() {
        return (byte)(this.majorMinorMicro >> 16);
    }

    String getQualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        return 31 * (31 + this.majorMinorMicro) + (this.qualifier == null ? 0 : this.qualifier.hashCode());
    }

    public String toString() {
        return "" + this.getMajor() + "." + this.getMinor() + "." + this.getMicro() + (this.qualifier == null ? "" : "-" + this.qualifier);
    }
}

