# Serialise package

This package provides support for serialising and deserialising arbitrary data
structures.

The API is designed to require capability tokens, as otherwise serialising
would leak the bit patterns of all private information in a type if the
resulting Array[U8] could be examined.

Deserialisation is fundamentally unsafe currently: there isn't yet a
verification pass to check that the resulting object graph maintains a
well-formed heap or that individual objects maintain any expected local
invariants. However, if only "trusted" data (i.e. data produced by Pony
serialisation from the same binary) is deserialised, it will always maintain a
well-formed heap and all object invariants.

Note that serialised data can be used between binaries compiled with the same
version of the pony compiler. Cross binary serialisation will only work for
binaries of the same bit width (32 bit vs 64 bit), data model (ilp32, lp64, or
llp64), and endianness (big endian or little endian) but is not limited to a
single platform (for example: one can mix and match x86_64 linux and aarch64
linux because they have the same bitwidth, data model, and endianness).

The [Serialise.signature](serialise-Serialise.md#signature) method is provided
for the purposes of comparing communicating Pony binaries to determine if they
are compatible. Confirming this before deserialising data can help mitigate the
risk of accidental serialisation across incompatible Pony binaries, but does not
on its own address the security issues of accepting data from untrusted sources.


## Public Types

* [primitive DeserialiseAuth](serialise-DeserialiseAuth.md)
* [primitive InputSerialisedAuth](serialise-InputSerialisedAuth.md)
* [primitive OutputSerialisedAuth](serialise-OutputSerialisedAuth.md)
* [primitive Serialise](serialise-Serialise.md)
* [primitive SerialiseAuth](serialise-SerialiseAuth.md)
* [class Serialised](serialise-Serialised.md)
