/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.DefaultOctetPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.OctetJwkFactory;
import io.jsonwebtoken.impl.security.OctetPublicJwkFactory;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.OctetPrivateJwk;
import io.jsonwebtoken.security.OctetPublicJwk;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;

public class OctetPrivateJwkFactory
extends OctetJwkFactory<PrivateKey, OctetPrivateJwk<PrivateKey, PublicKey>> {
    public OctetPrivateJwkFactory() {
        super(PrivateKey.class, DefaultOctetPrivateJwk.PARAMS);
    }

    @Override
    protected boolean supportsKeyValues(JwkContext<?> ctx) {
        return super.supportsKeyValues(ctx) && ctx.containsKey(DefaultOctetPrivateJwk.D.getId());
    }

    @Override
    protected OctetPrivateJwk<PrivateKey, PublicKey> createJwkFromKey(JwkContext<PrivateKey> ctx) {
        PrivateKey key = (PrivateKey)Assert.notNull((Object)ctx.getKey(), (String)"PrivateKey cannot be null.");
        EdwardsCurve crv = EdwardsCurve.forKey(key);
        PublicKey pub = ctx.getPublicKey();
        if (pub != null) {
            if (!crv.equals(EdwardsCurve.forKey(pub))) {
                String msg = "Specified Edwards Curve PublicKey does not match the specified PrivateKey's curve.";
                throw new InvalidKeyException(msg);
            }
        } else {
            pub = EdwardsCurve.derivePublic(key);
        }
        boolean copyId = !Strings.hasText((String)ctx.getId()) && ctx.getIdThumbprintAlgorithm() != null;
        JwkContext pubCtx = OctetPublicJwkFactory.INSTANCE.newContext((JwkContext)ctx, pub);
        OctetPublicJwk pubJwk = (OctetPublicJwk)OctetPublicJwkFactory.INSTANCE.createJwk(pubCtx);
        ctx.putAll((Map)pubJwk);
        if (copyId) {
            ctx.setId(pubJwk.getId());
        }
        byte[] d = crv.getKeyMaterial(key);
        Assert.notEmpty((byte[])d, (String)"Edwards PrivateKey 'd' value cannot be null or empty.");
        OctetPrivateJwkFactory.put(ctx, DefaultOctetPrivateJwk.D, d);
        return new DefaultOctetPrivateJwk<PrivateKey, PublicKey>(ctx, pubJwk);
    }

    @Override
    protected OctetPrivateJwk<PrivateKey, PublicKey> createJwkFromValues(JwkContext<PrivateKey> ctx) {
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        EdwardsCurve curve = OctetPrivateJwkFactory.getCurve(reader);
        DefaultJwkContext<PublicKey> pubCtx = new DefaultJwkContext<PublicKey>(DefaultOctetPublicJwk.PARAMS, ctx);
        OctetPublicJwk<PublicKey> pubJwk = OctetPublicJwkFactory.INSTANCE.createJwkFromValues((JwkContext<PublicKey>)pubCtx);
        byte[] d = reader.get(DefaultOctetPrivateJwk.D);
        PrivateKey key = curve.toPrivateKey(d, ctx.getProvider());
        ctx.setKey(key);
        return new DefaultOctetPrivateJwk<PrivateKey, PublicKey>(ctx, pubJwk);
    }
}

