/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.BaseNode;
import org.opensearch.client.opensearch.tasks.TaskInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TaskExecutingNode
extends BaseNode
implements ToCopyableBuilder<Builder, TaskExecutingNode> {
    @Nonnull
    private final Map<String, TaskInfo> tasks;
    public static final JsonpDeserializer<TaskExecutingNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskExecutingNode::setupTaskExecutingNodeDeserializer);

    private TaskExecutingNode(Builder builder) {
        super(builder);
        this.tasks = ApiTypeHelper.unmodifiableRequired(builder.tasks, (Object)this, "tasks");
    }

    public static TaskExecutingNode of(Function<Builder, ObjectBuilder<TaskExecutingNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, TaskInfo> tasks() {
        return this.tasks;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("tasks");
        generator.writeStartObject();
        for (Map.Entry<String, TaskInfo> item0 : this.tasks.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTaskExecutingNodeDeserializer(ObjectDeserializer<Builder> op) {
        TaskExecutingNode.setupBaseNodeDeserializer(op);
        op.add(Builder::tasks, JsonpDeserializer.stringMapDeserializer(TaskInfo._DESERIALIZER), "tasks");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tasks.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskExecutingNode other = (TaskExecutingNode)o;
        return this.tasks.equals(other.tasks);
    }

    public static class Builder
    extends BaseNode.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TaskExecutingNode> {
        private Map<String, TaskInfo> tasks;

        public Builder() {
        }

        private Builder(TaskExecutingNode o) {
            super(o);
            this.tasks = Builder._mapCopy(o.tasks);
        }

        private Builder(Builder o) {
            super(o);
            this.tasks = Builder._mapCopy(o.tasks);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder tasks(Map<String, TaskInfo> map) {
            this.tasks = Builder._mapPutAll(this.tasks, map);
            return this;
        }

        @Nonnull
        public final Builder tasks(String key, TaskInfo value) {
            this.tasks = Builder._mapPut(this.tasks, key, value);
            return this;
        }

        @Nonnull
        public final Builder tasks(String key, Function<TaskInfo.Builder, ObjectBuilder<TaskInfo>> fn) {
            return this.tasks(key, fn.apply(new TaskInfo.Builder()).build());
        }

        @Override
        @Nonnull
        public TaskExecutingNode build() {
            this._checkSingleUse();
            return new TaskExecutingNode(this);
        }
    }
}

