/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.Dataset;
import org.tribuo.Model;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.Trainer;
import org.tribuo.dataset.MinimumCardinalityDataset;
import org.tribuo.evaluation.Evaluation;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.provenance.TrainerProvenance;
import org.tribuo.transform.TransformTrainer;
import org.tribuo.transform.TransformationMap;
import org.tribuo.util.Util;

public final class CompletelyConfigurableTrainTest {
    private static final Logger logger = Logger.getLogger(CompletelyConfigurableTrainTest.class.getName());

    private CompletelyConfigurableTrainTest() {
    }

    public static <T extends Output<T>> void main(String[] args) {
        ConfigurationManager cm;
        LabsLogFormatter.setAllLogFormatters();
        ConfigurableTrainTestOptions o = new ConfigurableTrainTestOptions();
        try {
            cm = new ConfigurationManager(args, (Options)o);
        }
        catch (UsageException e) {
            logger.info(e.getMessage());
            return;
        }
        if (o.trainSource == null || o.testSource == null) {
            logger.info(cm.usage());
            System.exit(1);
        } else if (o.trainer == null) {
            logger.warning("No trainer supplied");
            logger.info(cm.usage());
            System.exit(1);
        }
        MutableDataset train = new MutableDataset(o.trainSource);
        if (o.minCount > 0) {
            logger.info("Removing features which occur fewer than " + o.minCount + " times.");
            train = new MinimumCardinalityDataset((Dataset)train, o.minCount);
        }
        MutableDataset test = new MutableDataset(o.testSource);
        if (o.transformationMap != null) {
            o.trainer = new TransformTrainer(o.trainer, o.transformationMap);
        }
        logger.info("Trainer is " + ((TrainerProvenance)o.trainer.getProvenance()).toString());
        logger.info("Outputs are " + train.getOutputInfo().toReadableString());
        logger.info("Number of features: " + train.getFeatureMap().size());
        long trainStart = System.currentTimeMillis();
        Model model = o.trainer.train((Dataset)train);
        long trainStop = System.currentTimeMillis();
        logger.info("Finished training classifier " + Util.formatDuration((long)trainStart, (long)trainStop));
        Evaluator evaluator = train.getOutputFactory().getEvaluator();
        long testStart = System.currentTimeMillis();
        Evaluation evaluation = evaluator.evaluate(model, (Dataset)test);
        long testStop = System.currentTimeMillis();
        logger.info("Finished evaluating model " + Util.formatDuration((long)testStart, (long)testStop));
        System.out.println(evaluation.toString());
        if (o.outputPath != null) {
            try (ObjectOutputStream oout = new ObjectOutputStream(new FileOutputStream(o.outputPath.toFile()));){
                oout.writeObject(model);
                logger.info("Serialized model to file: " + o.outputPath);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error writing model", e);
            }
        }
    }

    public static class ConfigurableTrainTestOptions
    implements Options {
        @Option(charName=102, longName="model-output-path", usage="Path to serialize model to.")
        public Path outputPath;
        @Option(charName=117, longName="train-source", usage="Load the training DataSource from the config file.")
        public ConfigurableDataSource<?> trainSource;
        @Option(charName=118, longName="test-source", usage="Load the testing DataSource from the config file.")
        public ConfigurableDataSource<?> testSource;
        @Option(charName=116, longName="trainer", usage="Load a trainer from the config file.")
        public Trainer<?> trainer;
        @Option(longName="transformer", usage="Load a transformation map from the config file.")
        public TransformationMap transformationMap;
        @Option(charName=109, longName="minimum-count", usage="Remove features which occur fewer than <int> times.")
        public int minCount = -1;

        public String getOptionsDescription() {
            return "Loads a Trainer and two DataSources from a config file, trains a Model, tests it and optionally saves it to disk.";
        }
    }
}

