/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.inference.streaming;

import ai.djl.ndarray.NDList;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.stream.Stream;

public interface StreamingTranslator<I, O>
extends Translator<I, O> {
    public StreamOutput<O> processStreamOutput(TranslatorContext var1, Stream<NDList> var2) throws Exception;

    public Support getSupport();

    default public boolean supportsIterative() {
        return this.getSupport().iterative();
    }

    default public boolean supportsAsync() {
        return this.getSupport().async();
    }

    public static enum Support {
        ITERATIVE(true, false),
        ASYNC(false, true),
        BOTH(true, true);

        private boolean iterative;
        private boolean async;

        private Support(boolean iterative, boolean async) {
            this.iterative = iterative;
            this.async = async;
        }

        public boolean iterative() {
            return this.iterative;
        }

        public boolean async() {
            return this.async;
        }
    }

    public static abstract class StreamOutput<O> {
        private O output;
        private boolean computed;

        public final O getAsyncOutput() {
            if (this.output != null) {
                throw new IllegalStateException("The StreamOutput can only be gotten once");
            }
            if (this.computed) {
                throw new IllegalStateException("Attempted to getAsyncOutput, but has already called getIterativeOutput. Only one kind of output can be used.");
            }
            this.output = this.buildAsyncOutput();
            return this.output;
        }

        protected abstract O buildAsyncOutput();

        public final void computeAsyncOutput() {
            if (this.output == null) {
                throw new IllegalStateException("Before calling computeAsyncOutput, you must first getAsyncOutput");
            }
            if (this.computed) {
                throw new IllegalStateException("Attempted to computeAsyncOutput multiple times.");
            }
            this.computed = true;
            this.computeAsyncOutputInternal(this.output);
        }

        protected abstract void computeAsyncOutputInternal(O var1);

        public final O getIterativeOutput() {
            if (this.output != null) {
                throw new IllegalStateException("Can't call getIterativeOutput after already using getAsyncOutput.");
            }
            if (this.computed) {
                throw new IllegalStateException("Attempted to getIterativeOutput multiple times. getIterativeOutput can only be called once");
            }
            return this.getIterativeOutputInternal();
        }

        public abstract O getIterativeOutputInternal();
    }
}

