/*
 * Decompiled with CFR 0.152.
 */
package ai.djl;

import java.util.Objects;

public class Application {
    public static final Application UNDEFINED = new Application("undefined");
    private String path;

    Application(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public static Application of(String path) {
        switch (path) {
            case "cv": {
                return CV.ANY;
            }
            case "cv/image_classification": 
            case "image_classification": {
                return CV.IMAGE_CLASSIFICATION;
            }
            case "cv/object_detection": 
            case "object_detection": {
                return CV.OBJECT_DETECTION;
            }
            case "cv/semantic_segmentation": 
            case "semantic_segmentation": {
                return CV.SEMANTIC_SEGMENTATION;
            }
            case "cv/instance_segmentation": 
            case "instance_segmentation": {
                return CV.INSTANCE_SEGMENTATION;
            }
            case "cv/mask_generation": 
            case "mask_generation": {
                return CV.MASK_GENERATION;
            }
            case "cv/pose_estimation": 
            case "pose_estimation": {
                return CV.POSE_ESTIMATION;
            }
            case "cv/action_recognition": 
            case "action_recognition": {
                return CV.ACTION_RECOGNITION;
            }
            case "cv/word_recognition": 
            case "word_recognition": {
                return CV.WORD_RECOGNITION;
            }
            case "cv/image_generation": 
            case "image_generation": {
                return CV.IMAGE_GENERATION;
            }
            case "cv/image_enhancement": 
            case "image_enhancement": {
                return CV.IMAGE_ENHANCEMENT;
            }
            case "nlp": {
                return NLP.ANY;
            }
            case "nlp/fill_mask": 
            case "fill_mask": {
                return NLP.FILL_MASK;
            }
            case "nlp/question_answer": 
            case "question_answering": {
                return NLP.QUESTION_ANSWER;
            }
            case "nlp/text_classification": 
            case "text_classification": {
                return NLP.TEXT_CLASSIFICATION;
            }
            case "nlp/sentiment_analysis": 
            case "sentiment_analysis": {
                return NLP.SENTIMENT_ANALYSIS;
            }
            case "nlp/token_classification": 
            case "token_classification": {
                return NLP.TOKEN_CLASSIFICATION;
            }
            case "nlp/word_embedding": 
            case "word_embedding": {
                return NLP.WORD_EMBEDDING;
            }
            case "nlp/text_generation": 
            case "text_generation": {
                return NLP.TEXT_GENERATION;
            }
            case "nlp/machine_translation": 
            case "machine_translation": {
                return NLP.MACHINE_TRANSLATION;
            }
            case "nlp/multiple_choice": 
            case "multiple_choice": {
                return NLP.MULTIPLE_CHOICE;
            }
            case "nlp/text_embedding": 
            case "text_embedding": 
            case "sentence_similarity": {
                return NLP.TEXT_EMBEDDING;
            }
            case "tabular": {
                return Tabular.ANY;
            }
            case "tabular/linear_regression": {
                return Tabular.LINEAR_REGRESSION;
            }
            case "tabular/softmax_regression": {
                return Tabular.SOFTMAX_REGRESSION;
            }
            case "audio": {
                return Audio.ANY;
            }
            case "timeseries/forecasting": {
                return TimeSeries.FORECASTING;
            }
        }
        return UNDEFINED;
    }

    public String toString() {
        return this.path.replace('/', '.').toUpperCase();
    }

    public boolean matches(Application test) {
        return this.path.startsWith(test.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        return this.path.equals(((Application)o).path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public static interface CV {
        public static final Application ANY = new Application("cv");
        public static final Application IMAGE_CLASSIFICATION = new Application("cv/image_classification");
        public static final Application OBJECT_DETECTION = new Application("cv/object_detection");
        public static final Application SEMANTIC_SEGMENTATION = new Application("cv/semantic_segmentation");
        public static final Application INSTANCE_SEGMENTATION = new Application("cv/instance_segmentation");
        public static final Application MASK_GENERATION = new Application("cv/mask_generation");
        public static final Application POSE_ESTIMATION = new Application("cv/pose_estimation");
        public static final Application ACTION_RECOGNITION = new Application("cv/action_recognition");
        public static final Application WORD_RECOGNITION = new Application("cv/word_recognition");
        public static final Application IMAGE_GENERATION = new Application("cv/image_generation");
        public static final Application IMAGE_ENHANCEMENT = new Application("cv/image_enhancement");
    }

    public static interface NLP {
        public static final Application ANY = new Application("nlp");
        public static final Application FILL_MASK = new Application("nlp/fill_mask");
        public static final Application QUESTION_ANSWER = new Application("nlp/question_answer");
        public static final Application TEXT_CLASSIFICATION = new Application("nlp/text_classification");
        public static final Application SENTIMENT_ANALYSIS = new Application("nlp/sentiment_analysis");
        public static final Application TOKEN_CLASSIFICATION = new Application("nlp/token_classification");
        public static final Application WORD_EMBEDDING = new Application("nlp/word_embedding");
        public static final Application TEXT_GENERATION = new Application("nlp/text_generation");
        public static final Application MACHINE_TRANSLATION = new Application("nlp/machine_translation");
        public static final Application MULTIPLE_CHOICE = new Application("nlp/multiple_choice");
        public static final Application TEXT_EMBEDDING = new Application("nlp/text_embedding");
    }

    public static interface Tabular {
        public static final Application ANY = new Application("tabular");
        public static final Application LINEAR_REGRESSION = new Application("tabular/linear_regression");
        public static final Application SOFTMAX_REGRESSION = new Application("tabular/softmax_regression");
    }

    public static interface Audio {
        public static final Application ANY = new Application("audio");
    }

    public static interface TimeSeries {
        public static final Application FORECASTING = new Application("timeseries/forecasting");
    }
}

