/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.indexstatemanagement.settings.LegacyOpenDistroManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ValidationResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002Bw\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\f\u0012\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0012\u0010\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018\u00a8\u0006*"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainResponse;", "Lorg/opensearch/core/action/ActionResponse;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "indexNames", "", "", "indexPolicyIDs", "indexMetadatas", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "totalManagedIndices", "", "enabledState", "", "", "policies", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "validationResults", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ValidationResult;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ILjava/util/Map;Ljava/util/Map;Ljava/util/List;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getIndexNames", "()Ljava/util/List;", "getIndexPolicyIDs", "getIndexMetadatas", "getTotalManagedIndices", "()I", "getEnabledState", "()Ljava/util/Map;", "getPolicies", "getValidationResults", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nExplainResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplainResponse.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainResponse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1878#2,2:104\n1880#2:107\n1#3:106\n*S KotlinDebug\n*F\n+ 1 ExplainResponse.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainResponse\n*L\n87#1:104,2\n87#1:107\n*E\n"})
public class ExplainResponse
extends ActionResponse
implements ToXContentObject {
    @NotNull
    private final List<String> indexNames;
    @NotNull
    private final List<String> indexPolicyIDs;
    @NotNull
    private final List<ManagedIndexMetaData> indexMetadatas;
    private final int totalManagedIndices;
    @NotNull
    private final Map<String, Boolean> enabledState;
    @NotNull
    private final Map<String, Policy> policies;
    @NotNull
    private final List<ValidationResult> validationResults;

    @NotNull
    public final List<String> getIndexNames() {
        return this.indexNames;
    }

    @NotNull
    public final List<String> getIndexPolicyIDs() {
        return this.indexPolicyIDs;
    }

    @NotNull
    public final List<ManagedIndexMetaData> getIndexMetadatas() {
        return this.indexMetadatas;
    }

    public final int getTotalManagedIndices() {
        return this.totalManagedIndices;
    }

    @NotNull
    public final Map<String, Boolean> getEnabledState() {
        return this.enabledState;
    }

    @NotNull
    public final Map<String, Policy> getPolicies() {
        return this.policies;
    }

    @NotNull
    public final List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }

    public ExplainResponse(@NotNull List<String> indexNames, @NotNull List<String> indexPolicyIDs, @NotNull List<ManagedIndexMetaData> indexMetadatas, int totalManagedIndices, @NotNull Map<String, Boolean> enabledState, @NotNull Map<String, Policy> policies2, @NotNull List<ValidationResult> validationResults) {
        Intrinsics.checkNotNullParameter(indexNames, (String)"indexNames");
        Intrinsics.checkNotNullParameter(indexPolicyIDs, (String)"indexPolicyIDs");
        Intrinsics.checkNotNullParameter(indexMetadatas, (String)"indexMetadatas");
        Intrinsics.checkNotNullParameter(enabledState, (String)"enabledState");
        Intrinsics.checkNotNullParameter(policies2, (String)"policies");
        Intrinsics.checkNotNullParameter(validationResults, (String)"validationResults");
        this.indexNames = indexNames;
        this.indexPolicyIDs = indexPolicyIDs;
        this.indexMetadatas = indexMetadatas;
        this.totalManagedIndices = totalManagedIndices;
        this.enabledState = enabledState;
        this.policies = policies2;
        this.validationResults = validationResults;
    }

    public ExplainResponse(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        List list2 = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"readStringList(...)");
        List list3 = sin.readList(ExplainResponse::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"readList(...)");
        int n = sin.readInt();
        Map map = sin.readMap(StreamInput::readString, StreamInput::readBoolean);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"readMap(...)");
        Map map2 = sin.readMap(StreamInput::readString, Policy::new);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"readMap(...)");
        List list4 = sin.readList(ExplainResponse::_init_$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"readList(...)");
        this(list, list2, list3, n, map, map2, list4);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeStringCollection((Collection)this.indexNames);
        out.writeStringCollection((Collection)this.indexPolicyIDs);
        out.writeCollection((Collection)this.indexMetadatas);
        out.writeInt(this.totalManagedIndices);
        out.writeMap(this.enabledState, ExplainResponse::writeTo$lambda$2, ExplainResponse::writeTo$lambda$3);
        out.writeMap(this.policies, ExplainResponse::writeTo$lambda$4, ExplainResponse::writeTo$lambda$5);
        out.writeCollection((Collection)this.validationResults);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        Iterable $this$forEachIndexed$iv = this.indexNames;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void name;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int ind = n;
            boolean bl = false;
            builder.startObject((String)name);
            builder.field(ManagedIndexSettings.Companion.getPOLICY_ID().getKey(), this.indexPolicyIDs.get(ind));
            builder.field(LegacyOpenDistroManagedIndexSettings.Companion.getPOLICY_ID().getKey(), this.indexPolicyIDs.get(ind));
            ManagedIndexMetaData managedIndexMetaData = this.indexMetadatas.get(ind);
            if (managedIndexMetaData != null) {
                ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
                managedIndexMetaData.toXContent(builder, params2);
            }
            builder.field("enabled", this.enabledState.get(name));
            if (this.policies.get(name) != null) {
                Policy it;
                boolean bl2 = false;
                builder.field("policy", (ToXContent)it, (ToXContent.Params)RestHandlerUtilsKt.getXCONTENT_WITHOUT_TYPE_AND_USER());
            }
            if (this.validationResults.get(ind) != null) {
                OpenSearchExtensionsKt.addObject(builder, "validate", (ToXContentFragment)this.validationResults.get(ind), params, true);
            }
            builder.endObject();
        }
        builder.field("total_managed_indices", this.totalManagedIndices);
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    private static final ManagedIndexMetaData _init_$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return ManagedIndexMetaData.Companion.fromStreamInput(it);
    }

    private static final ValidationResult _init_$lambda$1(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return ValidationResult.Companion.fromStreamInput(it);
    }

    private static final void writeTo$lambda$2(StreamOutput _out, String key) {
        _out.writeString(key);
    }

    private static final void writeTo$lambda$3(StreamOutput _out, Boolean enable2) {
        Intrinsics.checkNotNull((Object)enable2);
        _out.writeBoolean(enable2.booleanValue());
    }

    private static final void writeTo$lambda$4(StreamOutput _out, String key) {
        _out.writeString(key);
    }

    private static final void writeTo$lambda$5(StreamOutput _out, Policy policy2) {
        Intrinsics.checkNotNull((Object)_out);
        policy2.writeTo(_out);
    }
}

