/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.sort;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class ShardDocFieldComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    public static final String NAME = "_shard_doc";
    private final long shardKeyPrefix;

    public ShardDocFieldComparatorSource(int shardId) {
        super(null, MultiValueMode.MIN, null);
        this.shardKeyPrefix = (long)shardId << 32;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new UnsupportedOperationException("bucketed sort not supported for _shard_doc");
    }

    public FieldComparator<Long> newComparator(String fieldname, final int numHits, Pruning pruning, boolean reversed) {
        return new FieldComparator<Long>(){
            private final long[] values;
            private long bottom;
            private long topValue;
            {
                this.values = new long[numHits];
            }

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) {
                final int docBase = context.docBase;
                return new LeafFieldComparator(){
                    Scorable scorer;

                    public void setScorer(Scorable scorer) {
                        this.scorer = scorer;
                    }

                    public void setBottom(int slot) {
                        bottom = values[slot];
                    }

                    public int compareBottom(int doc) {
                        return Long.compare(bottom, this.computeGlobalDocKey(doc));
                    }

                    public void copy(int slot, int doc) {
                        values[slot] = this.computeGlobalDocKey(doc);
                    }

                    public int compareTop(int doc) {
                        return Long.compare(topValue, this.computeGlobalDocKey(doc));
                    }

                    private long computeGlobalDocKey(int doc) {
                        return ShardDocFieldComparatorSource.this.shardKeyPrefix | (long)(docBase + doc);
                    }
                };
            }

            public int compare(int slot1, int slot2) {
                return Long.compare(this.values[slot1], this.values[slot2]);
            }

            public Long value(int slot) {
                return this.values[slot];
            }

            public void setTopValue(Long value) {
                this.topValue = value;
            }
        };
    }
}

