/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.collection.spi.LazyInitializable;
import org.hibernate.engine.spi.InstanceIdentity;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

@Incubating
public interface PersistentCollection<E>
extends LazyInitializable,
InstanceIdentity {
    public @Nullable Object getOwner();

    public void setOwner(Object var1);

    public boolean empty();

    public void setSnapshot(@Nullable Object var1, @Nullable String var2, @Nullable Serializable var3);

    public void postAction();

    public Object getValue();

    public boolean isDirectlyAccessible();

    public boolean unsetSession(SharedSessionContractImplementor var1);

    public boolean setCurrentSession(SharedSessionContractImplementor var1) throws HibernateException;

    public Iterator<?> entries(CollectionPersister var1);

    public Object getIdentifier(Object var1, int var2);

    public Object getIndex(Object var1, int var2, CollectionPersister var3);

    public Object getElement(Object var1);

    public Object getSnapshotElement(Object var1, int var2);

    public boolean equalsSnapshot(CollectionPersister var1);

    public boolean isSnapshotEmpty(Serializable var1);

    public boolean needsRecreate(CollectionPersister var1);

    public Serializable getSnapshot(CollectionPersister var1);

    public boolean entryExists(Object var1, int var2);

    default public boolean includeInRecreate(Object entry, int i, PersistentCollection<?> collection, PluralAttributeMapping attributeDescriptor) {
        if (!1.$assertionsDisabled && collection != this) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && attributeDescriptor == null) {
            throw new AssertionError();
        }
        return this.entryExists(entry, i);
    }

    public boolean needsInserting(Object var1, int var2, Type var3);

    default public boolean includeInInsert(Object entry, int entryPosition, PersistentCollection<?> collection, PluralAttributeMapping attributeDescriptor) {
        if (!1.$assertionsDisabled && collection != this) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && attributeDescriptor == null) {
            throw new AssertionError();
        }
        return this.needsInserting(entry, entryPosition, attributeDescriptor.getCollectionDescriptor().getElementType());
    }

    default public boolean needsUpdating(Object entry, int entryPosition, PluralAttributeMapping attributeDescriptor) {
        if (!1.$assertionsDisabled && attributeDescriptor == null) {
            throw new AssertionError();
        }
        return this.needsUpdating(entry, entryPosition, attributeDescriptor.getCollectionDescriptor().getElementType());
    }

    public boolean needsUpdating(Object var1, int var2, Type var3);

    public boolean isRowUpdatePossible();

    public Iterator<?> getDeletes(CollectionPersister var1, boolean var2);

    public boolean hasDeletes(CollectionPersister var1);

    public boolean isWrapper(Object var1);

    public boolean isInitializing();

    public void beforeInitialize(CollectionPersister var1, int var2);

    public void initializeFromCache(CollectionPersister var1, Object var2, Object var3);

    public void beginRead();

    public void injectLoadedState(PluralAttributeMapping var1, List<?> var2);

    public boolean endRead();

    public boolean afterInitialize();

    public Object disassemble(CollectionPersister var1);

    public boolean hasQueuedOperations();

    public Iterator<?> queuedAdditionIterator();

    public Collection<E> getQueuedOrphans(String var1);

    public @Nullable Object getKey();

    public @Nullable String getRole();

    public boolean isUnreferenced();

    public boolean isDirty();

    default public boolean isElementRemoved() {
        return false;
    }

    default public boolean isDirectlyProvidedCollection(Object collection) {
        return this.isDirectlyAccessible() && this.isWrapper(collection);
    }

    public void clearDirty();

    public @Nullable Serializable getStoredSnapshot();

    public void dirty();

    public void preInsert(CollectionPersister var1);

    public void afterRowInsert(CollectionPersister var1, Object var2, int var3);

    public Collection<E> getOrphans(Serializable var1, String var2);

    public int getSize();

    public boolean elementExists(Object var1);

    public Object elementByIndex(Object var1);

    public void initializeEmptyCollection(CollectionPersister var1);

    @Internal
    public SharedSessionContractImplementor getSession();

    default public boolean isNewlyInstantiated() {
        return this.getKey() == null && !this.isDirty();
    }

    default public String render() {
        return this.getRole() + "#" + String.valueOf(this.getKey()) + "(initialized: " + this.wasInitialized() + ")";
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

