# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module Report
      module GroupIssues
        class IssueBase
          def initialize(client, options = {})
            @client = client
            @options = options
            @gitlab_url = ENV.fetch('CI_SERVER_URL', 'https://gitlab.com')
            @project_id = options[:target_project] || ENV['RESULTS_ISSUE_PROJECT'] || ENV.fetch('CI_PROJECT_ID', nil)
            @token = options[:token]
          end

          private

          def handle_gitlab_api_error(operation, context = nil)
            yield
          rescue Gitlab::Error::Error => e
            log_gitlab_error(operation, context, e)
            nil
          rescue StandardError => e
            log_standard_error(operation, context, e)
            nil
          end

          def log_gitlab_error(operation, context, error)
            context_info = context ? " #{context}" : ""
            Runtime::Logger.error "GitLab API error #{operation}#{context_info}: #{error.message}"
          end

          def log_standard_error(operation, context, error)
            context_info = context ? " #{context}" : ""
            Runtime::Logger.error "Error #{operation}#{context_info}: #{error.message}"
          end

          def display_description_preview(description, title = "Description preview:")
            Runtime::Logger.info title
            lines = description.split("\n")
            Runtime::Logger.info lines.first(15).join("\n")
            Runtime::Logger.info "..." if lines.length > 15
          end
        end
      end
    end
  end
end
