---
stage: Software Supply Chain Security
group: Authorization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ゲストユーザー
description: エントリレベルのユーザーロールとして、制限されたpermissionsで基本アクセスを割り当てます。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ゲストロールを持つユーザーは、他のユーザーロールと比較して、アクセスと機能が制限されています。それらの[権限](../user/permissions.md)は制限されており、機密性の高いプロジェクトデータを損なうことなく、基本的な表示レベルとインタラクションのみを提供するように設計されています。

ゲストロールを持つユーザー:

- パブリックグループとプロジェクトにアクセスできます。
- プロジェクト計画、ブロッカー、および進捗状況インジケーターを表示できます。
- 新しいプロジェクトの作業アイテムを作成してリンクできます。
- 次のような高度なプロジェクト情報を表示できます:
  - 分析
  - インシデントレポート
  - イシューとエピック
  - ライセンス
- 個人ネームスペースにプロジェクト、グループ、およびスニペットを作成できません。
- 作成していない既存のデータを変更できません。
- プロジェクトでコードを表示できません。

## シートの使用状況 {#seat-usage}

- GitLab FreeおよびPremiumでは、ゲストロールを持つユーザーは請求対象ユーザーとしてカウントされ、ライセンスシートを消費します。
- GitLab Ultimateでは、ゲストロールを持つユーザーは請求対象ユーザーとしてカウントされず、ライセンスシートを消費しません。

{{< alert type="note" >}}

ゲストロールは一般的にアクセスが制限されていますが、[カスタムロール](../user/custom_roles/_index.md)を[`View repository code`の](../user/custom_roles/abilities.md#source-code-management)アクセス許可で作成すると、ライセンスシートを消費せずにリポジトリ内のコードへのアクセスを提供できます。他のアクセス許可を追加すると、ロールは請求対象シートを占有します。

{{< /alert >}}

## ユーザーへのゲストロールの割り当て {#assign-guest-role-to-users}

前提要件: 

- メンテナーロール以上が必要です。

ゲストロールは、グループまたはプロジェクトの現在のメンバーに割り当てるか、新しいメンバーを作成するときにこのロールを割り当てることができます。これは、[API経由](../api/members.md#add-a-member-to-a-group-or-project)またはGitLabユーザーインターフェースから実行できます。

ゲストロールを現在のグループまたはプロジェクトメンバーに割り当てるには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループまたはプロジェクトを見つけます。
1. **管理** > **メンバー**を選択します。
1. ゲストロールを割り当てるグループまたはプロジェクトメンバーの**ロール**列で、現在のロール（たとえば、**デベロッパー**）を選択します。
1. **ロールの詳細**ドロワーで、**ゲスト**をゲストに変更します。
1. **ロールを更新する**を選択します。

ゲストロールを割り当てるユーザーが、グループまたはプロジェクトのメンバーでない場合:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループまたはプロジェクトを見つけます。
1. **管理** > **メンバー**を選択します。
1. **メンバーを招待**を選択します。
1. **ユーザー名、名前またはメールアドレス**で、関連するユーザーを選択します。
1. **ロールを選択**で、**ゲスト**を選択します。
1. オプション。**アクセス有効期限**に日付を入力します。
1. **招待**を選択します。
