/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge;

import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsMergeStrategiesController;
import org.gephi.datalab.plugin.manipulators.columns.merge.ui.GeneralColumnTitleChooserUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.columns.merge.AttributeColumnsMergeStrategy;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MinimumNumber
implements AttributeColumnsMergeStrategy {
    private Table table;
    private Column[] columns;
    private String columnTitle;

    public void setup(Table table, Column[] columns) {
        this.table = table;
        this.columns = columns;
    }

    public void execute() {
        ((AttributeColumnsMergeStrategiesController)Lookup.getDefault().lookup(AttributeColumnsMergeStrategiesController.class)).minValueNumbersMerge(this.table, this.columns, this.columnTitle);
    }

    public String getName() {
        return NbBundle.getMessage(MinimumNumber.class, (String)"MinimumNumber.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(MinimumNumber.class, (String)"MinimumNumber.description");
    }

    public boolean canExecute() {
        for (Column column : this.columns) {
            if (AttributeUtils.isNumberType((Class)column.getTypeClass())) continue;
            return false;
        }
        return true;
    }

    public ManipulatorUI getUI() {
        return new GeneralColumnTitleChooserUI();
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 600;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/minus-white.png", (boolean)false);
    }

    public Table getTable() {
        return this.table;
    }

    public String getColumnTitle() {
        return this.columnTitle;
    }

    public void setColumnTitle(String columnTitle) {
        this.columnTitle = columnTitle;
    }
}

