/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;
import org.jkiss.utils.CommonUtils;

public class MySQLSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private Button requireSSQL;
    private Button veryServerCert;
    private Button allowPublicKeyRetrieval;
    private Text cipherSuitesText;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        this.createTrustStoreConfigGroup(composite);
        this.cipherSuitesText = UIUtils.createLabelText((Composite)this.sslCertComposite, (String)MySQLUIMessages.mysql_ssl_configurator_label_cipher_suites, (String)"");
        this.cipherSuitesText.setToolTipText(MySQLUIMessages.mysql_ssl_configurator_label_cipher_suites_tip);
        Composite advGroup = UIUtils.createTitledComposite((Composite)composite, (String)MySQLUIMessages.mysql_ssl_configurator_legend_advanced, (int)2, (int)768);
        this.requireSSQL = UIUtils.createLabelCheckbox((Composite)advGroup, (String)MySQLUIMessages.mysql_ssl_configurator_checkbox_require_ssl, (String)MySQLUIMessages.mysql_ssl_configurator_checkbox_require_ssl_tip, (boolean)false);
        this.veryServerCert = UIUtils.createLabelCheckbox((Composite)advGroup, (String)MySQLUIMessages.mysql_ssl_configurator_checkbox_verify_server_certificate, (String)MySQLUIMessages.mysql_ssl_configurator_checkbox_verify_server_certificate_tip, (boolean)true);
        this.allowPublicKeyRetrieval = UIUtils.createLabelCheckbox((Composite)advGroup, (String)MySQLUIMessages.mysql_ssl_configurator_checkbox_allow_public_key, (String)MySQLUIMessages.mysql_ssl_configurator_checkbox_allow_public_key_tip, (boolean)false);
        if (this.getEditIntention() == DBPConnectionEditIntention.CREDENTIALS_ONLY) {
            this.cipherSuitesText.setEditable(false);
            this.requireSSQL.setEnabled(false);
            this.veryServerCert.setEnabled(false);
            this.allowPublicKeyRetrieval.setEnabled(false);
        }
    }

    protected boolean useCACertificate() {
        return true;
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.loadSettings(configuration);
        if (CommonUtils.isEmpty((String)configuration.getStringProperty("ssl.method"))) {
            this.caCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.ca.cert")));
            this.clientCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.client.cert")));
            this.clientKeyPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.client.key")));
        }
        this.requireSSQL.setSelection(configuration.getBooleanProperty("ssl.require", false));
        this.veryServerCert.setSelection(configuration.getBooleanProperty("ssl.verify.server", true));
        this.allowPublicKeyRetrieval.setSelection(configuration.getBooleanProperty("ssl.public.key.retrieve", false));
        this.cipherSuitesText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.cipher.suites")));
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.setProperty("ssl.require", (Object)String.valueOf(this.requireSSQL.getSelection()));
        configuration.setProperty("ssl.verify.server", (Object)String.valueOf(this.veryServerCert.getSelection()));
        configuration.setProperty("ssl.public.key.retrieve", (Object)String.valueOf(this.allowPublicKeyRetrieval.getSelection()));
        configuration.setProperty("ssl.cipher.suites", (Object)this.cipherSuitesText.getText());
    }
}

