# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: disable=too-many-statements
# pylint: disable=too-many-locals

from azure.cli.core.commands import CliCommandType


def load_command_table(self, _):

    from ..generated._client_factory import cf_account
    billing_account = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#BillingAccountsOperations.{}',
        client_factory=cf_account)
    with self.command_group('billing account', billing_account, client_factory=cf_account, is_preview=True) as g:
        g.custom_command('list', 'billing_account_list')
        g.custom_show_command('show', 'billing_account_show')
        g.custom_command('update', 'billing_account_update', supports_no_wait=True)
        g.custom_wait_command('wait', 'billing_account_show')

    from ..generated._client_factory import cf_balance
    billing_balance = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#AvailableBalancesOperations.{}',
        client_factory=cf_balance)
    with self.command_group('billing balance', billing_balance, client_factory=cf_balance, is_preview=True) as g:
        g.custom_show_command('show', 'billing_balance_show')

    from ..generated._client_factory import cf_instruction
    billing_instruction = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#InstructionsOperations.{}',
        client_factory=cf_instruction)
    with self.command_group('billing instruction', billing_instruction, client_factory=cf_instruction,
                            is_preview=True) as g:
        g.custom_command('list', 'billing_instruction_list')
        g.custom_show_command('show', 'billing_instruction_show')
        g.custom_command('create', 'billing_instruction_create')

    from ..generated._client_factory import cf_profile
    billing_profile = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#BillingProfilesOperations.{}',
        client_factory=cf_profile)
    with self.command_group('billing profile', billing_profile, client_factory=cf_profile, is_preview=True) as g:
        g.custom_command('list', 'billing_profile_list')
        g.custom_show_command('show', 'billing_profile_show')
        g.custom_command('create', 'billing_profile_create', supports_no_wait=True)
        g.custom_command('update', 'billing_profile_update', supports_no_wait=True)
        g.custom_wait_command('wait', 'billing_profile_show')

    from ..generated._client_factory import cf_customer
    billing_customer = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#CustomersOperations.{}',
        client_factory=cf_customer)
    with self.command_group('billing customer', billing_customer, client_factory=cf_customer, is_preview=True) as g:
        g.custom_command('list', 'billing_customer_list')
        g.custom_show_command('show', 'billing_customer_show')

    from ..generated._client_factory import cf_invoice_section
    billing_invoice_section = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#InvoiceSectionsOperations.{}',
        client_factory=cf_invoice_section)
    with self.command_group('billing invoice section', billing_invoice_section,
                            client_factory=cf_invoice_section) as g:
        g.custom_command('list', 'billing_invoice_section_list')
        g.custom_show_command('show', 'billing_invoice_section_show')
        g.custom_command('create', 'billing_invoice_section_create', supports_no_wait=True)
        g.custom_command('update', 'billing_invoice_section_update', supports_no_wait=True)
        g.custom_wait_command('wait', 'billing_invoice_section_show')

    from ..generated._client_factory import cf_permission
    billing_permission = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#BillingPermissionsOperations.{}',
        client_factory=cf_permission)
    with self.command_group('billing permission', billing_permission, client_factory=cf_permission,
                            is_preview=True) as g:
        g.custom_command('list', 'billing_permission_list')

    from ..generated._client_factory import cf_subscription
    billing_subscription = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#BillingSubscriptionsOperations.{}',
        client_factory=cf_subscription)
    with self.command_group('billing subscription', billing_subscription, client_factory=cf_subscription,
                            is_preview=True) as g:
        g.custom_command('list', 'billing_subscription_list')
        g.custom_show_command('show', 'billing_subscription_show')
        g.custom_command('update', 'billing_subscription_update')
        g.custom_command('move', 'billing_subscription_move', supports_no_wait=True)
        g.custom_command('validate-move', 'billing_subscription_validate_move')
        g.custom_wait_command('wait', 'billing_subscription_show')

    from ..generated._client_factory import cf_product
    billing_product = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#ProductsOperations.{}',
        client_factory=cf_product)
    with self.command_group('billing product', billing_product, client_factory=cf_product, is_preview=True) as g:
        g.custom_command('list', 'billing_product_list')
        g.custom_show_command('show', 'billing_product_show')
        g.custom_command('update', 'billing_product_update')
        g.custom_command('move', 'billing_product_move')
        g.custom_command('validate-move', 'billing_product_validate_move')

    from ..generated._client_factory import cf_invoice
    billing_invoice = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#InvoicesOperations.{}',
        client_factory=cf_invoice)
    with self.command_group('billing invoice', billing_invoice, client_factory=cf_invoice) as g:
        g.custom_command('list', 'billing_invoice_list')
        g.custom_show_command('show', 'billing_invoice_show')

    from ..generated._client_factory import cf_transaction
    billing_transaction = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#TransactionsOperations.{}',
        client_factory=cf_transaction)
    with self.command_group('billing transaction', billing_transaction, client_factory=cf_transaction,
                            is_preview=True) as g:
        g.custom_command('list', 'billing_transaction_list')

    from ..generated._client_factory import cf_policy
    billing_policy = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#PoliciesOperations.{}',
        client_factory=cf_policy)
    with self.command_group('billing policy', billing_policy, client_factory=cf_policy, is_preview=True) as g:
        g.custom_command('update', 'billing_policy_update')

    from ..generated._client_factory import cf_property
    billing_property = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#BillingPropertyOperations.{}',
        client_factory=cf_property)
    with self.command_group('billing property', billing_property, client_factory=cf_property, is_preview=True) as g:
        g.custom_show_command('show', 'billing_property_show')
        g.custom_command('update', 'billing_property_update')

    from ..generated._client_factory import cf_role_definition
    billing_role_definition = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#BillingRoleDefinitionsOperations.{}',
        client_factory=cf_role_definition)
    with self.command_group('billing role-definition', billing_role_definition, client_factory=cf_role_definition,
                            is_preview=True) as g:
        g.custom_command('list', 'billing_role_definition_list')

    from ..generated._client_factory import cf_role_assignment
    billing_role_assignment = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#BillingRoleAssignmentsOperations.{}',
        client_factory=cf_role_assignment)
    with self.command_group('billing role-assignment', billing_role_assignment, client_factory=cf_role_assignment,
                            is_preview=True) as g:
        g.custom_command('list', 'billing_role_assignment_list')
        g.custom_command('delete', 'billing_role_assignment_delete', confirmation=True)

    from ..generated._client_factory import cf_agreement
    billing_agreement = CliCommandType(
        operations_tmpl='azure.mgmt.billing.operations#AgreementsOperations.{}',
        client_factory=cf_agreement)
    with self.command_group('billing agreement', billing_agreement, client_factory=cf_agreement,
                            is_preview=True) as g:
        g.custom_command('list', 'billing_agreement_list')
        g.custom_show_command('show', 'billing_agreement_show')
