﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/states/SFN_EXPORTS.h>
#include <aws/states/model/ActivityListItem.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SFN {
namespace Model {
class ListActivitiesResult {
 public:
  AWS_SFN_API ListActivitiesResult() = default;
  AWS_SFN_API ListActivitiesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SFN_API ListActivitiesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of activities.</p>
   */
  inline const Aws::Vector<ActivityListItem>& GetActivities() const { return m_activities; }
  template <typename ActivitiesT = Aws::Vector<ActivityListItem>>
  void SetActivities(ActivitiesT&& value) {
    m_activitiesHasBeenSet = true;
    m_activities = std::forward<ActivitiesT>(value);
  }
  template <typename ActivitiesT = Aws::Vector<ActivityListItem>>
  ListActivitiesResult& WithActivities(ActivitiesT&& value) {
    SetActivities(std::forward<ActivitiesT>(value));
    return *this;
  }
  template <typename ActivitiesT = ActivityListItem>
  ListActivitiesResult& AddActivities(ActivitiesT&& value) {
    m_activitiesHasBeenSet = true;
    m_activities.emplace_back(std::forward<ActivitiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If <code>nextToken</code> is returned, there are more results available. The
   * value of <code>nextToken</code> is a unique pagination token for each page. Make
   * the call again using the returned token to retrieve the next page. Keep all
   * other arguments unchanged. Each pagination token expires after 24 hours. Using
   * an expired pagination token will return an <i>HTTP 400 InvalidToken</i>
   * error.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListActivitiesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListActivitiesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ActivityListItem> m_activities;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_activitiesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SFN
}  // namespace Aws
