/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.EvaluatedDlsFlsConfig;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v6.ActionGroupsV6;
import org.opensearch.security.securityconf.impl.v6.RoleMappingsV6;
import org.opensearch.security.securityconf.impl.v6.RoleV6;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;

public class ConfigModelV6
extends ConfigModel {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private ConfigConstants.RolesMappingResolution rolesMappingResolution;
    private ActionGroupResolver agr = null;
    private SecurityRoles securityRoles = null;
    private TenantHolder tenantHolder;
    private RoleMappingHolder roleMappingHolder;
    private SecurityDynamicConfiguration<RoleV6> roles;

    public ConfigModelV6(SecurityDynamicConfiguration<RoleV6> roles, SecurityDynamicConfiguration<ActionGroupsV6> actiongroups, SecurityDynamicConfiguration<RoleMappingsV6> rolesmapping, DynamicConfigModel dcm, Settings opensearchSettings) {
        this.roles = roles;
        try {
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.valueOf(opensearchSettings.get("plugins.security.roles_mapping_resolution", ConfigConstants.RolesMappingResolution.MAPPING_ONLY.toString()).toUpperCase());
        }
        catch (Exception e) {
            this.log.error("Cannot apply roles mapping resolution", (Throwable)e);
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.MAPPING_ONLY;
        }
        this.agr = this.reloadActionGroups(actiongroups);
        this.securityRoles = this.reload(roles);
        this.tenantHolder = new TenantHolder(roles);
        this.roleMappingHolder = new RoleMappingHolder(rolesmapping, dcm.getHostsResolverMode());
    }

    @Override
    public Set<String> getAllConfiguredTenantNames() {
        HashSet<String> configuredTenants = new HashSet<String>();
        for (Map.Entry<String, RoleV6> securityRole : this.roles.getCEntries().entrySet()) {
            Map<String, String> tenants = securityRole.getValue().getTenants();
            if (tenants == null) continue;
            configuredTenants.addAll(tenants.keySet());
        }
        return Collections.unmodifiableSet(configuredTenants);
    }

    @Override
    public SecurityRoles getSecurityRoles() {
        return this.securityRoles;
    }

    private ActionGroupResolver reloadActionGroups(final SecurityDynamicConfiguration<ActionGroupsV6> actionGroups) {
        return new ActionGroupResolver(){

            private Set<String> getGroupMembers(String groupname) {
                if (actionGroups == null) {
                    return Collections.emptySet();
                }
                return Collections.unmodifiableSet(this.resolve(actionGroups, groupname));
            }

            private Set<String> resolve(SecurityDynamicConfiguration<?> actionGroups2, String entry) {
                if (!actionGroups2.getCEntries().containsKey(entry)) {
                    return Collections.emptySet();
                }
                HashSet<String> ret = new HashSet<String>();
                Object actionGroupAsObject = actionGroups2.getCEntries().get(entry);
                if (actionGroupAsObject instanceof List) {
                    List actionGroupPermissions = (List)actionGroupAsObject;
                    for (String perm : actionGroupPermissions) {
                        if (actionGroups2.getCEntries().containsKey(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else if (actionGroupAsObject instanceof ActionGroupsV6) {
                    for (String perm : ((ActionGroupsV6)actionGroupAsObject).getPermissions()) {
                        if (actionGroups2.getCEntries().containsKey(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else {
                    throw new RuntimeException("Unable to handle " + String.valueOf(actionGroupAsObject));
                }
                return Collections.unmodifiableSet(ret);
            }

            @Override
            public Set<String> resolvedActions(List<String> actions) {
                HashSet<String> resolvedActions = new HashSet<String>();
                for (String string : actions) {
                    Set<String> groups = this.getGroupMembers(string);
                    if (groups.isEmpty()) {
                        resolvedActions.add(string);
                        continue;
                    }
                    resolvedActions.addAll(groups);
                }
                return Collections.unmodifiableSet(resolvedActions);
            }
        };
    }

    private SecurityRoles reload(SecurityDynamicConfiguration<RoleV6> settings) {
        HashSet<Future> futures = new HashSet<Future>(5000);
        ExecutorService execs = Executors.newFixedThreadPool(10);
        for (final Map.Entry<String, RoleV6> securityRole : settings.getCEntries().entrySet()) {
            Future future = execs.submit(new Callable<SecurityRole>(){

                @Override
                public SecurityRole call() throws Exception {
                    SecurityRole _securityRole = new SecurityRole((String)securityRole.getKey());
                    if (securityRole.getValue() == null) {
                        return null;
                    }
                    Set<String> permittedClusterActions = ConfigModelV6.this.agr.resolvedActions(((RoleV6)securityRole.getValue()).getCluster());
                    _securityRole.addClusterPerms(permittedClusterActions);
                    for (Map.Entry<String, String> entry : ((RoleV6)securityRole.getValue()).getTenants().entrySet()) {
                        if ("RW".equalsIgnoreCase(entry.getValue())) {
                            _securityRole.addTenant(new Tenant(entry.getKey(), true));
                            continue;
                        }
                        _securityRole.addTenant(new Tenant(entry.getKey(), false));
                    }
                    for (Map.Entry<String, Object> entry : ((RoleV6)securityRole.getValue()).getIndices().entrySet()) {
                        String dls = ((RoleV6.Index)entry.getValue()).get_dls_();
                        List<String> fls = ((RoleV6.Index)entry.getValue()).get_fls_();
                        List<String> maskedFields = ((RoleV6.Index)entry.getValue()).get_masked_fields_();
                        IndexPattern _indexPattern = new IndexPattern(entry.getKey());
                        _indexPattern.setDlsQuery(dls);
                        _indexPattern.addFlsFields(fls);
                        _indexPattern.addMaskedFields(maskedFields);
                        for (Map.Entry<String, List<String>> type : ((RoleV6.Index)entry.getValue()).getTypes().entrySet()) {
                            TypePerm typePerm = new TypePerm(type.getKey());
                            List<String> perms = type.getValue();
                            typePerm.addPerms(ConfigModelV6.this.agr.resolvedActions(perms));
                            _indexPattern.addTypePerms(typePerm);
                        }
                        _securityRole.addIndexPattern(_indexPattern);
                    }
                    return _securityRole;
                }
            });
            futures.add(future);
        }
        execs.shutdown();
        try {
            execs.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (1) while loading roles");
            return null;
        }
        try {
            SecurityRoles _securityRoles = new SecurityRoles(futures.size());
            for (Future future : futures) {
                _securityRoles.addSecurityRole((SecurityRole)future.get());
            }
            return _securityRoles;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (2) while loading roles");
            return null;
        }
        catch (ExecutionException e) {
            this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    private static String replaceProperties(String orig, User user) {
        if (user == null || orig == null) {
            return orig;
        }
        orig = orig.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
        orig = ConfigModelV6.replaceRoles(orig, user);
        for (Map.Entry<String, String> entry : user.getCustomAttributesMap().entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            orig = orig.replace("${" + entry.getKey() + "}", entry.getValue());
            orig = orig.replace("${" + entry.getKey().replace('.', '_') + "}", entry.getValue());
        }
        return orig;
    }

    private static String replaceRoles(String orig, User user) {
        String retVal = orig;
        if (orig.contains("${user.roles}") || orig.contains("${user_roles}")) {
            String commaSeparatedRoles = ConfigModelV6.toQuotedCommaSeparatedString(user.getRoles());
            retVal = orig.replace("${user.roles}", commaSeparatedRoles).replace("${user_roles}", commaSeparatedRoles);
        }
        return retVal;
    }

    private static String toQuotedCommaSeparatedString(Set<String> roles) {
        return Joiner.on((char)',').join(Iterables.transform(roles, s -> new StringBuilder(s.length() + 2).append('\"').append((String)s).append('\"').toString()));
    }

    private static boolean impliesTypePerm(Set<IndexPattern> ipatterns, IndexResolverReplacer.Resolved resolved, User user, String[] requestedActions, IndexNameExpressionResolver resolver, ClusterService cs) {
        IndexMatcherAndTypePermissions[] indexMatcherAndTypePermissions = resolved.isLocalAll() ? (IndexMatcherAndTypePermissions[])ipatterns.stream().filter(indexPattern -> "*".equals(indexPattern.getUnresolvedIndexPattern(user))).map(p -> new IndexMatcherAndTypePermissions(p.getResolvedIndexPattern(user, resolver, cs), p.getTypePerms())).toArray(IndexMatcherAndTypePermissions[]::new) : (IndexMatcherAndTypePermissions[])ipatterns.stream().map(p -> new IndexMatcherAndTypePermissions(p.getResolvedIndexPattern(user, resolver, cs), p.getTypePerms())).toArray(IndexMatcherAndTypePermissions[]::new);
        return resolved.getAllIndices().stream().allMatch(index -> resolved.getTypes().stream().allMatch(type -> Arrays.stream(requestedActions).allMatch(action -> Arrays.stream(indexMatcherAndTypePermissions).anyMatch(ipatp -> ipatp.matches((String)index, (String)type, (String)action)))));
    }

    @Override
    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.tenantHolder.mapTenants(user, roles);
    }

    @Override
    public Set<String> mapSecurityRoles(User user, TransportAddress caller) {
        return this.roleMappingHolder.map(user, caller);
    }

    private class RoleMappingHolder {
        private ListMultimap<String, String> users;
        private ListMultimap<List<WildcardMatcher>, String> abars;
        private ListMultimap<String, String> bars;
        private ListMultimap<String, String> hosts;
        private final String hostResolverMode;
        private List<WildcardMatcher> userMatchers;
        private List<WildcardMatcher> barMatchers;
        private List<WildcardMatcher> hostMatchers;

        private RoleMappingHolder(SecurityDynamicConfiguration<RoleMappingsV6> rolesMapping, String hostResolverMode) {
            this.hostResolverMode = hostResolverMode;
            if (rolesMapping != null) {
                this.users = ArrayListMultimap.create();
                this.abars = ArrayListMultimap.create();
                this.bars = ArrayListMultimap.create();
                this.hosts = ArrayListMultimap.create();
                for (Map.Entry<String, RoleMappingsV6> roleMap : rolesMapping.getCEntries().entrySet()) {
                    String roleMapKey = roleMap.getKey();
                    RoleMappingsV6 roleMapValue = roleMap.getValue();
                    for (String u : roleMapValue.getUsers()) {
                        this.users.put((Object)u, (Object)roleMapKey);
                    }
                    HashSet<String> abar = new HashSet<String>(roleMapValue.getAndBackendroles());
                    if (!abar.isEmpty()) {
                        this.abars.put(WildcardMatcher.matchers(abar), (Object)roleMapKey);
                    }
                    for (String bar : roleMapValue.getBackendroles()) {
                        this.bars.put((Object)bar, (Object)roleMapKey);
                    }
                    for (String host : roleMapValue.getHosts()) {
                        this.hosts.put((Object)host, (Object)roleMapKey);
                    }
                }
                this.userMatchers = WildcardMatcher.matchers(this.users.keySet());
                this.barMatchers = WildcardMatcher.matchers(this.bars.keySet());
                this.hostMatchers = WildcardMatcher.matchers(this.hosts.keySet());
            }
        }

        private Set<String> map(User user, TransportAddress caller) {
            if (user == null || this.users == null || this.abars == null || this.bars == null || this.hosts == null) {
                return Collections.emptySet();
            }
            HashSet<String> securityRoles = new HashSet<String>();
            if (ConfigModelV6.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV6.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BACKENDROLES_ONLY) {
                if (ConfigModelV6.this.log.isDebugEnabled()) {
                    ConfigModelV6.this.log.debug("Pass backendroles from {}", (Object)user);
                }
                securityRoles.addAll(user.getRoles());
            }
            if (ConfigModelV6.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV6.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.MAPPING_ONLY) {
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.userMatchers, user.getName())) {
                    securityRoles.addAll(this.users.get((Object)p2));
                }
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.barMatchers, user.getRoles())) {
                    securityRoles.addAll(this.bars.get((Object)p2));
                }
                for (List patterns : this.abars.keySet()) {
                    if (!patterns.stream().allMatch(p -> p.matchAny(user.getRoles()))) continue;
                    securityRoles.addAll(this.abars.get((Object)patterns));
                }
                if (caller != null) {
                    String ipAddress = caller.getAddress();
                    List<WildcardMatcher> hostMatchers = WildcardMatcher.matchers(this.hosts.keySet());
                    for (String p3 : WildcardMatcher.getAllMatchingPatterns(hostMatchers, ipAddress)) {
                        securityRoles.addAll(this.hosts.get((Object)p3));
                    }
                    if (caller.address() != null && (this.hostResolverMode.equalsIgnoreCase("ip-hostname") || this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup"))) {
                        String hostName = caller.address().getHostString();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(hostMatchers, hostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                    if (caller.address() != null && this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup")) {
                        String resolvedHostName = caller.address().getHostName();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(hostMatchers, resolvedHostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(securityRoles);
        }
    }

    private class TenantHolder {
        private SetMultimap<String, Tuple<String, Boolean>> tenantsMM = null;

        public TenantHolder(SecurityDynamicConfiguration<RoleV6> roles) {
            HashSet<Future> futures = new HashSet<Future>(roles.getCEntries().size());
            ExecutorService execs = Executors.newFixedThreadPool(10);
            for (final Map.Entry<String, RoleV6> securityRole : roles.getCEntries().entrySet()) {
                if (securityRole.getValue() == null) continue;
                Future future = execs.submit(new Callable<Tuple<String, Set<Tuple<String, Boolean>>>>(){

                    @Override
                    public Tuple<String, Set<Tuple<String, Boolean>>> call() throws Exception {
                        HashSet<Tuple> tuples = new HashSet<Tuple>();
                        Map<String, String> tenants = ((RoleV6)securityRole.getValue()).getTenants();
                        if (tenants != null) {
                            for (String tenant : tenants.keySet()) {
                                if ("RW".equalsIgnoreCase(tenants.get(tenant))) {
                                    tuples.add(new Tuple((Object)tenant, (Object)true));
                                    continue;
                                }
                                tuples.add(new Tuple((Object)tenant, (Object)false));
                            }
                        }
                        return new Tuple((Object)((String)securityRole.getKey()), tuples);
                    }
                });
                futures.add(future);
            }
            execs.shutdown();
            try {
                execs.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV6.this.log.error("Thread interrupted (1) while loading roles");
                return;
            }
            try {
                SetMultimap tenantsMM_ = MultimapBuilder.SetMultimapBuilder.hashKeys((int)futures.size()).hashSetValues(16).build();
                for (Future future : futures) {
                    Tuple result = (Tuple)future.get();
                    tenantsMM_.putAll((Object)((String)result.v1()), (Iterable)result.v2());
                }
                this.tenantsMM = tenantsMM_;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV6.this.log.error("Thread interrupted (2) while loading roles");
                return;
            }
            catch (ExecutionException e) {
                ConfigModelV6.this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
        }

        public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
            if (user == null || this.tenantsMM == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(roles.size());
            result.put(user.getName(), true);
            this.tenantsMM.entries().stream().filter(e -> roles.contains(e.getKey())).filter(e -> !user.getName().equals(((Tuple)e.getValue()).v1())).forEach(e -> {
                String tenant = (String)((Tuple)e.getValue()).v1();
                boolean rw = (Boolean)((Tuple)e.getValue()).v2();
                if (rw || !result.containsKey(tenant)) {
                    result.put(tenant, rw);
                }
            });
            return Collections.unmodifiableMap(result);
        }
    }

    private static final class IndexMatcherAndTypePermissions {
        private static final Logger log = LogManager.getLogger(IndexMatcherAndTypePermissions.class);
        private final WildcardMatcher matcher;
        private final Set<TypePerm> typePerms;

        public IndexMatcherAndTypePermissions(Set<String> pattern, Set<TypePerm> typePerms) {
            this.matcher = WildcardMatcher.from(pattern);
            this.typePerms = typePerms;
        }

        private static String b2s(boolean matches) {
            return matches ? "matches" : "does not match";
        }

        public boolean matches(String index, String type, String action) {
            boolean isDebugEnabled = log.isDebugEnabled();
            boolean matchIndex = this.matcher.test(index);
            if (isDebugEnabled) {
                log.debug("index {} {} index pattern {}", (Object)index, (Object)IndexMatcherAndTypePermissions.b2s(matchIndex), (Object)this.matcher);
            }
            if (matchIndex) {
                return this.typePerms.stream().anyMatch(tp -> {
                    boolean matchType = tp.getTypeMatcher().test(type);
                    if (isDebugEnabled) {
                        log.debug("type {} {} type pattern {}", (Object)type, (Object)IndexMatcherAndTypePermissions.b2s(matchType), (Object)tp.getTypeMatcher());
                    }
                    if (matchType) {
                        boolean matchAction = tp.getPerms().test(action);
                        if (isDebugEnabled) {
                            log.debug("action {} {} action pattern {}", (Object)action, (Object)IndexMatcherAndTypePermissions.b2s(matchAction), (Object)tp.getPerms());
                        }
                        return matchAction;
                    }
                    return false;
                });
            }
            return false;
        }
    }

    public static class Tenant {
        private final String tenant;
        private final boolean readWrite;

        private Tenant(String tenant, boolean readWrite) {
            this.tenant = tenant;
            this.readWrite = readWrite;
        }

        public String getTenant() {
            return this.tenant;
        }

        public boolean isReadWrite() {
            return this.readWrite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.readWrite ? 1231 : 1237);
            result = 31 * result + (this.tenant == null ? 0 : this.tenant.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tenant other = (Tenant)obj;
            if (this.readWrite != other.readWrite) {
                return false;
            }
            return !(this.tenant == null ? other.tenant != null : !this.tenant.equals(other.tenant));
        }

        public String toString() {
            return System.lineSeparator() + "                tenant=" + this.tenant + System.lineSeparator() + "                readWrite=" + this.readWrite;
        }
    }

    public static class TypePerm {
        private final WildcardMatcher typeMatcher;
        private final Set<String> perms = new HashSet<String>();

        private TypePerm(String typePattern) {
            this.typeMatcher = WildcardMatcher.ANY;
        }

        private TypePerm addPerms(Collection<String> perms) {
            if (perms != null) {
                this.perms.addAll(perms);
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.perms == null ? 0 : this.perms.hashCode());
            result = 31 * result + (this.typeMatcher == null ? 0 : this.typeMatcher.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypePerm other = (TypePerm)obj;
            if (this.perms == null ? other.perms != null : !this.perms.equals(other.perms)) {
                return false;
            }
            return !(this.typeMatcher == null ? other.typeMatcher != null : !this.typeMatcher.equals(other.typeMatcher));
        }

        public String toString() {
            return System.lineSeparator() + "             typePattern=" + String.valueOf(this.typeMatcher) + System.lineSeparator() + "             perms=" + String.valueOf(this.perms);
        }

        public WildcardMatcher getTypeMatcher() {
            return this.typeMatcher;
        }

        public WildcardMatcher getPerms() {
            return WildcardMatcher.from(this.perms);
        }
    }

    public static class IndexPattern {
        private final String indexPattern;
        private String dlsQuery;
        private final Set<String> fls = new HashSet<String>();
        private final Set<String> maskedFields = new HashSet<String>();
        private final Set<TypePerm> typePerms = new HashSet<TypePerm>();

        public IndexPattern(String indexPattern) {
            this.indexPattern = Objects.requireNonNull(indexPattern);
        }

        public IndexPattern addFlsFields(List<String> flsFields) {
            if (flsFields != null) {
                this.fls.addAll(flsFields);
            }
            return this;
        }

        public IndexPattern addMaskedFields(List<String> maskedFields) {
            if (maskedFields != null) {
                this.maskedFields.addAll(maskedFields);
            }
            return this;
        }

        public IndexPattern addTypePerms(TypePerm typePerm) {
            if (typePerm != null) {
                this.typePerms.add(typePerm);
            }
            return this;
        }

        public IndexPattern setDlsQuery(String dlsQuery) {
            if (dlsQuery != null) {
                this.dlsQuery = dlsQuery;
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dlsQuery == null ? 0 : this.dlsQuery.hashCode());
            result = 31 * result + (this.fls == null ? 0 : this.fls.hashCode());
            result = 31 * result + (this.maskedFields == null ? 0 : this.maskedFields.hashCode());
            result = 31 * result + (this.indexPattern == null ? 0 : this.indexPattern.hashCode());
            result = 31 * result + (this.typePerms == null ? 0 : this.typePerms.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPattern other = (IndexPattern)obj;
            if (this.dlsQuery == null ? other.dlsQuery != null : !this.dlsQuery.equals(other.dlsQuery)) {
                return false;
            }
            if (this.fls == null ? other.fls != null : !this.fls.equals(other.fls)) {
                return false;
            }
            if (this.maskedFields == null ? other.maskedFields != null : !this.maskedFields.equals(other.maskedFields)) {
                return false;
            }
            if (this.indexPattern == null ? other.indexPattern != null : !this.indexPattern.equals(other.indexPattern)) {
                return false;
            }
            return !(this.typePerms == null ? other.typePerms != null : !this.typePerms.equals(other.typePerms));
        }

        public String toString() {
            return System.lineSeparator() + "        indexPattern=" + this.indexPattern + System.lineSeparator() + "          dlsQuery=" + this.dlsQuery + System.lineSeparator() + "          fls=" + String.valueOf(this.fls) + System.lineSeparator() + "          typePerms=" + String.valueOf(this.typePerms);
        }

        public String getUnresolvedIndexPattern(User user) {
            return ConfigModelV6.replaceProperties(this.indexPattern, user);
        }

        private Set<String> getResolvedIndexPattern(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            String[] aliasesForPermittedPattern;
            String unresolved = this.getUnresolvedIndexPattern(user);
            WildcardMatcher matcher = WildcardMatcher.from(unresolved);
            String[] resolved = null;
            if (!(matcher instanceof WildcardMatcher.Exact) && (aliasesForPermittedPattern = (String[])cs.state().getMetadata().getIndicesLookup().entrySet().stream().filter(e -> ((IndexAbstraction)e.getValue()).getType() == IndexAbstraction.Type.ALIAS).filter(e -> matcher.test((String)e.getKey())).map(e -> (String)e.getKey()).toArray(String[]::new)).length > 0) {
                resolved = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), aliasesForPermittedPattern);
            }
            if (resolved == null && !unresolved.isEmpty()) {
                resolved = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), new String[]{unresolved});
            }
            if (resolved == null || resolved.length == 0) {
                return ImmutableSet.of((Object)unresolved);
            }
            return ImmutableSet.builder().addAll(Arrays.asList(resolved)).add((Object)unresolved).build();
        }

        public String getDlsQuery(User user) {
            return ConfigModelV6.replaceProperties(this.dlsQuery, user);
        }

        public Set<String> getFls() {
            return Collections.unmodifiableSet(this.fls);
        }

        public Set<String> getMaskedFields() {
            return Collections.unmodifiableSet(this.maskedFields);
        }

        public Set<TypePerm> getTypePerms() {
            return Collections.unmodifiableSet(this.typePerms);
        }
    }

    public static class SecurityRole {
        private final String name;
        private final Set<Tenant> tenants = new HashSet<Tenant>();
        private final Set<IndexPattern> ipatterns = new HashSet<IndexPattern>();
        private final Set<String> clusterPerms = new HashSet<String>();

        private SecurityRole(String name) {
            this.name = Objects.requireNonNull(name);
        }

        private boolean impliesClusterPermission(String action) {
            return WildcardMatcher.from(this.clusterPerms).test(action);
        }

        private Set<String> getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs, boolean matchExplicitly) {
            HashSet retVal = new HashSet();
            for (IndexPattern p : this.ipatterns) {
                boolean patternMatch = false;
                Set<TypePerm> tperms = p.getTypePerms();
                for (TypePerm tp : tperms) {
                    WildcardMatcher matcher = matchExplicitly && tp.getPerms() == WildcardMatcher.ANY ? WildcardMatcher.NONE : tp.getTypeMatcher();
                    if (!matcher.matchAny(resolved.getTypes())) continue;
                    patternMatch = tp.getPerms().matchAll(actions);
                }
                if (!patternMatch) continue;
                WildcardMatcher permitted = WildcardMatcher.from(p.getResolvedIndexPattern(user, resolver, cs));
                HashSet res = new HashSet();
                if (!(resolved.isLocalAll() || resolved.getAllIndices().contains("*") || resolved.getAllIndices().contains("_all"))) {
                    resolved.getAllIndices().stream().filter(permitted).forEach(res::add);
                } else {
                    Arrays.stream(cs.state().metadata().getConcreteAllOpenIndices()).filter(permitted).forEach(res::add);
                }
                retVal.addAll(res);
            }
            return Collections.unmodifiableSet(retVal);
        }

        private SecurityRole addTenant(Tenant tenant) {
            if (tenant != null) {
                this.tenants.add(tenant);
            }
            return this;
        }

        private SecurityRole addIndexPattern(IndexPattern indexPattern) {
            if (indexPattern != null) {
                this.ipatterns.add(indexPattern);
            }
            return this;
        }

        private SecurityRole addClusterPerms(Collection<String> clusterPerms) {
            if (clusterPerms != null) {
                this.clusterPerms.addAll(clusterPerms);
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clusterPerms == null ? 0 : this.clusterPerms.hashCode());
            result = 31 * result + (this.ipatterns == null ? 0 : this.ipatterns.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.tenants == null ? 0 : this.tenants.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityRole other = (SecurityRole)obj;
            if (this.clusterPerms == null ? other.clusterPerms != null : !this.clusterPerms.equals(other.clusterPerms)) {
                return false;
            }
            if (this.ipatterns == null ? other.ipatterns != null : !this.ipatterns.equals(other.ipatterns)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.tenants == null ? other.tenants != null : !this.tenants.equals(other.tenants));
        }

        public String toString() {
            return System.lineSeparator() + "  " + this.name + System.lineSeparator() + "    tenants=" + String.valueOf(this.tenants) + System.lineSeparator() + "    ipatterns=" + String.valueOf(this.ipatterns) + System.lineSeparator() + "    clusterPerms=" + String.valueOf(this.clusterPerms);
        }

        public Set<Tenant> getTenants(User user) {
            return Collections.unmodifiableSet(this.tenants);
        }

        public Set<IndexPattern> getIpatterns() {
            return Collections.unmodifiableSet(this.ipatterns);
        }

        public Set<String> getClusterPerms() {
            return Collections.unmodifiableSet(this.clusterPerms);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SecurityRoles
    implements org.opensearch.security.securityconf.SecurityRoles {
        protected final Logger log = LogManager.getLogger(this.getClass());
        final Set<SecurityRole> roles;

        private SecurityRoles(int roleCount) {
            this.roles = new HashSet<SecurityRole>(roleCount);
        }

        private SecurityRoles addSecurityRole(SecurityRole securityRole) {
            if (securityRole != null) {
                this.roles.add(securityRole);
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityRoles other = (SecurityRoles)obj;
            return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
        }

        public String toString() {
            return "roles=" + String.valueOf(this.roles);
        }

        public Set<SecurityRole> getRoles() {
            return Collections.unmodifiableSet(this.roles);
        }

        @Override
        public Set<String> getRoleNames() {
            return this.getRoles().stream().map(r -> r.getName()).collect(Collectors.toSet());
        }

        @Override
        public SecurityRoles filter(Set<String> keep) {
            SecurityRoles retVal = new SecurityRoles(this.roles.size());
            for (SecurityRole sr : this.roles) {
                if (!keep.contains(sr.getName())) continue;
                retVal.addSecurityRole(sr);
            }
            return retVal;
        }

        @Override
        public EvaluatedDlsFlsConfig getDlsFls(User user, boolean dfmEmptyOverwritesAll, IndexNameExpressionResolver resolver, ClusterService cs, NamedXContentRegistry namedXContentRegistry) {
            HashMap<String, Set<String>> dlsQueries = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> flsFields = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> maskedFieldsMap = new HashMap<String, Set<String>>();
            for (SecurityRole sr : this.roles) {
                for (IndexPattern ip : sr.getIpatterns()) {
                    Set<String> fls = ip.getFls();
                    String dls = ip.getDlsQuery(user);
                    String indexPattern = ip.getUnresolvedIndexPattern(user);
                    Set<String> maskedFields = ip.getMaskedFields();
                    Set<Object> concreteIndices = new HashSet();
                    if (dls != null && dls.length() > 0 || fls != null && fls.size() > 0 || maskedFields != null && maskedFields.size() > 0) {
                        concreteIndices = ip.getResolvedIndexPattern(user, resolver, cs);
                    }
                    if (dls != null && dls.length() > 0) {
                        Set dlsQuery = (Set)dlsQueries.get(indexPattern);
                        if (dlsQuery != null) {
                            dlsQuery.add(dls);
                        } else {
                            dlsQueries.put(indexPattern, new HashSet<String>(Arrays.asList(dls)));
                        }
                        for (String string : concreteIndices) {
                            dlsQuery = (Set)dlsQueries.get(string);
                            if (dlsQuery != null) {
                                dlsQuery.add(dls);
                                continue;
                            }
                            dlsQueries.put(string, new HashSet<String>(Arrays.asList(dls)));
                        }
                    }
                    if (fls != null && fls.size() > 0) {
                        Set flsField = (Set)flsFields.get(indexPattern);
                        if (flsField != null) {
                            flsField.addAll(fls);
                        } else {
                            flsFields.put(indexPattern, new HashSet<String>(fls));
                        }
                        for (String string : concreteIndices) {
                            flsField = (Set)flsFields.get(string);
                            if (flsField != null) {
                                flsField.addAll(fls);
                                continue;
                            }
                            flsFields.put(string, new HashSet<String>(fls));
                        }
                    }
                    if (maskedFields == null || maskedFields.size() <= 0) continue;
                    if (maskedFieldsMap.containsKey(indexPattern)) {
                        ((Set)maskedFieldsMap.get(indexPattern)).addAll(Sets.newHashSet(maskedFields));
                    } else {
                        maskedFieldsMap.put(indexPattern, new HashSet());
                        ((Set)maskedFieldsMap.get(indexPattern)).addAll(Sets.newHashSet(maskedFields));
                    }
                    for (String string : concreteIndices) {
                        if (maskedFieldsMap.containsKey(string)) {
                            ((Set)maskedFieldsMap.get(string)).addAll(Sets.newHashSet(maskedFields));
                            continue;
                        }
                        maskedFieldsMap.put(string, new HashSet());
                        ((Set)maskedFieldsMap.get(string)).addAll(Sets.newHashSet(maskedFields));
                    }
                }
            }
            return new EvaluatedDlsFlsConfig(dlsQueries, flsFields, maskedFieldsMap);
        }

        @Override
        public boolean hasExplicitIndexPermission(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<String> indicesForRequest = new HashSet<String>(resolved.getAllIndicesResolved(cs, resolver));
            if (indicesForRequest.isEmpty()) {
                return false;
            }
            Set explicitlyAllowedIndices = this.roles.stream().map(role -> role.getAllResolvedPermittedIndices(resolved, user, actions, resolver, cs, true)).flatMap(Collection::stream).collect(Collectors.toSet());
            if (this.log.isDebugEnabled()) {
                this.log.debug("ExplicitIndexPermission check indices for request {}, explicitly allowed indices {}", (Object)((Object)indicesForRequest).toString(), (Object)explicitlyAllowedIndices.toString());
            }
            indicesForRequest.removeAll(explicitlyAllowedIndices);
            return indicesForRequest.isEmpty();
        }

        @Override
        public Set<String> getAllPermittedIndicesForDashboards(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<String> retVal = new HashSet<String>();
            for (SecurityRole sr : this.roles) {
                retVal.addAll(sr.getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved._LOCAL_ALL, user, actions, resolver, cs, false));
                retVal.addAll(resolved.getRemoteIndices());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public Set<String> reduce(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<String> retVal = new HashSet<String>();
            for (SecurityRole sr : this.roles) {
                retVal.addAll(sr.getAllResolvedPermittedIndices(resolved, user, actions, resolver, cs, false));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reduced requested resolved indices {} to permitted indices {}.", (Object)resolved, (Object)((Object)retVal).toString());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public boolean get(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            for (SecurityRole sr : this.roles) {
                if (!ConfigModelV6.impliesTypePerm(sr.getIpatterns(), resolved, user, actions, resolver, cs)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean impliesClusterPermissionPermission(String action) {
            return this.roles.stream().filter((? super T r) -> r.impliesClusterPermission(action)).count() > 0L;
        }

        @Override
        public boolean hasExplicitClusterPermissionPermission(String action) {
            return this.roles.stream().map(r -> {
                WildcardMatcher m = WildcardMatcher.from(r.clusterPerms);
                return m == WildcardMatcher.ANY ? WildcardMatcher.NONE : m;
            }).filter((? super T m) -> m.test(action)).count() > 0L;
        }

        @Override
        public boolean impliesTypePermGlobal(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<IndexPattern> ipatterns = new HashSet<IndexPattern>();
            this.roles.stream().forEach(p -> ipatterns.addAll(p.getIpatterns()));
            return ConfigModelV6.impliesTypePerm(ipatterns, resolved, user, actions, resolver, cs);
        }

        @Override
        public boolean isPermittedOnSystemIndex(String indexName) {
            boolean isPatternMatched = false;
            boolean isPermitted = false;
            for (SecurityRole role : this.roles) {
                for (IndexPattern ip : role.getIpatterns()) {
                    WildcardMatcher wildcardMatcher = WildcardMatcher.from(ip.indexPattern);
                    if (wildcardMatcher.test(indexName)) {
                        isPatternMatched = true;
                    }
                    for (TypePerm tp : ip.getTypePerms()) {
                        if (!tp.perms.contains("system:admin/system_index")) continue;
                        isPermitted = true;
                    }
                }
            }
            return isPatternMatched && isPermitted;
        }
    }

    private static interface ActionGroupResolver {
        public Set<String> resolvedActions(List<String> var1);
    }
}

